/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.content.Context;
import android.os.Build;
import android.renderscript.RenderScript;
import android.util.Log;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

final class SharedBlurManager {
    private static AtomicInteger count;
    private static Context applicationContext;
    private static RenderScript renderScript;
    private static ExecutorService executorService;

    SharedBlurManager() {
    }

    static synchronized void addRenderscriptContext(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            return;
        }
        if (count == null) {
            count = new AtomicInteger(0);
        }
        count.addAndGet(1);
        if (applicationContext == null) {
            applicationContext = context.getApplicationContext();
        }
    }

    static synchronized void removeRenderscriptContext() {
        int c = count.decrementAndGet();
        if (c == 0) {
            applicationContext = null;
            if (renderScript != null) {
                renderScript.destroy();
            }
            renderScript = null;
        }
    }

    static synchronized RenderScript getRenderScriptContext() {
        if (renderScript == null && applicationContext != null) {
            try {
                renderScript = RenderScript.create((Context)applicationContext);
            }
            catch (Exception e) {
                Log.e((String)BlurManager.class.getSimpleName(), (String)e.getLocalizedMessage());
            }
        }
        return renderScript;
    }

    static synchronized ExecutorService getExecutorService() {
        if (executorService == null || executorService.isShutdown()) {
            executorService = Executors.newCachedThreadPool();
        }
        return executorService;
    }
}

