/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;
import java.lang.ref.WeakReference;

final class GaussianRenderscriptBlurAlgorithm
implements BlurAlgorithm {
    private WeakReference<RenderScript> renderscript;

    GaussianRenderscriptBlurAlgorithm() {
    }

    @Override
    public void setRenderscript(RenderScript renderscript) {
        this.renderscript = new WeakReference<RenderScript>(renderscript);
    }

    @Override
    public Bitmap blur(Bitmap original, int radius, BlurOptions options) throws RenderscriptException {
        Allocation output;
        Allocation input;
        RenderScript rs = (RenderScript)this.renderscript.get();
        if (rs == null) {
            throw new RenderscriptException("Renderscript is null!");
        }
        try {
            input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)original);
            output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            ScriptIntrinsicBlur script = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            script.setRadius((float)radius);
            script.setInput(input);
            script.forEach(output);
        }
        catch (Exception e) {
            throw new RenderscriptException("Renderscript error while blurring!");
        }
        if (!options.isStaticBlur()) {
            Bitmap bitmap = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            output.copyTo(bitmap);
            input.destroy();
            output.destroy();
            return bitmap;
        }
        if (original.isMutable()) {
            output.copyTo(original);
            input.destroy();
            output.destroy();
            return original;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        original.recycle();
        output.copyTo(bitmap);
        input.destroy();
        output.destroy();
        return bitmap;
    }
}

