/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.graphics.Bitmap;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.algorithms.ConvolveBaseBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;

final class GaussianBlurAlgorithm
extends ConvolveBaseBlurAlgorithm {
    private int radius = 0;

    GaussianBlurAlgorithm() {
    }

    @Override
    float[] getFilter() {
        int i;
        float[] filter = new float[this.radius * 2 + 1];
        float sigma = (float)(this.radius * 2 + 2) / 6.0f;
        double coeff = 1.0 / Math.sqrt(Math.PI * 2 * (double)sigma * (double)sigma);
        double exponent = -1.0 / (double)(2.0f * sigma * sigma);
        float sum = 0.0f;
        for (i = 0; i < filter.length; ++i) {
            float value;
            double x = i - this.radius;
            filter[i] = value = (float)(coeff * Math.exp(exponent * x * x));
            sum += value;
        }
        if (sum != 0.0f) {
            sum = 1.0f / sum;
        }
        for (i = 0; i < filter.length; ++i) {
            filter[i] = filter[i] * sum;
        }
        return filter;
    }

    @Override
    public Bitmap blur(Bitmap original, int radius, BlurOptions options) throws RenderscriptException {
        this.radius = radius;
        return super.blur(original, 1, options);
    }
}

