/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicConvolve3x3;
import android.renderscript.Type;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;
import java.lang.ref.WeakReference;

final class Gaussian3x3RenderscriptBlurAlgorithm
implements BlurAlgorithm {
    private final float[] coefficientMatrix = new float[]{0.0387f, 0.1194f, 0.0387f, 0.1194f, 0.3676f, 0.1194f, 0.0387f, 0.1194f, 0.0387f};
    private WeakReference<RenderScript> renderscript;

    Gaussian3x3RenderscriptBlurAlgorithm() {
    }

    @Override
    public void setRenderscript(RenderScript renderscript) {
        this.renderscript = new WeakReference<RenderScript>(renderscript);
    }

    @Override
    public Bitmap blur(Bitmap original, int radius, BlurOptions options) throws RenderscriptException {
        Bitmap bitmap;
        Allocation output;
        RenderScript rs = (RenderScript)this.renderscript.get();
        if (rs == null) {
            throw new RenderscriptException("Renderscript is null!");
        }
        try {
            Allocation input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)original);
            output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            ScriptIntrinsicConvolve3x3 script = ScriptIntrinsicConvolve3x3.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            script.setCoefficients(this.coefficientMatrix);
            for (int i = 0; i < radius; ++i) {
                script.setInput(input);
                script.forEach(output);
                if (input != output) {
                    input.destroy();
                }
                input = output;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RenderscriptException("Renderscript error while blurring! \n" + e.getLocalizedMessage());
        }
        if (!options.isStaticBlur()) {
            bitmap = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            output.copyTo(bitmap);
            output.destroy();
            return bitmap;
        }
        if (original.isMutable()) {
            output.copyTo(original);
            output.destroy();
            return original;
        }
        bitmap = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        original.recycle();
        output.copyTo(bitmap);
        output.destroy();
        return bitmap;
    }
}

