/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.renderscript.RenderScript;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;
import com.stefanosiano.powerfulimageview.blur.algorithms.SharedBlurManager;
import java.util.ArrayList;
import java.util.concurrent.Callable;

abstract class ConvolveBaseBlurAlgorithm
implements BlurAlgorithm {
    private int w;
    private int h;

    ConvolveBaseBlurAlgorithm() {
    }

    @Override
    public void setRenderscript(RenderScript renderscript) {
    }

    @Override
    public Bitmap blur(Bitmap original, int radius, BlurOptions options) throws RenderscriptException {
        this.w = original.getWidth();
        this.h = original.getHeight();
        int[] pix = new int[this.w * this.h];
        original.getPixels(pix, 0, this.w, 0, 0, this.w, this.h);
        int cores = Math.min(options.getNumThreads(), Runtime.getRuntime().availableProcessors());
        if (cores <= 0) {
            cores = Runtime.getRuntime().availableProcessors();
        }
        ArrayList<BlurTask> horizontal = new ArrayList<BlurTask>(cores);
        ArrayList<BlurTask> vertical = new ArrayList<BlurTask>(cores);
        for (int i = 0; i < cores; ++i) {
            horizontal.add(new BlurTask(pix, this.w, this.h, radius, cores, i, 1));
            vertical.add(new BlurTask(pix, this.w, this.h, radius, cores, i, 2));
        }
        try {
            SharedBlurManager.getExecutorService().invokeAll(horizontal);
            SharedBlurManager.getExecutorService().invokeAll(vertical);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (!options.isStaticBlur()) {
            return Bitmap.createBitmap((int[])pix, (int)0, (int)this.w, (int)this.w, (int)this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (original.isMutable()) {
            original.setPixels(pix, 0, this.w, 0, 0, this.w, this.h);
            return original;
        }
        original.recycle();
        return Bitmap.createBitmap((int[])pix, (int)0, (int)this.w, (int)this.w, (int)this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private int getPixel(int x, int y, int[] pix) {
        if (x < 0) {
            x = 0;
        }
        if (x >= this.w) {
            x = this.w - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.h) {
            y = this.h - 1;
        }
        return pix[y * this.w + x];
    }

    abstract float[] getFilter();

    private void apply(int[] srcPix, int w, int h, int radius, int cores, int core, int step) {
        int iteration;
        float[] gaussianFilter = this.getFilter();
        int filterLength = gaussianFilter.length;
        int[] tmpPix = new int[filterLength];
        if (step == 1) {
            for (iteration = 0; iteration < radius; ++iteration) {
                int minY = core * h / cores;
                int maxY = (core + 1) * h / cores;
                int minIndex = minY * w;
                for (int y = minY; y < maxY; ++y) {
                    int row = y * w;
                    int position = 0;
                    for (int x = 0; x < w; ++x) {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        int a = 0;
                        for (int i = 0; i < filterLength; ++i) {
                            int pixel = this.getPixel(x + i - filterLength / 2, y, srcPix);
                            r = (int)((float)r + (float)Color.red((int)pixel) * gaussianFilter[i]);
                            g = (int)((float)g + (float)Color.green((int)pixel) * gaussianFilter[i]);
                            b = (int)((float)b + (float)Color.blue((int)pixel) * gaussianFilter[i]);
                            a = (int)((float)a + (float)Color.alpha((int)pixel) * gaussianFilter[i]);
                        }
                        int sum = Color.argb((int)a, (int)r, (int)g, (int)b);
                        position = row + x;
                        if (position >= minIndex + filterLength) {
                            srcPix[position - filterLength] = tmpPix[position % filterLength];
                        }
                        tmpPix[position % filterLength] = sum;
                    }
                    ++position;
                    for (int i = 0; i < filterLength; ++i) {
                        srcPix[position - filterLength + i] = tmpPix[(position + i) % filterLength];
                    }
                }
            }
        }
        if (step == 2) {
            for (iteration = 0; iteration < radius; ++iteration) {
                int minX = core * w / cores;
                int maxX = (core + 1) * w / cores;
                for (int x = minX; x < maxX; ++x) {
                    int row = x;
                    int position = 0;
                    for (int y = 0; y < h; ++y) {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        int a = 0;
                        for (int i = 0; i < filterLength; ++i) {
                            int pixel = this.getPixel(x, y + i - filterLength / 2, srcPix);
                            r = (int)((float)r + (float)Color.red((int)pixel) * gaussianFilter[i]);
                            g = (int)((float)g + (float)Color.green((int)pixel) * gaussianFilter[i]);
                            b = (int)((float)b + (float)Color.blue((int)pixel) * gaussianFilter[i]);
                            a = (int)((float)a + (float)Color.alpha((int)pixel) * gaussianFilter[i]);
                        }
                        int sum = Color.argb((int)a, (int)r, (int)g, (int)b);
                        if (position >= filterLength) {
                            srcPix[row - filterLength * w] = tmpPix[position % filterLength];
                        }
                        tmpPix[position % filterLength] = sum;
                        ++position;
                        row += w;
                    }
                    for (int i = 0; i < filterLength; ++i) {
                        srcPix[row - (filterLength - i) * w] = tmpPix[(position + i) % filterLength];
                    }
                }
            }
        }
    }

    private class BlurTask
    implements Callable<Void> {
        private final int[] _src;
        private final int _w;
        private final int _h;
        private final int _totalCores;
        private final int _radius;
        private final int _coreIndex;
        private final int _round;

        BlurTask(int[] src, int w, int h, int radius, int totalCores, int coreIndex, int round) {
            this._src = src;
            this._w = w;
            this._h = h;
            this._radius = radius;
            this._totalCores = totalCores;
            this._coreIndex = coreIndex;
            this._round = round;
        }

        @Override
        public Void call() throws Exception {
            ConvolveBaseBlurAlgorithm.this.apply(this._src, this._w, this._h, this._radius, this._totalCores, this._coreIndex, this._round);
            return null;
        }
    }
}

