/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur.algorithms;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.renderscript.RenderScript;
import android.util.Log;
import android.widget.ImageView;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.PivBlurMode;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Box3x3BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Box3x3RenderscriptBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Box5x5BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Box5x5RenderscriptBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.DummyBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Gaussian3x3BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Gaussian3x3RenderscriptBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Gaussian5x5BlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.Gaussian5x5RenderscriptBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.GaussianBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.GaussianRenderscriptBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.RenderscriptException;
import com.stefanosiano.powerfulimageview.blur.algorithms.SharedBlurManager;
import com.stefanosiano.powerfulimageview.blur.algorithms.StackBlurAlgorithm;
import com.stefanosiano.powerfulimageview.blur.algorithms.StackRenderscriptBlurAlgorithm;
import java.lang.ref.WeakReference;

public final class BlurManager
implements BlurOptions.BlurOptionsListener {
    private Drawable mDrawable;
    private Bitmap mOriginalBitmap;
    private Bitmap mBlurredBitmap;
    private BlurOptions mBlurOptions;
    private PivBlurMode mMode;
    private int mRadius;
    private boolean mIsRenderscriptManaged;
    private boolean mIsAlreadyBlurred;
    private Box3x3BlurAlgorithm mBox3x3BlurAlgorithm;
    private Box3x3RenderscriptBlurAlgorithm mBox3x3RenderscriptBlurAlgorithm;
    private Box5x5BlurAlgorithm mBox5x5BlurAlgorithm;
    private Box5x5RenderscriptBlurAlgorithm mBox5x5RenderscriptBlurAlgorithm;
    private Gaussian5x5BlurAlgorithm mGaussian5x5BlurAlgorithm;
    private Gaussian5x5RenderscriptBlurAlgorithm mGaussian5x5RenderscriptBlurAlgorithm;
    private Gaussian3x3BlurAlgorithm mGaussian3x3BlurAlgorithm;
    private Gaussian3x3RenderscriptBlurAlgorithm mGaussian3x3RenderscriptBlurAlgorithm;
    private GaussianBlurAlgorithm mGaussianBlurAlgorithm;
    private GaussianRenderscriptBlurAlgorithm mGaussianRenderscriptBlurAlgorithm;
    private StackBlurAlgorithm mStackBlurAlgorithm;
    private StackRenderscriptBlurAlgorithm mStackRenderscriptBlurAlgorithm;
    private DummyBlurAlgorithm mDummyBlurAlgorithm;
    private BlurAlgorithm mBlurAlgorithm;
    private int mWidth;
    private int mHeight;
    private int mLastSizeX;
    private int mLastSizeY;
    private int mLastRadius;
    private final WeakReference<ImageView> mView;

    public BlurManager(ImageView view, BlurOptions blurOptions) {
        this.mView = new WeakReference<ImageView>(view);
        this.mBlurOptions = blurOptions;
        this.mMode = PivBlurMode.DISABLED;
        this.mLastRadius = -1;
        this.mRadius = 0;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mLastSizeX = 0;
        this.mLastSizeY = 0;
        this.mIsRenderscriptManaged = false;
        this.mIsAlreadyBlurred = false;
    }

    public void changeDrawable(Drawable drawable) {
        Drawable mLastDrawable = this.mDrawable;
        Bitmap lastOriginalBitmap = this.mOriginalBitmap;
        this.mDrawable = drawable;
        this.mOriginalBitmap = this.getOriginalBitmapFromDrawable(mLastDrawable, drawable);
        if (lastOriginalBitmap != this.mOriginalBitmap) {
            this.mIsAlreadyBlurred = false;
            if (lastOriginalBitmap != null) {
                lastOriginalBitmap.recycle();
            }
            this.mLastRadius = -1;
        }
    }

    public final void changeMode(PivBlurMode blurMode, int radius) {
        if (blurMode == this.mMode && radius == this.mRadius) {
            return;
        }
        this.removeContext(true);
        this.mMode = blurMode;
        this.addContext(true);
        this.updateAlgorithms(blurMode);
        this.mLastRadius = -1;
        this.mRadius = radius;
    }

    public final void changeRadius(int radius) {
        this.changeMode(this.mMode, radius);
    }

    public void blur(int radius) {
        Bitmap bitmap;
        this.mRadius = radius;
        if (this.mOriginalBitmap == null || this.mOriginalBitmap.isRecycled()) {
            return;
        }
        if (this.mLastRadius == radius && this.mBlurredBitmap != null) {
            return;
        }
        if (this.mIsAlreadyBlurred && this.mBlurOptions.isStaticBlur()) {
            return;
        }
        this.mLastRadius = radius;
        if (this.mBlurredBitmap != null && this.mOriginalBitmap != this.mBlurredBitmap) {
            this.mBlurredBitmap.recycle();
        }
        this.addContext(false);
        try {
            bitmap = radius == 0 ? this.mOriginalBitmap : this.mBlurAlgorithm.blur(this.mOriginalBitmap, this.mRadius, this.mBlurOptions);
            this.mIsAlreadyBlurred = true;
        }
        catch (RenderscriptException e) {
            this.mMode = this.mBlurOptions.isUseRsFallback() ? this.mMode.getFallbackMode() : PivBlurMode.DISABLED;
            Log.w((String)BlurManager.class.getSimpleName(), (String)(e.getLocalizedMessage() + "\nFalling back to another blurring method: " + this.mMode.name()));
            this.updateAlgorithms(this.mMode);
            try {
                bitmap = this.mBlurAlgorithm.blur(this.mOriginalBitmap, this.mRadius, this.mBlurOptions);
                this.mIsAlreadyBlurred = true;
            }
            catch (RenderscriptException e1) {
                bitmap = null;
            }
        }
        this.removeContext(false);
        if (this.mBlurOptions.isStaticBlur()) {
            this.mOriginalBitmap = bitmap == null ? this.mOriginalBitmap : bitmap;
        }
        this.mBlurredBitmap = bitmap == null ? this.mBlurredBitmap : bitmap;
    }

    public void onSizeChanged(int width, int height, Drawable drawable) {
        this.mWidth = width;
        this.mHeight = height;
        if (drawable != null) {
            this.changeDrawable(drawable);
        }
    }

    private void updateAlgorithms(PivBlurMode blurMode) {
        this.mMode = blurMode;
        this.addContext(false);
        switch (blurMode) {
            case STACK_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mStackRenderscriptBlurAlgorithm == null) {
                        this.mStackRenderscriptBlurAlgorithm = new StackRenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mStackRenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case STACK: {
                if (this.mStackBlurAlgorithm == null) {
                    this.mStackBlurAlgorithm = new StackBlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mStackBlurAlgorithm;
                break;
            }
            case GAUSSIAN5X5_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mGaussian5x5RenderscriptBlurAlgorithm == null) {
                        this.mGaussian5x5RenderscriptBlurAlgorithm = new Gaussian5x5RenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mGaussian5x5RenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case GAUSSIAN5X5: {
                if (this.mGaussian5x5BlurAlgorithm == null) {
                    this.mGaussian5x5BlurAlgorithm = new Gaussian5x5BlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mGaussian5x5BlurAlgorithm;
                break;
            }
            case GAUSSIAN3X3_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mGaussian3x3RenderscriptBlurAlgorithm == null) {
                        this.mGaussian3x3RenderscriptBlurAlgorithm = new Gaussian3x3RenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mGaussian3x3RenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case GAUSSIAN3X3: {
                if (this.mGaussian3x3BlurAlgorithm == null) {
                    this.mGaussian3x3BlurAlgorithm = new Gaussian3x3BlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mGaussian3x3BlurAlgorithm;
                break;
            }
            case BOX5X5_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mBox5x5RenderscriptBlurAlgorithm == null) {
                        this.mBox5x5RenderscriptBlurAlgorithm = new Box5x5RenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mBox5x5RenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case BOX5X5: {
                if (this.mBox5x5BlurAlgorithm == null) {
                    this.mBox5x5BlurAlgorithm = new Box5x5BlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mBox5x5BlurAlgorithm;
                break;
            }
            case BOX3X3_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mBox3x3RenderscriptBlurAlgorithm == null) {
                        this.mBox3x3RenderscriptBlurAlgorithm = new Box3x3RenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mBox3x3RenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case BOX3X3: {
                if (this.mBox3x3BlurAlgorithm == null) {
                    this.mBox3x3BlurAlgorithm = new Box3x3BlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mBox3x3BlurAlgorithm;
                break;
            }
            case GAUSSIAN_RS: {
                RenderScript renderScript = SharedBlurManager.getRenderScriptContext();
                if (renderScript != null) {
                    if (this.mGaussianRenderscriptBlurAlgorithm == null) {
                        this.mGaussianRenderscriptBlurAlgorithm = new GaussianRenderscriptBlurAlgorithm();
                    }
                    this.mBlurAlgorithm = this.mGaussianRenderscriptBlurAlgorithm;
                    this.mBlurAlgorithm.setRenderscript(renderScript);
                    break;
                }
                this.updateAlgorithms(this.mBlurOptions.isUseRsFallback() ? blurMode.getFallbackMode() : PivBlurMode.DISABLED);
                break;
            }
            case GAUSSIAN: {
                if (this.mGaussianBlurAlgorithm == null) {
                    this.mGaussianBlurAlgorithm = new GaussianBlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mGaussianBlurAlgorithm;
                break;
            }
            default: {
                if (this.mDummyBlurAlgorithm == null) {
                    this.mDummyBlurAlgorithm = new DummyBlurAlgorithm();
                }
                this.mBlurAlgorithm = this.mDummyBlurAlgorithm;
            }
        }
    }

    public boolean shouldBlur(Drawable drawable, boolean checkDrawable) {
        return this.mMode != PivBlurMode.DISABLED && (this.mLastRadius != this.mRadius || checkDrawable && this.mDrawable != drawable);
    }

    public Bitmap getLastBlurredBitmap() {
        this.blur(this.mRadius);
        return this.mBlurredBitmap != null ? this.mBlurredBitmap : this.mOriginalBitmap;
    }

    private Bitmap getOriginalBitmapFromDrawable(Drawable mLastDrawable, Drawable drawable) {
        int sizeY;
        int sizeX;
        if (drawable == null || this.mWidth <= 0 || this.mHeight <= 0) {
            return null;
        }
        float ratio = (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight();
        int maxWidth = (int)(Math.max((float)this.mWidth, (float)this.mHeight * ratio) / this.mBlurOptions.getDownSamplingRate());
        int maxHeight = (int)(Math.max((float)this.mHeight, (float)this.mWidth / ratio) / this.mBlurOptions.getDownSamplingRate());
        if (drawable.getIntrinsicWidth() > maxWidth && maxWidth > 0 && drawable.getIntrinsicHeight() > maxHeight && maxHeight > 0) {
            sizeX = maxWidth;
            sizeY = maxHeight;
        } else {
            sizeX = drawable.getIntrinsicWidth();
            sizeY = drawable.getIntrinsicHeight();
        }
        if (drawable.getClass().getName().equals("android.graphics.drawable.VectorDrawable")) {
            sizeX = maxWidth;
            sizeY = maxHeight;
        }
        if (sizeX > 0 && sizeY > 0 && this.mOriginalBitmap != null && !this.mOriginalBitmap.isRecycled() && this.mLastSizeX == sizeX && this.mLastSizeY == sizeY && mLastDrawable == drawable) {
            return this.mOriginalBitmap;
        }
        this.mLastSizeX = sizeX;
        this.mLastSizeY = sizeY;
        try {
            Bitmap bitmap = drawable instanceof BitmapDrawable ? Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888) : (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : (drawable instanceof ColorDrawable ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888)));
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.mOriginalBitmap;
        }
    }

    public void addContext(boolean fromView) {
        if (this.mIsRenderscriptManaged || this.mView.get() == null) {
            return;
        }
        Context context = ((ImageView)this.mView.get()).getContext().getApplicationContext();
        if (((ImageView)this.mView.get()).getContext().getApplicationContext() != null && this.mBlurOptions.isStaticBlur() != fromView && this.mMode.isUsesRenderscript()) {
            this.mIsRenderscriptManaged = true;
            SharedBlurManager.addRenderscriptContext(context.getApplicationContext());
        }
    }

    public void removeContext(boolean fromView) {
        if (!this.mIsRenderscriptManaged) {
            return;
        }
        if (this.mBlurOptions.isStaticBlur() != fromView) {
            switch (this.mMode) {
                case GAUSSIAN5X5_RS: {
                    this.mIsRenderscriptManaged = false;
                    SharedBlurManager.removeRenderscriptContext();
                    this.updateAlgorithms(this.mMode);
                    break;
                }
            }
        }
    }

    @Override
    public void onStaticBlurChanged() {
        if (this.mBlurOptions.isStaticBlur()) {
            if (this.mBlurredBitmap != null && this.mBlurredBitmap != this.mOriginalBitmap) {
                this.mOriginalBitmap.recycle();
                this.mOriginalBitmap = this.mBlurredBitmap;
                this.mBlurredBitmap = null;
            }
            this.removeContext(false);
        } else {
            this.addContext(true);
        }
    }

    @Override
    public void onDownsamplingRateChanged() {
        Bitmap bitmap;
        this.changeDrawable(this.mDrawable);
        this.blur(this.mRadius);
        if (this.mView.get() != null && (bitmap = this.getLastBlurredBitmap()) != null) {
            ((ImageView)this.mView.get()).setImageBitmap(this.getLastBlurredBitmap());
        }
    }

    public PivBlurMode getBlurMode() {
        return this.mMode;
    }

    public BlurOptions getBlurOptions() {
        return this.mBlurOptions;
    }

    public int getRadius() {
        return this.mRadius;
    }

    public Bitmap getOriginalBitmap() {
        return this.mOriginalBitmap;
    }

    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("blur_options", (Parcelable)this.mBlurOptions);
        bundle.putInt("blur_mode", this.mMode.getValue());
        bundle.putInt("blur_radius", this.mRadius);
        return bundle;
    }

    public void restoreInstanceState(Bundle state) {
        if (state == null) {
            return;
        }
        this.mBlurOptions.setOptions((BlurOptions)state.getParcelable("blur_options"));
        PivBlurMode blurMode = PivBlurMode.fromValue(state.getInt("blur_mode"));
        this.mWidth = state.getInt("blur_width");
        this.mHeight = state.getInt("blur_height");
        this.mRadius = state.getInt("blur_radius");
        this.mLastRadius = -1;
        this.changeMode(blurMode, this.mRadius);
    }
}

