/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview.blur;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.ref.WeakReference;

public final class BlurOptions
implements Parcelable {
    private float mDownSamplingRate;
    private boolean mIsStaticBlur;
    private boolean mUseRsFallback;
    private int mNumThreads;
    private WeakReference<BlurOptionsListener> listener;
    public static final Parcelable.Creator<BlurOptions> CREATOR = new Parcelable.Creator<BlurOptions>(){

        public BlurOptions createFromParcel(Parcel in) {
            return new BlurOptions(in);
        }

        public BlurOptions[] newArray(int size) {
            return new BlurOptions[size];
        }
    };

    public BlurOptions(float downSamplingRate, boolean isStaticBlur, boolean useRsFallback, int numThreads) {
        this.mDownSamplingRate = downSamplingRate;
        if (this.mDownSamplingRate < 1.0f) {
            this.mDownSamplingRate = 1.0f;
        }
        this.mIsStaticBlur = isStaticBlur;
        this.mUseRsFallback = useRsFallback;
        this.mNumThreads = numThreads;
    }

    public void setOptions(BlurOptions other) {
        this.mDownSamplingRate = other.mDownSamplingRate;
        this.mIsStaticBlur = other.mIsStaticBlur;
        this.mUseRsFallback = other.mUseRsFallback;
        this.mNumThreads = other.mNumThreads;
        this.listener = other.listener;
    }

    public void setListener(BlurOptionsListener listener) {
        this.listener = new WeakReference<BlurOptionsListener>(listener);
    }

    public float getDownSamplingRate() {
        return this.mDownSamplingRate;
    }

    public void setDownSamplingRate(float downSamplingRate) {
        this.mDownSamplingRate = downSamplingRate;
        if (this.mDownSamplingRate < 1.0f) {
            this.mDownSamplingRate = 1.0f;
        }
        if (this.listener.get() != null) {
            ((BlurOptionsListener)this.listener.get()).onDownsamplingRateChanged();
        }
    }

    public boolean isStaticBlur() {
        return this.mIsStaticBlur;
    }

    public void setStaticBlur(boolean isStaticBlur) {
        this.mIsStaticBlur = isStaticBlur;
        if (this.listener.get() != null) {
            ((BlurOptionsListener)this.listener.get()).onStaticBlurChanged();
        }
    }

    public boolean isUseRsFallback() {
        return this.mUseRsFallback;
    }

    public int getNumThreads() {
        return this.mNumThreads;
    }

    public void setUseRsFallback(boolean useRsFallback) {
        this.mUseRsFallback = useRsFallback;
    }

    public void setNumThreads(int numThreads) {
        this.mNumThreads = numThreads;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.mDownSamplingRate);
        dest.writeByte((byte)(this.mIsStaticBlur ? 1 : 0));
        dest.writeByte((byte)(this.mUseRsFallback ? 1 : 0));
        dest.writeInt(this.mNumThreads);
    }

    protected BlurOptions(Parcel in) {
        this.mDownSamplingRate = in.readFloat();
        this.mIsStaticBlur = in.readByte() != 0;
        this.mUseRsFallback = in.readByte() != 0;
        this.mNumThreads = in.readInt();
    }

    public static interface BlurOptionsListener {
        public void onStaticBlurChanged();

        public void onDownsamplingRateChanged();
    }
}

