/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfulimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import com.stefanosiano.powerfulimageview.ImageViewWrapper;
import com.stefanosiano.powerfulimageview.R;
import com.stefanosiano.powerfulimageview.blur.BlurOptions;
import com.stefanosiano.powerfulimageview.blur.PivBlurMode;
import com.stefanosiano.powerfulimageview.blur.algorithms.BlurManager;
import com.stefanosiano.powerfulimageview.progress.PivProgressGravity;
import com.stefanosiano.powerfulimageview.progress.PivProgressMode;
import com.stefanosiano.powerfulimageview.progress.ProgressOptions;
import com.stefanosiano.powerfulimageview.progress.drawers.ProgressDrawerManager;
import com.stefanosiano.powerfulimageview.shape.PivShapeMode;
import com.stefanosiano.powerfulimageview.shape.PivShapeScaleType;
import com.stefanosiano.powerfulimageview.shape.ShapeOptions;
import com.stefanosiano.powerfulimageview.shape.drawers.ShapeDrawerManager;

public class PowerlessImageView
extends ImageViewWrapper {
    private static final boolean DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
    private static final int DEFAULT_PROGRESS_WIDTH = -1;
    private static final float DEFAULT_PROGRESS_WIDTH_PERCENT = 10.0f;
    private static final int DEFAULT_PROGRESS_SIZE = -1;
    private static final float DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
    private static final int DEFAULT_PROGRESS_PADDING = 2;
    private static final int DEFAULT_PROGRESS_VALUE = 0;
    private static final int DEFAULT_PROGRESS_GRAVITY = PivProgressGravity.CENTER.getValue();
    private static final boolean DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT = false;
    private static final boolean DEFAULT_PROGRESS_INDETERMINATE = true;
    private static final boolean DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE = false;
    private static final boolean DEFAULT_PROGRESS_SHADOW_ENABLED = true;
    private static final boolean DEFAULT_PROGRESS_REVERSED = false;
    private static final boolean DEFAULT_PROGRESS_REMOVED_ON_CHANGE = true;
    private static final int DEFAULT_PROGRESS_MODE = PivProgressMode.NONE.getValue();
    private static final int DEFAULT_PROGRESS_SHADOW_PADDING = -1;
    private static final float DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT = 10.0f;
    private static final int DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH = 1;
    private static final int DEFAULT_SHAPE_MODE = PivShapeMode.NORMAL.getValue();
    private static final int DEFAULT_SHAPE_INNER_PADDING = -1;
    private static final float DEFAULT_SHAPE_INNER_PADDING_PERCENT = 0.0f;
    private static final boolean DEFAULT_SHAPE_BORDER_OVERLAY = false;
    private static final int DEFAULT_SHAPE_BORDER_WIDTH = 0;
    private static final float DEFAULT_SHAPE_RATIO = 0.0f;
    private static final float DEFAULT_SHAPE_RADIUS_X = 1.0f;
    private static final float DEFAULT_SHAPE_RADIUS_Y = 1.0f;
    private static final int DEFAULT_BLUR_RADIUS = 0;
    private static final float DEFAULT_BLUR_DOWNSAMPLING_RATE = 4.0f;
    private static final boolean DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK = true;
    private static final int DEFAULT_BLUR_NUM_THREADS = 0;
    private static final boolean DEFAULT_BLUR_STATIC = false;
    private static final int DEFAULT_BLUR_MODE = PivBlurMode.DISABLED.getValue();
    private final ProgressDrawerManager mProgressDrawerManager;
    private final ShapeDrawerManager mShapeDrawerManager;
    private final BlurManager mBlurManager;
    private boolean mCheckBlur = false;
    private boolean mShouldCheckRemoveProgress = true;

    public PowerlessImageView(Context context) {
        this(context, null);
    }

    public PowerlessImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PowerlessImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PowerfulImageView, defStyleAttr, 0);
        TypedValue tvSize = new TypedValue();
        TypedValue tvBorderWidth = new TypedValue();
        TypedValue tvShadowPadding = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_piv_progress_size, tvSize);
        a.getValue(R.styleable.PowerfulImageView_piv_progress_border_width, tvBorderWidth);
        a.getValue(R.styleable.PowerfulImageView_piv_progress_shadow_padding, tvShadowPadding);
        ProgressOptions progressOptions = new ProgressOptions(a.getBoolean(R.styleable.PowerfulImageView_piv_progress_determinate_animation_enabled, true), tvBorderWidth.type == 5 ? (int)tvBorderWidth.getDimension(this.getResources().getDisplayMetrics()) : -1, tvBorderWidth.type == 6 ? tvBorderWidth.getFraction(100.0f, 100.0f) : 10.0f, tvSize.type == 5 ? (int)tvSize.getDimension(this.getResources().getDisplayMetrics()) : -1, tvSize.type == 6 ? tvSize.getFraction(100.0f, 100.0f) : 40.0f, a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_progress_padding, (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getFloat(R.styleable.PowerfulImageView_piv_progress_value, 0.0f), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_front_color, R.color.piv_default_progress_front_color), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_back_color, R.color.piv_default_progress_back_color), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_indeterminate_color, R.color.piv_default_progress_indeterminate_color), a.getInteger(R.styleable.PowerfulImageView_piv_progress_gravity, DEFAULT_PROGRESS_GRAVITY), Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1, a.getBoolean(R.styleable.PowerfulImageView_piv_progress_rtl_disabled, false), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_indeterminate, true), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_draw_wedge, false), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_shadow_enabled, true), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_shadow_color, R.color.piv_default_progress_shadow_color), tvShadowPadding.type == 5 ? (int)tvShadowPadding.getDimension(this.getResources().getDisplayMetrics()) : -1, tvShadowPadding.type == 6 ? tvShadowPadding.getFraction(100.0f, 100.0f) : 10.0f, a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_progress_shadow_border_width, (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_shadow_border_color, R.color.piv_default_progress_shadow_border_color), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_reversed, false), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_removed_on_change, true));
        PivProgressMode progressMode = PivProgressMode.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_progress_mode, DEFAULT_PROGRESS_MODE));
        TypedValue tvShapeInnerPadding = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_piv_shape_inner_padding, tvShapeInnerPadding);
        ShapeOptions shapeOptions = new ShapeOptions(this.getColor(a, R.styleable.PowerfulImageView_piv_shape_background_color, 17170445), this.getColor(a, R.styleable.PowerfulImageView_piv_shape_foreground_color, 17170445), tvShapeInnerPadding.type == 5 ? (int)tvShapeInnerPadding.getDimension(this.getResources().getDisplayMetrics()) : -1, tvShapeInnerPadding.type == 6 ? tvShapeInnerPadding.getFraction(100.0f, 100.0f) : 0.0f, a.getBoolean(R.styleable.PowerfulImageView_piv_shape_border_overlay, false), this.getColor(a, R.styleable.PowerfulImageView_piv_shape_border_color, 17170445), a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_shape_border_width, (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getFloat(R.styleable.PowerfulImageView_piv_shape_ratio, 0.0f), a.getFloat(R.styleable.PowerfulImageView_piv_shape_radius_x, 1.0f), a.getFloat(R.styleable.PowerfulImageView_piv_shape_radius_y, 1.0f), this.getColor(a, R.styleable.PowerfulImageView_piv_shape_solid_color, R.color.piv_default_shape_solid_color), a.getDrawable(R.styleable.PowerfulImageView_piv_shape_background), a.getDrawable(R.styleable.PowerfulImageView_piv_shape_foreground));
        PivShapeMode shapeMode = PivShapeMode.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_shape_mode, DEFAULT_SHAPE_MODE));
        PivShapeScaleType scaleType = PivShapeScaleType.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_shape_scaleType, PivShapeScaleType.getFromScaleType(this.getScaleType()).getValue()));
        BlurOptions blurOptions = new BlurOptions(a.getFloat(R.styleable.PowerfulImageView_piv_blur_down_sampling_rate, 4.0f), a.getBoolean(R.styleable.PowerfulImageView_piv_blur_static, false), a.getBoolean(R.styleable.PowerfulImageView_piv_blur_use_rs_fallback, true), a.getInteger(R.styleable.PowerfulImageView_piv_blur_num_threads, 0));
        int blurRadius = a.getInteger(R.styleable.PowerfulImageView_piv_blur_radius, 0);
        int blurModeValue = a.getInteger(R.styleable.PowerfulImageView_piv_blur_mode, DEFAULT_BLUR_MODE);
        PivBlurMode blurMode = PivBlurMode.fromValue(blurModeValue);
        a.recycle();
        this.mProgressDrawerManager = new ProgressDrawerManager((View)this, progressOptions);
        this.mShapeDrawerManager = new ShapeDrawerManager((View)this, shapeOptions);
        this.mBlurManager = new BlurManager(this, blurOptions);
        this.mShapeDrawerManager.setScaleType(scaleType);
        this.mShouldCheckRemoveProgress = false;
        this.onDrawableChanged();
        this.setProgressMode(progressMode);
        this.setShapeMode(shapeMode);
        this.setBlurMode(blurMode, blurRadius);
        this.mShouldCheckRemoveProgress = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mProgressDrawerManager.onSizeChanged(w, h);
        this.mShapeDrawerManager.onSizeChanged(w, h, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.mBlurManager.onSizeChanged(this.mShapeDrawerManager.getMeasuredWidth(), this.mShapeDrawerManager.getMeasuredHeight(), this.getDrawable() != null ? this.getDrawable().getCurrent() : this.getDrawable());
        this.mShouldCheckRemoveProgress = false;
        this.blurBitmap(false);
        this.mShouldCheckRemoveProgress = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mShapeDrawerManager.getShapeMode() == PivShapeMode.NORMAL) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mShapeDrawerManager.onMeasure(widthSize, heightSize, widthMode, heightMode, (View)this);
        this.setMeasuredDimension(this.mShapeDrawerManager.getMeasuredWidth(), this.mShapeDrawerManager.getMeasuredHeight());
    }

    @Override
    void onDrawableChanged() {
        if (this.blurBitmap(true)) {
            return;
        }
        if (this.mShouldCheckRemoveProgress && this.mProgressDrawerManager != null && this.getDrawable() != null) {
            this.mProgressDrawerManager.changeDrawable(this.getDrawable().getCurrent());
        }
        if (this.mShapeDrawerManager != null && this.getDrawable() != null) {
            this.mShapeDrawerManager.changeDrawable(this.getDrawable().getCurrent());
        }
    }

    @Override
    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        if (this.mShapeDrawerManager != null) {
            this.mShapeDrawerManager.setScaleType(PivShapeScaleType.getFromScaleType(scaleType));
        }
    }

    public final void setShapeScaleType(PivShapeScaleType scaleType) {
        super.setScaleType(ImageView.ScaleType.MATRIX);
        if (this.mShapeDrawerManager != null) {
            this.mShapeDrawerManager.setScaleType(scaleType);
        }
    }

    @Override
    public void setImageMatrix(Matrix matrix) {
        super.setImageMatrix(matrix);
        if (this.mShapeDrawerManager != null) {
            this.mShapeDrawerManager.setImageMatrix(matrix);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.mShapeDrawerManager.onDraw(canvas);
        this.mProgressDrawerManager.onDraw(canvas);
    }

    public final void setProgressMode(PivProgressMode progressMode) {
        this.mProgressDrawerManager.changeProgressMode(progressMode, false);
    }

    public final void setShapeMode(PivShapeMode shapeMode) {
        this.mShapeDrawerManager.changeShapeMode(shapeMode);
    }

    public final void setBlurMode(PivBlurMode blurMode, int radius) {
        boolean bl = this.mCheckBlur = blurMode != PivBlurMode.DISABLED;
        if (this.mBlurManager == null) {
            return;
        }
        this.mBlurManager.changeMode(blurMode, radius);
        this.blurBitmap(false);
    }

    public final void setBlurRadius(int radius) {
        if (this.mBlurManager == null) {
            return;
        }
        this.mCheckBlur = this.mBlurManager.getBlurMode() != PivBlurMode.DISABLED;
        this.mBlurManager.changeRadius(radius);
        this.blurBitmap(false);
    }

    private boolean blurBitmap(boolean changeDrawable) {
        if (!this.mCheckBlur || this.mBlurManager == null || this.getDrawable() == null) {
            return false;
        }
        boolean shouldBlur = this.mBlurManager.shouldBlur(this.getDrawable().getCurrent(), changeDrawable);
        if (changeDrawable) {
            this.mBlurManager.changeDrawable(this.getDrawable().getCurrent());
        }
        Bitmap blurredBitmap = null;
        if (shouldBlur && (blurredBitmap = this.mBlurManager.getLastBlurredBitmap()) != null) {
            this.mCheckBlur = false;
            this.setImageBitmap(blurredBitmap);
            this.mCheckBlur = true;
        }
        return shouldBlur && blurredBitmap != null;
    }

    public final void setProgressIndeterminate(boolean isIndeterminate) {
        this.mProgressDrawerManager.getProgressOptions().setIndeterminate(isIndeterminate);
    }

    public final ProgressOptions getProgressOptions() {
        return this.mProgressDrawerManager.getProgressOptions();
    }

    public final PivProgressMode getProgressMode() {
        return this.mProgressDrawerManager.getProgressMode();
    }

    public final PivShapeMode getShapeMode() {
        return this.mShapeDrawerManager.getShapeMode();
    }

    public final PivBlurMode getBlurMode() {
        return this.mBlurManager.getBlurMode();
    }

    public final ShapeOptions getShapeOptions() {
        return this.mShapeDrawerManager.getShapeOptions();
    }

    public final BlurOptions getBlurOptions() {
        return this.mBlurManager.getBlurOptions();
    }

    public final int getBlurRadius() {
        return this.mBlurManager.getRadius();
    }

    public final Bitmap getBlurBlurredBitmap() {
        return this.mBlurManager.getLastBlurredBitmap();
    }

    public final Bitmap getBlurOriginalBitmap() {
        return this.mBlurManager.getOriginalBitmap();
    }

    public final void setProgressValue(float progress) {
        this.getProgressOptions().setValue(progress);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBlurManager.addContext(true);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBlurManager.removeContext(true);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("super_state", super.onSaveInstanceState());
        bundle.putParcelable("progress_drawer_manager", (Parcelable)this.mProgressDrawerManager.saveInstanceState());
        bundle.putParcelable("shape_drawer_manager", (Parcelable)this.mShapeDrawerManager.saveInstanceState());
        bundle.putParcelable("blur_manager", (Parcelable)this.mBlurManager.saveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgressDrawerManager.restoreInstanceState((Bundle)bundle.getParcelable("progress_drawer_manager"));
            this.mShapeDrawerManager.restoreInstanceState((Bundle)bundle.getParcelable("shape_drawer_manager"));
            this.mBlurManager.restoreInstanceState((Bundle)bundle.getParcelable("blur_manager"));
            state = bundle.getParcelable("super_state");
        }
        super.onRestoreInstanceState(state);
        this.blurBitmap(true);
    }
}

