/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress.drawers;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.ImageView;
import com.stefanosiano.powerlessimageview.progress.PivProgressMode;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.CircularShadowDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.DeterminateHorizontalProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.DeterminateProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.DummyProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.DummyShadowDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.IndeterminateHorizontalProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.IndeterminateProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.RectangularShadowDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ShadowDrawer;
import java.lang.ref.WeakReference;

public final class ProgressDrawerManager
implements ProgressOptions.ProgressOptionsListener {
    private final WeakReference<ImageView> mPiv;
    private final RectF mProgressBounds;
    private final RectF mProgressShadowBounds;
    private DummyProgressDrawer mDummyProgressDrawer;
    private DeterminateProgressDrawer mDeterminateProgressDrawer;
    private DeterminateHorizontalProgressDrawer mDeterminateHorizontalProgressDrawer;
    private IndeterminateHorizontalProgressDrawer mIndeterminateHorizontalProgressDrawer;
    private IndeterminateProgressDrawer mIndeterminateProgressDrawer;
    private DummyShadowDrawer mDummyCancelDrawer;
    private RectangularShadowDrawer mRectangularShadowDrawer;
    private CircularShadowDrawer mCircularShadowDrawer;
    private ShadowDrawer mShadowDrawer;
    private ProgressDrawer mProgressDrawer;
    private PivProgressMode mProgressMode = null;
    private ProgressOptions mProgressOptions;
    private ProgressDrawerListener listener;

    public ProgressDrawerManager(ImageView piv, ProgressOptions progressOptions) {
        this.mPiv = new WeakReference<ImageView>(piv);
        this.mProgressBounds = new RectF();
        this.mProgressShadowBounds = new RectF();
        this.mProgressOptions = progressOptions;
        this.listener = new ProgressDrawerListener(){

            @Override
            public void onRequestInvalidate() {
                if (ProgressDrawerManager.this.mPiv.get() != null) {
                    ((ImageView)ProgressDrawerManager.this.mPiv.get()).postInvalidate((int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.left - 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.top - 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.right + 1, (int)((ProgressDrawerManager)ProgressDrawerManager.this).mProgressBounds.bottom + 1);
                }
            }
        };
        this.mProgressOptions.setListener(this);
    }

    private void updateDrawers(PivProgressMode progressMode) {
        switch (progressMode) {
            case INDETERMINATE: {
                if (this.mIndeterminateProgressDrawer == null) {
                    this.mIndeterminateProgressDrawer = new IndeterminateProgressDrawer();
                }
                this.mProgressDrawer = this.mIndeterminateProgressDrawer;
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mCircularShadowDrawer == null) {
                        this.mCircularShadowDrawer = new CircularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mCircularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            case DETERMINATE: {
                if (this.mDeterminateProgressDrawer == null) {
                    this.mDeterminateProgressDrawer = new DeterminateProgressDrawer();
                }
                this.mProgressDrawer = this.mDeterminateProgressDrawer;
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mCircularShadowDrawer == null) {
                        this.mCircularShadowDrawer = new CircularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mCircularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            case HORIZONTAL_DETERMINATE: {
                if (this.mDeterminateHorizontalProgressDrawer == null) {
                    this.mDeterminateHorizontalProgressDrawer = new DeterminateHorizontalProgressDrawer();
                }
                this.mProgressDrawer = this.mDeterminateHorizontalProgressDrawer;
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mRectangularShadowDrawer == null) {
                        this.mRectangularShadowDrawer = new RectangularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mRectangularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            case HORIZONTAL_INDETERMINATE: {
                if (this.mIndeterminateHorizontalProgressDrawer == null) {
                    this.mIndeterminateHorizontalProgressDrawer = new IndeterminateHorizontalProgressDrawer();
                }
                this.mProgressDrawer = this.mIndeterminateHorizontalProgressDrawer;
                if (this.mProgressOptions.isShadowEnabled()) {
                    if (this.mRectangularShadowDrawer == null) {
                        this.mRectangularShadowDrawer = new RectangularShadowDrawer();
                    }
                    this.mShadowDrawer = this.mRectangularShadowDrawer;
                    break;
                }
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
                break;
            }
            default: {
                if (this.mDummyProgressDrawer == null) {
                    this.mDummyProgressDrawer = new DummyProgressDrawer();
                }
                this.mProgressDrawer = this.mDummyProgressDrawer;
                if (this.mDummyCancelDrawer == null) {
                    this.mDummyCancelDrawer = new DummyShadowDrawer();
                }
                this.mShadowDrawer = this.mDummyCancelDrawer;
            }
        }
        this.mProgressDrawer.setListener(this.listener);
    }

    public final void onSizeChanged(int w, int h) {
        this.mProgressOptions.calculateBounds(w, h, this.mProgressMode);
        this.onSizeUpdated(this.mProgressOptions);
    }

    public final void changeProgressMode(PivProgressMode progressMode) {
        if (this.mProgressMode != null && this.mProgressMode == progressMode) {
            return;
        }
        if (this.mProgressDrawer != null) {
            this.mProgressDrawer.stopIndeterminateAnimation();
        }
        this.mProgressMode = progressMode;
        this.updateDrawers(this.mProgressMode);
        this.mProgressDrawer.setup(this.mProgressOptions);
        this.mShadowDrawer.setup(this.mProgressOptions);
        this.mProgressDrawer.startIndeterminateAnimation();
    }

    public final void onDraw(Canvas canvas) {
        this.mShadowDrawer.draw(canvas, this.mProgressShadowBounds);
        this.mProgressDrawer.draw(canvas, this.mProgressBounds);
    }

    public final ProgressOptions getProgressOptions() {
        return this.mProgressOptions;
    }

    @Override
    public void onOptionsUpdated(ProgressOptions options) {
        this.mShadowDrawer.setup(options);
        this.mProgressDrawer.setup(options);
        this.mProgressOptions = options;
    }

    @Override
    public void onSizeUpdated(ProgressOptions options) {
        this.mProgressOptions = options;
        this.mProgressBounds.set(this.mProgressOptions.getLeft(), this.mProgressOptions.getTop(), this.mProgressOptions.getRight(), this.mProgressOptions.getBottom());
        this.mProgressShadowBounds.set(this.mProgressOptions.getShadowLeft(), this.mProgressOptions.getShadowTop(), this.mProgressOptions.getShadowRight(), this.mProgressOptions.getShadowBottom());
        this.mProgressDrawer.setup(this.mProgressOptions);
        this.mShadowDrawer.setup(this.mProgressOptions);
    }

    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("progress_options", (Parcelable)this.mProgressOptions);
        bundle.putInt("progress_mode", this.mProgressMode.getValue());
        return bundle;
    }

    public void restoreInstanceState(Bundle state) {
        if (state == null) {
            return;
        }
        this.mProgressOptions.setOptions((ProgressOptions)state.getParcelable("progress_options"));
        PivProgressMode progressMode = PivProgressMode.fromValue(state.getInt("progress_mode"));
        this.onSizeUpdated(this.mProgressOptions);
        this.changeProgressMode(progressMode);
    }

    static interface ProgressDrawerListener {
        public void onRequestInvalidate();
    }
}

