/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress.drawers;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawerManager;

final class IndeterminateProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 800L;
    private Paint mProgressPaint;
    private ValueAnimator mOffsetAnimator;
    private ValueAnimator mProgressAnimator;
    private int mProgressStartAngle = -90;
    private int mProgressSweepAngle = 180;
    private boolean isShrinking = false;
    private long mProgressAnimationDuration = -1L;
    private int mOffset = 0;
    private int mLastStartAngleOffset = 0;
    private int mLastSweepAngleOffset = 0;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    IndeterminateProgressDrawer() {
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        this.createAnimationIfNeeded();
        if (this.mProgressPaint == null) {
            this.mProgressPaint = new Paint();
        }
        this.mProgressPaint.setColor(progressOptions.getIndeterminateColor());
        this.mProgressPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.setProgressAngle(this.mLastStartAngleOffset, this.mLastSweepAngleOffset);
    }

    @Override
    public void startIndeterminateAnimation() {
        if (this.mOffsetAnimator != null) {
            this.mOffsetAnimator.cancel();
        }
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
        this.mOffset = 0;
        this.isShrinking = false;
        this.mLastStartAngleOffset = 0;
        this.mLastSweepAngleOffset = 0;
        this.setProgressAngle(this.mLastStartAngleOffset, this.mLastSweepAngleOffset);
        this.mProgressAnimator.start();
        this.mOffsetAnimator.start();
    }

    private void setProgressAngle(int startAngleOffset, int sweepAngleOffset) {
        this.mLastStartAngleOffset = startAngleOffset;
        this.mLastSweepAngleOffset = sweepAngleOffset;
        if (this.isShrinking) {
            this.mProgressStartAngle = -90 + startAngleOffset + this.mOffset;
            this.mProgressSweepAngle = 340 - sweepAngleOffset;
        } else {
            this.mProgressStartAngle = -90 + this.mOffset;
            this.mProgressSweepAngle = sweepAngleOffset + 50;
        }
        this.listener.onRequestInvalidate();
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        canvas.drawArc(progressBounds, (float)this.mProgressStartAngle, (float)this.mProgressSweepAngle, false, this.mProgressPaint);
    }

    @Override
    public void stopIndeterminateAnimation() {
        if (this.mOffsetAnimator != null) {
            this.mOffsetAnimator.cancel();
        }
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
    }

    @Override
    public void setProgressPercent(float progressPercent) {
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    private void createAnimationIfNeeded() {
        if (this.mOffsetAnimator == null) {
            this.mOffsetAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mOffsetAnimator.setDuration(3000L);
            this.mOffsetAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mOffsetAnimator.setRepeatCount(-1);
            this.mOffsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    IndeterminateProgressDrawer.this.mOffset = (int)(360.0f * animation.getAnimatedFraction());
                }
            });
        }
        if (this.mProgressAnimator == null) {
            this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 800L : this.mProgressAnimationDuration);
            this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            this.mProgressAnimator.setRepeatCount(-1);
            this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                    IndeterminateProgressDrawer.this.isShrinking = !IndeterminateProgressDrawer.this.isShrinking;
                }
            });
            this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    IndeterminateProgressDrawer.this.setProgressAngle((int)(360.0f * animation.getAnimatedFraction()), (int)(290.0f * animation.getAnimatedFraction()));
                }
            });
        }
    }
}

