/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress.drawers;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawerManager;

final class IndeterminateHorizontalProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 1000L;
    private float mLeft;
    private float mRight;
    private Paint mProgressPaint;
    private ValueAnimator mProgressAnimator;
    private float mStartX = 0.0f;
    private float mEndX = 0.0f;
    private boolean isShrinking = false;
    private long mProgressAnimationDuration = -1L;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    IndeterminateHorizontalProgressDrawer() {
    }

    @Override
    public void setProgressPercent(float progressPercent) {
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        this.createAnimationIfNeeded();
        if (this.mProgressPaint == null) {
            this.mProgressPaint = new Paint();
        }
        this.mProgressPaint.setColor(progressOptions.getIndeterminateColor());
        this.mProgressPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getLeft();
        this.mRight = progressOptions.getRight();
        this.setProgressValues(this.isShrinking ? this.mStartX : this.mEndX);
    }

    private void setProgressValues(float currentX) {
        if (this.isShrinking) {
            this.mStartX = currentX;
            this.mEndX = this.mRight;
        } else {
            this.mStartX = this.mLeft;
            this.mEndX = currentX;
        }
        this.listener.onRequestInvalidate();
    }

    @Override
    public void startIndeterminateAnimation() {
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
        this.isShrinking = false;
        this.setProgressValues(this.mLeft);
        this.mProgressAnimator.start();
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        canvas.drawRect(this.mStartX, progressBounds.top, this.mEndX, progressBounds.bottom, this.mProgressPaint);
    }

    @Override
    public void stopIndeterminateAnimation() {
        if (this.mProgressAnimator != null) {
            this.mProgressAnimator.cancel();
        }
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    private void createAnimationIfNeeded() {
        if (this.mProgressAnimator != null) {
            return;
        }
        this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 1000L : this.mProgressAnimationDuration);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mProgressAnimator.setRepeatCount(-1);
        this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                IndeterminateHorizontalProgressDrawer.this.isShrinking = !IndeterminateHorizontalProgressDrawer.this.isShrinking;
            }
        });
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                IndeterminateHorizontalProgressDrawer.this.setProgressValues(IndeterminateHorizontalProgressDrawer.this.mLeft + (IndeterminateHorizontalProgressDrawer.this.mRight - IndeterminateHorizontalProgressDrawer.this.mLeft) * animation.getAnimatedFraction());
            }
        });
    }
}

