/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress.drawers;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawerManager;

final class DeterminateProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 100L;
    private Paint mProgressFrontPaint;
    private Paint mProgressBackPaint;
    private ValueAnimator mProgressAnimator;
    private long mProgressAnimationDuration = -1L;
    private int mProgressBackStartAngle;
    private int mProgressBackSweepAngle;
    private int mProgressFrontSweepAngle;
    private int mCurrentProgressFrontSweepAngle;
    private int mOldProgressFrontSweepAngle;
    private boolean mUseProgressAnimation;
    private boolean drawWedge;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    DeterminateProgressDrawer() {
    }

    private void setRealProgressAngle(int progressAngle) {
        this.mProgressBackStartAngle = progressAngle - 90;
        this.mProgressBackSweepAngle = 360 - progressAngle;
        this.mCurrentProgressFrontSweepAngle = progressAngle;
        this.listener.onRequestInvalidate();
    }

    @Override
    public void setProgressPercent(float progressPercent) {
        int mProgressAngle = (int)(progressPercent * 3.6f);
        if (mProgressAngle > 360) {
            mProgressAngle %= 360;
        }
        this.mOldProgressFrontSweepAngle = this.mCurrentProgressFrontSweepAngle;
        this.mProgressFrontSweepAngle = mProgressAngle;
        if (this.mUseProgressAnimation) {
            if (this.mProgressAnimator != null) {
                this.mProgressAnimator.cancel();
            }
            this.createAnimationIfNeeded();
            this.mProgressAnimator.start();
        } else {
            this.setRealProgressAngle(mProgressAngle);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.mUseProgressAnimation = enabled;
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        this.mUseProgressAnimation = progressOptions.isDeterminateAnimationEnabled();
        this.drawWedge = progressOptions.isDrawWedge();
        if (this.mProgressFrontPaint == null) {
            this.mProgressFrontPaint = new Paint();
        }
        if (this.mProgressBackPaint == null) {
            this.mProgressBackPaint = new Paint();
        }
        this.mProgressFrontPaint.setColor(progressOptions.getFrontColor());
        this.mProgressFrontPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressFrontPaint.setAntiAlias(true);
        this.mProgressFrontPaint.setStyle(this.drawWedge ? Paint.Style.FILL_AND_STROKE : Paint.Style.STROKE);
        this.mProgressBackPaint.setColor(progressOptions.getBackColor());
        this.mProgressBackPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressBackPaint.setAntiAlias(true);
        this.mProgressBackPaint.setStyle(Paint.Style.STROKE);
        this.setProgressPercent(progressOptions.getValuePercent());
    }

    @Override
    public void startIndeterminateAnimation() {
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        canvas.drawArc(progressBounds, (float)this.mProgressBackStartAngle, (float)this.mProgressBackSweepAngle, this.drawWedge, this.mProgressBackPaint);
        canvas.drawArc(progressBounds, -90.0f, (float)this.mCurrentProgressFrontSweepAngle, this.drawWedge, this.mProgressFrontPaint);
    }

    @Override
    public void stopIndeterminateAnimation() {
    }

    private int getOldSweepAngle() {
        return this.mOldProgressFrontSweepAngle;
    }

    private int getSweepAngle() {
        return this.mProgressFrontSweepAngle;
    }

    private void createAnimationIfNeeded() {
        if (this.mProgressAnimator != null) {
            return;
        }
        this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 100L : this.mProgressAnimationDuration);
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DeterminateProgressDrawer.this.setRealProgressAngle((int)((float)DeterminateProgressDrawer.this.getOldSweepAngle() + (float)(DeterminateProgressDrawer.this.getSweepAngle() - DeterminateProgressDrawer.this.getOldSweepAngle()) * animation.getAnimatedFraction()));
            }
        });
    }
}

