/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress.drawers;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawerManager;

final class DeterminateHorizontalProgressDrawer
implements ProgressDrawer {
    private final long DEFAULT_ANIMATION_DURATION = 100L;
    private float mLeft;
    private float mRight;
    private Paint mProgressFrontPaint;
    private Paint mProgressBackPaint;
    private ValueAnimator mProgressAnimator;
    private long mProgressAnimationDuration = -1L;
    private boolean mUseProgressAnimation;
    private float mProgress;
    private float mCurrentProgress;
    private float mOldProgress;
    private float mCurrentFrontX;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    DeterminateHorizontalProgressDrawer() {
    }

    private void setRealProgress(float progress) {
        this.mCurrentProgress = progress;
        this.mCurrentFrontX = this.mLeft + (this.mRight - this.mLeft) * (progress / 100.0f);
        this.listener.onRequestInvalidate();
    }

    @Override
    public void setProgressPercent(float progressPercent) {
        float mProgress = progressPercent;
        if (mProgress > 100.0f) {
            mProgress %= 100.0f;
        }
        this.mOldProgress = this.mCurrentProgress;
        this.mProgress = mProgress;
        if (this.mUseProgressAnimation) {
            if (this.mProgressAnimator != null) {
                this.mProgressAnimator.cancel();
            }
            this.createAnimationIfNeeded();
            this.mProgressAnimator.start();
        } else {
            this.setRealProgress(mProgress);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.mUseProgressAnimation = enabled;
    }

    @Override
    public void setAnimationDuration(long millis) {
        this.mProgressAnimationDuration = millis;
        this.createAnimationIfNeeded();
        this.mProgressAnimator.setDuration(millis);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        }
    }

    @Override
    public void setListener(ProgressDrawerManager.ProgressDrawerListener listener) {
        this.listener = listener;
    }

    @Override
    public void setup(ProgressOptions progressOptions) {
        if (this.mProgressFrontPaint == null) {
            this.mProgressFrontPaint = new Paint();
        }
        if (this.mProgressBackPaint == null) {
            this.mProgressBackPaint = new Paint();
        }
        this.mProgressFrontPaint.setColor(progressOptions.getFrontColor());
        this.mProgressFrontPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mProgressBackPaint.setColor(progressOptions.getBackColor());
        this.mProgressBackPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getLeft();
        this.mRight = progressOptions.getRight();
        this.mUseProgressAnimation = progressOptions.isDeterminateAnimationEnabled();
        this.setProgressPercent(progressOptions.getValuePercent());
    }

    @Override
    public void startIndeterminateAnimation() {
    }

    @Override
    public void draw(Canvas canvas, RectF progressBounds) {
        canvas.drawRect(this.mCurrentFrontX, progressBounds.top, progressBounds.right, progressBounds.bottom, this.mProgressBackPaint);
        canvas.drawRect(progressBounds.left, progressBounds.top, this.mCurrentFrontX, progressBounds.bottom, this.mProgressFrontPaint);
    }

    @Override
    public void stopIndeterminateAnimation() {
    }

    private float getOldProgress() {
        return this.mOldProgress;
    }

    private float getProgress() {
        return this.mProgress;
    }

    private void createAnimationIfNeeded() {
        if (this.mProgressAnimator != null) {
            return;
        }
        this.mProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 100L : this.mProgressAnimationDuration);
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                DeterminateHorizontalProgressDrawer.this.setRealProgress(DeterminateHorizontalProgressDrawer.this.getOldProgress() + (DeterminateHorizontalProgressDrawer.this.getProgress() - DeterminateHorizontalProgressDrawer.this.getOldProgress()) * animation.getAnimatedFraction());
            }
        });
    }
}

