/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview.progress;

import android.os.Parcel;
import android.os.Parcelable;
import com.stefanosiano.powerlessimageview.progress.PivProgressGravity;
import com.stefanosiano.powerlessimageview.progress.PivProgressMode;
import java.lang.ref.WeakReference;

public final class ProgressOptions
implements Parcelable {
    private boolean mDeterminateAnimationEnabled;
    private int mBorderWidth;
    private float mBorderWidthPercent;
    private float mValuePercent;
    private int mFrontColor;
    private int mBackColor;
    private int mIndeterminateColor;
    private boolean mDrawWedge;
    private boolean mShadowEnabled;
    private int mShadowColor;
    private int mShadowPadding;
    private float mShadowPaddingPercent;
    private int mSize;
    private int mPadding;
    private float mSizePercent;
    private PivProgressGravity mGravity;
    private boolean mIsRtl;
    private boolean mRtlDisabled;
    private int mCalculatedSize;
    private int mCalculatedShadowPadding;
    private int mCalculatedBorderWidth;
    private float mCalculatedLeft;
    private float mCalculatedTop;
    private float mCalculatedRight;
    private float mCalculatedBottom;
    private float mCalculatedShadowLeft;
    private float mCalculatedShadowTop;
    private float mCalculatedShadowRight;
    private float mCalculatedShadowBottom;
    private int mCalculatedLastW;
    private int mCalculatedLastH;
    private PivProgressMode mCalculatedLastMode;
    private WeakReference<ProgressOptionsListener> listener;
    public static final Parcelable.Creator<ProgressOptions> CREATOR = new Parcelable.Creator<ProgressOptions>(){

        public ProgressOptions createFromParcel(Parcel in) {
            return new ProgressOptions(in);
        }

        public ProgressOptions[] newArray(int size) {
            return new ProgressOptions[size];
        }
    };

    public ProgressOptions(boolean determinateAnimationEnabled, int borderWidth, float borderWidthPercent, int size, int padding, float sizePercent, float valuePercent, int frontColor, int backColor, int indeterminateColor, int gravity, boolean rtl, boolean disableRtlSupport, boolean drawWedge, boolean shadowEnabled, int shadowColor, int shadowPadding, float shadowPaddingPercent) {
        this.mDeterminateAnimationEnabled = determinateAnimationEnabled;
        this.mBorderWidth = borderWidth;
        this.mBorderWidthPercent = borderWidthPercent;
        if (this.mBorderWidthPercent > 100.0f) {
            this.mBorderWidthPercent %= 100.0f;
        }
        this.mSize = size;
        this.mPadding = padding;
        this.mSizePercent = sizePercent;
        this.mValuePercent = valuePercent;
        this.mFrontColor = frontColor;
        this.mBackColor = backColor;
        this.mIndeterminateColor = indeterminateColor;
        this.mGravity = PivProgressGravity.fromValue(gravity);
        this.mIsRtl = rtl;
        this.mRtlDisabled = disableRtlSupport;
        this.mDrawWedge = drawWedge;
        this.mShadowEnabled = shadowEnabled;
        this.mShadowColor = shadowColor;
        this.mShadowPadding = shadowPadding;
        this.mShadowPaddingPercent = shadowPaddingPercent;
        this.mCalculatedSize = 0;
        this.mCalculatedShadowPadding = 0;
        this.mCalculatedBorderWidth = 0;
        this.mCalculatedLastW = 0;
        this.mCalculatedLastH = 0;
        this.mCalculatedLeft = 0.0f;
        this.mCalculatedTop = 0.0f;
        this.mCalculatedRight = 0.0f;
        this.mCalculatedBottom = 0.0f;
        this.mCalculatedLastMode = PivProgressMode.NONE;
    }

    public void setOptions(ProgressOptions other) {
        this.mDeterminateAnimationEnabled = other.mDeterminateAnimationEnabled;
        this.mBorderWidth = other.mBorderWidth;
        this.mBorderWidthPercent = other.mBorderWidthPercent;
        this.mValuePercent = other.mValuePercent;
        this.mFrontColor = other.mFrontColor;
        this.mBackColor = other.mBackColor;
        this.mIndeterminateColor = other.mIndeterminateColor;
        this.mDrawWedge = other.mDrawWedge;
        this.mShadowEnabled = other.mShadowEnabled;
        this.mShadowColor = other.mShadowColor;
        this.mShadowPadding = other.mShadowPadding;
        this.mShadowPaddingPercent = other.mShadowPaddingPercent;
        this.mSize = other.mSize;
        this.mPadding = other.mPadding;
        this.mSizePercent = other.mSizePercent;
        this.mGravity = other.mGravity;
        this.mIsRtl = other.mIsRtl;
        this.mRtlDisabled = other.mRtlDisabled;
        this.mCalculatedSize = other.mCalculatedSize;
        this.mCalculatedShadowPadding = other.mCalculatedShadowPadding;
        this.mCalculatedBorderWidth = other.mCalculatedBorderWidth;
        this.mCalculatedLeft = other.mCalculatedLeft;
        this.mCalculatedTop = other.mCalculatedTop;
        this.mCalculatedRight = other.mCalculatedRight;
        this.mCalculatedBottom = other.mCalculatedBottom;
        this.mCalculatedShadowLeft = other.mCalculatedShadowLeft;
        this.mCalculatedShadowTop = other.mCalculatedShadowTop;
        this.mCalculatedShadowRight = other.mCalculatedShadowRight;
        this.mCalculatedShadowBottom = other.mCalculatedShadowBottom;
        this.mCalculatedLastW = other.mCalculatedLastW;
        this.mCalculatedLastH = other.mCalculatedLastH;
        this.mCalculatedLastMode = other.mCalculatedLastMode;
        this.listener = other.listener;
    }

    public final void calculateBounds(int w, int h, PivProgressMode mode) {
        this.mCalculatedLastW = w;
        this.mCalculatedLastH = h;
        this.mCalculatedLastMode = mode;
        if (mode == PivProgressMode.NONE) {
            this.mCalculatedLeft = 0.0f;
            this.mCalculatedRight = 0.0f;
            this.mCalculatedTop = 0.0f;
            this.mCalculatedBottom = 0.0f;
            this.mCalculatedShadowLeft = 0.0f;
            this.mCalculatedShadowRight = 0.0f;
            this.mCalculatedShadowTop = 0.0f;
            this.mCalculatedShadowBottom = 0.0f;
            return;
        }
        int maxSize = w < h ? w : h;
        switch (mode) {
            case DETERMINATE: 
            case INDETERMINATE: {
                maxSize = w < h ? w : h;
                break;
            }
            case HORIZONTAL_DETERMINATE: 
            case HORIZONTAL_INDETERMINATE: {
                maxSize = w;
                break;
            }
            default: {
                this.mSize = 0;
            }
        }
        maxSize = maxSize - this.mPadding - this.mPadding;
        this.mCalculatedSize = (int)((float)maxSize * this.mSizePercent / 100.0f);
        if (this.mSize >= 0) {
            this.mCalculatedSize = this.mSize;
        }
        if (this.mCalculatedSize > maxSize) {
            this.mCalculatedSize = maxSize;
        }
        this.mCalculatedShadowPadding = (int)((float)this.mCalculatedSize * this.mShadowPaddingPercent / 100.0f);
        if (this.mShadowPadding >= 0) {
            this.mCalculatedShadowPadding = this.mShadowPadding;
        }
        if (!this.mShadowEnabled) {
            this.mCalculatedShadowPadding = 0;
        }
        this.mCalculatedBorderWidth = Math.round((float)this.mCalculatedSize * this.mBorderWidthPercent / 100.0f);
        if (this.mBorderWidth >= 0) {
            this.mCalculatedBorderWidth = this.mBorderWidth;
        }
        if (this.mCalculatedBorderWidth < 1) {
            this.mCalculatedBorderWidth = 1;
        }
        switch (mode) {
            case DETERMINATE: 
            case INDETERMINATE: {
                this.mCalculatedShadowLeft = this.mGravity.isGravityLeft(this.mIsRtl && !this.mRtlDisabled) ? (float)this.mPadding : (this.mGravity.isGravityRight(this.mIsRtl && !this.mRtlDisabled) ? (float)(w - this.mCalculatedSize - this.mPadding) : (float)((w - this.mCalculatedSize) / 2));
                this.mCalculatedShadowTop = this.mGravity.isGravityTop() ? (float)this.mPadding : (this.mGravity.isGravityBottom() ? (float)(h - this.mCalculatedSize - this.mPadding) : (float)((h - this.mCalculatedSize) / 2));
                this.mCalculatedShadowRight = this.mCalculatedShadowLeft + (float)this.mCalculatedSize;
                this.mCalculatedShadowBottom = this.mCalculatedShadowTop + (float)this.mCalculatedSize;
                this.mCalculatedLeft = this.mCalculatedShadowLeft + (float)this.mCalculatedShadowPadding + (float)(this.mCalculatedBorderWidth / 2);
                this.mCalculatedRight = this.mCalculatedShadowRight - (float)this.mCalculatedShadowPadding - (float)(this.mCalculatedBorderWidth / 2);
                this.mCalculatedTop = this.mCalculatedShadowTop + (float)this.mCalculatedShadowPadding + (float)(this.mCalculatedBorderWidth / 2);
                this.mCalculatedBottom = this.mCalculatedShadowBottom - (float)this.mCalculatedShadowPadding - (float)(this.mCalculatedBorderWidth / 2);
                break;
            }
            case HORIZONTAL_DETERMINATE: 
            case HORIZONTAL_INDETERMINATE: {
                this.mCalculatedShadowLeft = this.mGravity.isGravityLeft(this.mIsRtl && !this.mRtlDisabled) ? (float)this.mPadding : (this.mGravity.isGravityRight(this.mIsRtl && !this.mRtlDisabled) ? (float)(w - this.mCalculatedSize - this.mPadding) : (float)((w - this.mCalculatedSize) / 2));
                this.mCalculatedShadowTop = this.mGravity.isGravityTop() ? (float)this.mPadding : (this.mGravity.isGravityBottom() ? (float)(h - this.mCalculatedBorderWidth - this.mPadding) : (float)((h - this.mCalculatedBorderWidth) / 2));
                this.mCalculatedShadowRight = this.mCalculatedShadowLeft + (float)this.mCalculatedSize;
                this.mCalculatedShadowBottom = this.mCalculatedShadowTop + (float)this.mCalculatedBorderWidth;
                this.mCalculatedLeft = this.mCalculatedShadowLeft + (float)this.mCalculatedShadowPadding;
                this.mCalculatedRight = this.mCalculatedShadowRight - (float)this.mCalculatedShadowPadding;
                this.mCalculatedTop = this.mCalculatedShadowTop + (float)this.mCalculatedShadowPadding;
                this.mCalculatedBottom = this.mCalculatedShadowBottom - (float)this.mCalculatedShadowPadding;
                break;
            }
            default: {
                this.mCalculatedShadowLeft = 0.0f;
                this.mCalculatedShadowRight = 0.0f;
                this.mCalculatedShadowTop = 0.0f;
                this.mCalculatedShadowBottom = 0.0f;
                this.mCalculatedLeft = 0.0f;
                this.mCalculatedRight = 0.0f;
                this.mCalculatedTop = 0.0f;
                this.mCalculatedBottom = 0.0f;
            }
        }
    }

    public final float getLeft() {
        return this.mCalculatedLeft;
    }

    public final float getTop() {
        return this.mCalculatedTop;
    }

    public final float getRight() {
        return this.mCalculatedRight;
    }

    public final float getBottom() {
        return this.mCalculatedBottom;
    }

    public final float getShadowLeft() {
        return this.mCalculatedShadowLeft;
    }

    public final float getShadowTop() {
        return this.mCalculatedShadowTop;
    }

    public final float getShadowRight() {
        return this.mCalculatedShadowRight;
    }

    public final float getShadowBottom() {
        return this.mCalculatedShadowBottom;
    }

    public void setDeterminateAnimationEnabled(boolean determinateAnimationEnabled) {
        this.mDeterminateAnimationEnabled = determinateAnimationEnabled;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setBorderWidthPercent(float borderWidthPercent) {
        if (borderWidthPercent > 100.0f) {
            borderWidthPercent %= 100.0f;
        }
        this.mBorderWidthPercent = borderWidthPercent;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setValuePercent(float valuePercent) {
        if (valuePercent > 100.0f) {
            valuePercent %= 100.0f;
        }
        if (valuePercent < 0.0f) {
            valuePercent = 0.0f;
        }
        this.mValuePercent = valuePercent;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setFrontColor(int frontColor) {
        this.mFrontColor = frontColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setBackColor(int backColor) {
        this.mBackColor = backColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setIndeterminateColor(int indeterminateColor) {
        this.mIndeterminateColor = indeterminateColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setDrawWedge(boolean mDrawWedge) {
        this.mDrawWedge = mDrawWedge;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setSize(int size) {
        this.mSize = size;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setSizePercent(float sizePercent) {
        if (sizePercent > 100.0f) {
            sizePercent %= 100.0f;
        }
        this.mSizePercent = sizePercent;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setGravity(PivProgressGravity mGravity) {
        this.mGravity = mGravity;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setRtlDisabled(boolean rtlDisabled) {
        this.mRtlDisabled = rtlDisabled;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onOptionsUpdated(this);
        }
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.mShadowEnabled = shadowEnabled;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowPadding(int padding) {
        this.mShadowPadding = padding;
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public void setShadowPaddingPercent(float paddingPercent) {
        if (paddingPercent > 100.0f) {
            this.mShadowPaddingPercent = paddingPercent % 100.0f;
        }
        this.calculateBounds(this.mCalculatedLastW, this.mCalculatedLastH, this.mCalculatedLastMode);
        if (this.listener.get() != null) {
            ((ProgressOptionsListener)this.listener.get()).onSizeUpdated(this);
        }
    }

    public float getBorderWidthPercent() {
        return this.mBorderWidthPercent;
    }

    public final int getBorderWidth() {
        return this.mBorderWidth;
    }

    public int getSize() {
        return this.mSize;
    }

    public float getSizePercent() {
        return this.mSizePercent;
    }

    public int getPadding() {
        return this.mPadding;
    }

    public PivProgressGravity getGravity() {
        return this.mGravity;
    }

    public boolean isRtlDisabled() {
        return this.mRtlDisabled;
    }

    public int getShadowPadding() {
        return this.mShadowPadding;
    }

    public float getShadowPaddingPercent() {
        return this.mShadowPaddingPercent;
    }

    public int getCalculatedSize() {
        return this.mCalculatedSize;
    }

    public float getCalculatedShadowPadding() {
        return this.mCalculatedShadowPadding;
    }

    public final boolean isDeterminateAnimationEnabled() {
        return this.mDeterminateAnimationEnabled;
    }

    public final float getValuePercent() {
        return this.mValuePercent;
    }

    public int getCalculatedBorderWidth() {
        return this.mCalculatedBorderWidth;
    }

    public final int getFrontColor() {
        return this.mFrontColor;
    }

    public final int getBackColor() {
        return this.mBackColor;
    }

    public final int getIndeterminateColor() {
        return this.mIndeterminateColor;
    }

    public final boolean isDrawWedge() {
        return this.mDrawWedge;
    }

    public void setListener(ProgressOptionsListener listener) {
        this.listener = new WeakReference<ProgressOptionsListener>(listener);
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public boolean isShadowEnabled() {
        return this.mShadowEnabled;
    }

    public int describeContents() {
        return 0;
    }

    protected ProgressOptions(Parcel in) {
        this.mDeterminateAnimationEnabled = in.readByte() != 0;
        this.mBorderWidth = in.readInt();
        this.mBorderWidthPercent = in.readFloat();
        this.mValuePercent = in.readFloat();
        this.mFrontColor = in.readInt();
        this.mBackColor = in.readInt();
        this.mIndeterminateColor = in.readInt();
        this.mDrawWedge = in.readByte() != 0;
        this.mSize = in.readInt();
        this.mPadding = in.readInt();
        this.mSizePercent = in.readFloat();
        this.mIsRtl = in.readByte() != 0;
        this.mRtlDisabled = in.readByte() != 0;
        this.mCalculatedSize = in.readInt();
        this.mCalculatedBorderWidth = in.readInt();
        this.mCalculatedLeft = in.readFloat();
        this.mCalculatedTop = in.readFloat();
        this.mCalculatedRight = in.readFloat();
        this.mCalculatedBottom = in.readFloat();
        this.mCalculatedLastW = in.readInt();
        this.mCalculatedLastH = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mDeterminateAnimationEnabled ? 1 : 0));
        dest.writeInt(this.mBorderWidth);
        dest.writeFloat(this.mBorderWidthPercent);
        dest.writeFloat(this.mValuePercent);
        dest.writeInt(this.mFrontColor);
        dest.writeInt(this.mBackColor);
        dest.writeInt(this.mIndeterminateColor);
        dest.writeByte((byte)(this.mDrawWedge ? 1 : 0));
        dest.writeInt(this.mSize);
        dest.writeInt(this.mPadding);
        dest.writeFloat(this.mSizePercent);
        dest.writeByte((byte)(this.mIsRtl ? 1 : 0));
        dest.writeByte((byte)(this.mRtlDisabled ? 1 : 0));
        dest.writeInt(this.mCalculatedSize);
        dest.writeInt(this.mCalculatedBorderWidth);
        dest.writeFloat(this.mCalculatedLeft);
        dest.writeFloat(this.mCalculatedTop);
        dest.writeFloat(this.mCalculatedRight);
        dest.writeFloat(this.mCalculatedBottom);
        dest.writeInt(this.mCalculatedLastW);
        dest.writeInt(this.mCalculatedLastH);
    }

    public static interface ProgressOptionsListener {
        public void onOptionsUpdated(ProgressOptions var1);

        public void onSizeUpdated(ProgressOptions var1);
    }
}

