/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerlessimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.stefanosiano.powerlessimageview.R;
import com.stefanosiano.powerlessimageview.progress.PivProgressGravity;
import com.stefanosiano.powerlessimageview.progress.PivProgressMode;
import com.stefanosiano.powerlessimageview.progress.ProgressOptions;
import com.stefanosiano.powerlessimageview.progress.drawers.ProgressDrawerManager;

public class PowerlessImageView
extends ImageView {
    private static final boolean DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
    private static final int DEFAULT_PROGRESS_WIDTH = -1;
    private static final float DEFAULT_PROGRESS_WIDTH_PERCENT = 8.0f;
    private static final int DEFAULT_PROGRESS_SIZE = -1;
    private static final float DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
    private static final int DEFAULT_PROGRESS_PADDING = 2;
    private static final int DEFAULT_PROGRESS_PERCENT = 0;
    private static final int DEFAULT_PROGRESS_GRAVITY = PivProgressGravity.CENTER.getValue();
    private static final boolean DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT = false;
    private static final boolean DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE = false;
    private static final boolean DEFAULT_PROGRESS_SHADOW_ENABLED = true;
    private static final int DEFAULT_PROGRESS_MODE = PivProgressMode.NONE.getValue();
    private static final int DEFAULT_PROGRESS_SHADOW_PADDING = -1;
    private static final float DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT = 8.0f;
    private final ProgressDrawerManager mProgressDrawerManager;

    public PowerlessImageView(Context context) {
        this(context, null, 0);
    }

    public PowerlessImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PowerlessImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PowerlessImageView, defStyleAttr, 0);
        ProgressOptions progressOptions = new ProgressOptions(a.getBoolean(R.styleable.PowerlessImageView_piv_progress_determinate_animation_enabled, true), a.getDimensionPixelSize(R.styleable.PowerlessImageView_piv_progress_border_width, (int)TypedValue.applyDimension((int)1, (float)-1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getFloat(R.styleable.PowerlessImageView_piv_progress_border_width_percent, 8.0f), a.getDimensionPixelSize(R.styleable.PowerlessImageView_piv_progress_size, (int)TypedValue.applyDimension((int)1, (float)-1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getDimensionPixelSize(R.styleable.PowerlessImageView_piv_progress_padding, (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getFloat(R.styleable.PowerlessImageView_piv_progress_size_percent, 40.0f), a.getFloat(R.styleable.PowerlessImageView_piv_progress_value_percent, 0.0f), a.getColor(R.styleable.PowerlessImageView_piv_progress_front_color, Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.piv_default_progress_front_color, this.getContext().getTheme()) : this.getResources().getColor(R.color.piv_default_progress_front_color)), a.getColor(R.styleable.PowerlessImageView_piv_progress_back_color, Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.piv_default_progress_back_color, this.getContext().getTheme()) : this.getResources().getColor(R.color.piv_default_progress_back_color)), a.getColor(R.styleable.PowerlessImageView_piv_progress_indeterminate_color, Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.piv_default_progress_indeterminate_color, this.getContext().getTheme()) : this.getResources().getColor(R.color.piv_default_progress_indeterminate_color)), a.getInteger(R.styleable.PowerlessImageView_piv_progress_gravity, DEFAULT_PROGRESS_GRAVITY), Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1, a.getBoolean(R.styleable.PowerlessImageView_piv_progress_rtl_disabled, false), a.getBoolean(R.styleable.PowerlessImageView_piv_progress_draw_wedge, false), a.getBoolean(R.styleable.PowerlessImageView_piv_progress_shadow_enabled, true), a.getColor(R.styleable.PowerlessImageView_piv_progress_shadow_color, Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.piv_default_progress_shadow_color, this.getContext().getTheme()) : this.getResources().getColor(R.color.piv_default_progress_shadow_color)), a.getDimensionPixelSize(R.styleable.PowerlessImageView_piv_progress_shadow_padding, (int)TypedValue.applyDimension((int)1, (float)-1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())), a.getFloat(R.styleable.PowerlessImageView_piv_progress_shadow_padding_percent, 8.0f));
        PivProgressMode mode = PivProgressMode.fromValue(a.getInteger(R.styleable.PowerlessImageView_piv_progress_mode, DEFAULT_PROGRESS_MODE));
        a.recycle();
        this.mProgressDrawerManager = new ProgressDrawerManager(this, progressOptions);
        this.changeProgressMode(mode);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mProgressDrawerManager.onSizeChanged(w, h);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mProgressDrawerManager.onDraw(canvas);
    }

    public final void changeProgressMode(PivProgressMode progressMode) {
        this.mProgressDrawerManager.changeProgressMode(progressMode);
    }

    public final ProgressOptions getProgressOptions() {
        return this.mProgressDrawerManager.getProgressOptions();
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("super_state", super.onSaveInstanceState());
        bundle.putParcelable("progress_drawer_manager", (Parcelable)this.mProgressDrawerManager.saveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgressDrawerManager.restoreInstanceState((Bundle)bundle.getParcelable("progress_options"));
            state = bundle.getParcelable("super_state");
        }
        super.onRestoreInstanceState(state);
    }
}

