/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.sharedpreferences;

import android.util.Log;
import com.stefanosiano.powerful_libraries.sharedpreferences.Crypter;
import com.stefanosiano.powerful_libraries.sharedpreferences.PrefContainer;
import com.stefanosiano.powerful_libraries.sharedpreferences.Prefs;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J,\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011J\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u001a\u0010\u001d\u001a\u00020\b2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010\u0016\u001a\u00020\u0006J&\u0010!\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\"\u0010\"\u001a\u00020\b2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u0012\u0010#\u001a\u00020\b2\n\u0010\u001e\u001a\u00060\u001fj\u0002` J$\u0010$\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J\u0006\u0010'\u001a\u00020\bJ$\u0010(\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J$\u0010)\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J\u0016\u0010+\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006J8\u0010,\u001a\u00020\b2\n\u0010\u001e\u001a\u00060-j\u0002`.2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J,\u0010/\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J$\u00100\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&J\u000e\u00101\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u00102\u001a\u00020\bJ\u000e\u00103\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/stefanosiano/powerful_libraries/sharedpreferences/Logger;", "", "()V", "mLogLevel", "", "mTag", "", "log", "", "logLevel", "logType", "logText", "logBuild", "defaultPrefsName", "crypter", "Lcom/stefanosiano/powerful_libraries/sharedpreferences/Crypter;", "prefsMap", "Ljava/util/HashMap;", "Lcom/stefanosiano/powerful_libraries/sharedpreferences/PrefContainer;", "logChangeCrypter", "logClear", "logContains", "key", "found", "", "logDecrypt", "encryptedKey", "encryptedValue", "value", "logDecryptException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logEncrypt", "logEncryptException", "logErrorChangeCrypter", "logGet", "classs", "Ljava/lang/Class;", "logGetAll", "logGetCached", "logNewPref", "defaultValue", "logParseNotFound", "logParseNumberException", "Ljava/lang/NumberFormatException;", "Lkotlin/NumberFormatException;", "logParseTypeException", "logPut", "logRemove", "logTerminate", "setLevel", "powerfulsharedpreferences_release"})
public final class Logger {
    private static int mLogLevel;
    private static final String mTag = "Prefs";
    public static final Logger INSTANCE;

    public final void setLevel(int logLevel) {
        mLogLevel = logLevel;
    }

    public final void logBuild(@NotNull String defaultPrefsName, @Nullable Crypter crypter, @NotNull HashMap<String, PrefContainer> prefsMap) {
        Intrinsics.checkParameterIsNotNull((Object)defaultPrefsName, (String)"defaultPrefsName");
        Intrinsics.checkParameterIsNotNull(prefsMap, (String)"prefsMap");
        if (mLogLevel < Prefs.Builder.Companion.getLOG_VERBOSE()) {
            return;
        }
        Log.v((String)mTag, (String)("Initialized with default SharedPreferences " + defaultPrefsName + " with encryption " + (crypter != null)));
        for (PrefContainer prefContainer : prefsMap.values()) {
            Log.v((String)mTag, (String)("Additional SharedPreferences files: " + prefContainer.getName() + " with encryption " + (crypter != null && prefContainer.getUseCrypter())));
        }
    }

    public final void logErrorChangeCrypter(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.log(Prefs.Builder.Companion.getLOG_ERRORS(), 4, "Trying to change crypter, but got an error: " + e.getLocalizedMessage() + "\nNo values were changed!");
    }

    public final void logChangeCrypter() {
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Crypter was changed, and all values have been encrypted");
    }

    public final void logTerminate() {
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Terminating and releasing all objects in memory");
    }

    public final void logNewPref(@NotNull String key, @NotNull String defaultValue, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        int n = Prefs.Builder.Companion.getLOG_VERBOSE();
        StringBuilder stringBuilder = new StringBuilder().append("Created preference ").append(key).append(" : ").append(defaultValue).append(" (");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 1, stringBuilder.append((String)((Object)clazz)).append(')').toString());
    }

    public final void logGetAll() {
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Retrieving all the preferences");
    }

    public final void logClear() {
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Clearing all the preferences");
    }

    public final void logRemove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Removing " + key);
    }

    public final void logGet(@NotNull String key, @NotNull String value, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int n = Prefs.Builder.Companion.getLOG_VALUES();
        StringBuilder stringBuilder = new StringBuilder().append("Retrieved ").append(key).append(" : ").append(value).append(" (");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 1, stringBuilder.append((String)((Object)clazz)).append(')').toString());
    }

    public final void logGetCached(@NotNull String key, @NotNull String value, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int n = Prefs.Builder.Companion.getLOG_VALUES();
        StringBuilder stringBuilder = new StringBuilder().append("Retrieved from cache ").append(key).append(" : ").append(value).append(" (");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 1, stringBuilder.append((String)((Object)clazz)).append(')').toString());
    }

    public final void logPut(@NotNull String key, @NotNull String value, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        int n = Prefs.Builder.Companion.getLOG_VALUES();
        StringBuilder stringBuilder = new StringBuilder().append("Put ").append(key).append(" : ").append(value).append(" (");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 1, stringBuilder.append((String)((Object)clazz)).append(')').toString());
    }

    public final void logContains(@NotNull String key, boolean found) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 1, "Check existance of " + key + ": " + found);
    }

    public final void logDecryptException(@NotNull Exception e, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 4, "Error decrypting " + key + " \n" + e.getLocalizedMessage());
    }

    public final void logEncryptException(@NotNull Exception e, @NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 4, "Error encrypting " + key + " : " + value + " \n" + e.getLocalizedMessage());
    }

    public final void logDecrypt(@NotNull String key, @NotNull String encryptedKey, @NotNull String encryptedValue, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)encryptedKey, (String)"encryptedKey");
        Intrinsics.checkParameterIsNotNull((Object)encryptedValue, (String)"encryptedValue");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 2, "Retrieved " + key + " : " + value + " from " + encryptedKey + " : " + encryptedValue);
    }

    public final void logEncrypt(@NotNull String key, @NotNull String encryptedKey, @NotNull String encryptedValue, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)encryptedKey, (String)"encryptedKey");
        Intrinsics.checkParameterIsNotNull((Object)encryptedValue, (String)"encryptedValue");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.log(Prefs.Builder.Companion.getLOG_VERBOSE(), 2, "Saving " + key + " : " + value + " as " + encryptedKey + " : " + encryptedValue);
    }

    public final void logParseNotFound(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        this.log(Prefs.Builder.Companion.getLOG_ERRORS(), 3, "No data found for key " + key + ". Returning default value: " + defaultValue);
    }

    public final void logParseNumberException(@NotNull NumberFormatException e, @NotNull String key, @NotNull String value, @NotNull String defaultValue, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        int n = Prefs.Builder.Companion.getLOG_ERRORS();
        StringBuilder stringBuilder = new StringBuilder().append("Error trying to parse ").append(key).append(" : ").append(value).append(" as ");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 4, stringBuilder.append((String)((Object)clazz)).append(". ").append(e.getLocalizedMessage()).append("\nReturning default value: ").append(defaultValue).toString());
    }

    public final void logParseTypeException(@NotNull String key, @NotNull String value, @NotNull String defaultValue, @Nullable Class<?> classs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        int n = Prefs.Builder.Companion.getLOG_ERRORS();
        StringBuilder stringBuilder = new StringBuilder().append("Don't know hot to parse ").append(key).append(" : '").append(value).append("' as ");
        Class<?> clazz = classs;
        if (clazz == null || (clazz = clazz.getSimpleName()) == null) {
            clazz = "unknown";
        }
        this.log(n, 4, stringBuilder.append((String)((Object)clazz)).append(". Returning default value: ").append(defaultValue).toString());
    }

    private final void log(int logLevel, int logType, String logText) {
        if (mLogLevel < logLevel) {
            return;
        }
        switch (logType) {
            case 1: {
                Log.d((String)mTag, (String)logText);
                break;
            }
            case 2: {
                Log.v((String)mTag, (String)logText);
                break;
            }
            case 3: {
                Log.w((String)mTag, (String)logText);
                break;
            }
            case 4: {
                Log.e((String)mTag, (String)logText);
            }
        }
    }

    private Logger() {
    }

    static {
        Logger logger;
        INSTANCE = logger = new Logger();
    }
}

