/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.sharedpreferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.stefanosiano.powerfullibraries.sharedpreferences.BPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.Crypter;
import com.stefanosiano.powerfullibraries.sharedpreferences.DPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.DefaultCrypter;
import com.stefanosiano.powerfullibraries.sharedpreferences.DummyPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.EnumPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.FPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.IPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.LPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.Logger;
import com.stefanosiano.powerfullibraries.sharedpreferences.PowerfulPreference;
import com.stefanosiano.powerfullibraries.sharedpreferences.PrefContainer;
import com.stefanosiano.powerfullibraries.sharedpreferences.SPreference;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001DB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004J\u001d\u0010!\u001a\u00020\b\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0086\u0002J\"\u0010%\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010'\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010(\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0086\u0002\u00a2\u0006\u0002\u0010)J\u0011\u0010(\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002J\u0019\u0010(\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010+\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030,J\u001a\u0010+\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030,2\b\u0010 \u001a\u0004\u0018\u00010\u0004J\u001a\u0010-\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J?\u00102\u001a\b\u0012\u0004\u0012\u0002H\"0$\"\u000e\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\"052\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"\u00a2\u0006\u0002\u00106JI\u00102\u001a\b\u0012\u0004\u0012\u0002H\"0$\"\u000e\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\"052\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"2\b\u00107\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u00108J'\u00109\u001a\b\u0012\u0004\u0012\u0002H\"0$\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"\u00a2\u0006\u0002\u0010:J1\u00109\u001a\b\u0012\u0004\u0012\u0002H\"0$\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"2\b\u00107\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010;J>\u0010<\u001a\u00020\b26\u0010=\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010J'\u0010>\u001a\u00020\u0015\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$2\u0006\u0010\u0014\u001a\u0002H\"\u00a2\u0006\u0002\u0010?J!\u0010>\u001a\u00020\u0015\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"\u00a2\u0006\u0002\u0010@J)\u0010>\u001a\u00020\u0015\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u0002H\"2\u0006\u0010*\u001a\u00020\u0004\u00a2\u0006\u0002\u0010AJ\u001a\u0010B\u001a\u00020\u0015\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$J>\u0010C\u001a\u00020\b26\u0010=\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R~\u0010\u000e\u001ar\u00124\u00122\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u00100\u000fj8\u00124\u00122\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/stefanosiano/powerfullibraries/sharedpreferences/Prefs;", "", "()V", "CHARSET_UTF8", "", "cacheMap", "Ljava/util/HashMap;", "mCacheEnabled", "", "mCrypter", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/Crypter;", "mDefaultName", "mDefaultPrefs", "Landroid/content/SharedPreferences;", "prefChangedCallbacks", "Ljava/util/ArrayList;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "key", "value", "", "Lkotlin/collections/ArrayList;", "prefMap", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/PrefContainer;", "changeCrypter", "newCrypter", "pass", "salt", "", "clear", "Landroid/content/SharedPreferences$Editor;", "preferencesFileName", "contains", "T", "preference", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;", "encryptAndPut", "findCrypter", "findPref", "get", "(Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;)Ljava/lang/Object;", "preferenceName", "getAll", "", "getAndDecrypt", "init", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/Prefs$Builder;", "context", "Landroid/content/Context;", "newEnumPref", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Enum;)Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;", "prefName", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Enum;Ljava/lang/String;)Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;", "newPref", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;", "observe", "function", "put", "(Lcom/stefanosiano/powerfullibraries/sharedpreferences/PowerfulPreference;Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "remove", "stopObserve", "Builder", "powerfulsharedpreferences_release"})
public final class Prefs {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static SharedPreferences mDefaultPrefs;
    private static String mDefaultName;
    private static boolean mCacheEnabled;
    private static Crypter mCrypter;
    private static final HashMap<String, PrefContainer> prefMap;
    private static final HashMap<String, Object> cacheMap;
    private static final ArrayList<Function2<String, Object, Unit>> prefChangedCallbacks;
    public static final Prefs INSTANCE;

    @NotNull
    public final Builder init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        return new Builder(context2);
    }

    public final void changeCrypter(@NotNull String pass, @NotNull byte[] salt) {
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        Intrinsics.checkParameterIsNotNull((Object)salt, (String)"salt");
        SharedPreferences sharedPreferences = mDefaultPrefs;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultPrefs");
        }
        Crypter newCrypter = Builder.Companion.generateDefaultCrypter$powerfulsharedpreferences_release(sharedPreferences, pass, salt);
        this.changeCrypter(newCrypter);
    }

    public final synchronized void changeCrypter(@Nullable Crypter newCrypter) {
        HashMap maps = new HashMap(prefMap.size());
        if (mCacheEnabled) {
            cacheMap.clear();
        }
        for (PrefContainer prefContainer : prefMap.values()) {
            Object element$iv2;
            if (!prefContainer.getUseCrypter()) continue;
            Object object = prefContainer.getSharedPreferences();
            if (object == null || (object = object.getAll()) == null) {
                continue;
            }
            Object values = object;
            HashMap newValues = new HashMap(values.size());
            try {
                Iterable $receiver$iv = values.keySet();
                for (Object element$iv2 : $receiver$iv) {
                    Object object2;
                    Object newKey;
                    String it = (String)element$iv2;
                    Object object3 = mCrypter;
                    if (object3 == null || (object3 = object3.decrypt(it)) == null) {
                        object3 = newKey = it;
                    }
                    if ((object2 = mCrypter) == null || (object2 = object2.decrypt(String.valueOf(values.get(it)))) == null) {
                        object2 = String.valueOf(values.get(it));
                    }
                    Object newVal = object2;
                    Map map = newValues;
                    Object object4 = newCrypter;
                    if (object4 == null || (object4 = object4.encrypt((String)newKey)) == null) {
                        Object object5 = newKey;
                        object4 = object5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"newKey");
                    }
                    Object object6 = object4;
                    Object object7 = newCrypter;
                    if (object7 == null || (object7 = object7.encrypt((String)newVal)) == null) {
                        object7 = newVal;
                    }
                    Object object8 = object7;
                    map.put(object6, object8);
                }
            }
            catch (Exception e) {
                Logger.INSTANCE.logErrorChangeCrypter(e);
                return;
            }
            Map e = maps;
            String string = prefContainer.getName();
            element$iv2 = newValues;
            e.put(string, element$iv2);
            values.clear();
        }
        for (PrefContainer prefContainer : prefMap.values()) {
            Object object;
            if (!prefContainer.getUseCrypter()) continue;
            SharedPreferences sharedPreferences = prefContainer.getSharedPreferences();
            if (sharedPreferences != null && (sharedPreferences = sharedPreferences.edit()) != null && (sharedPreferences = sharedPreferences.clear()) != null) {
                sharedPreferences.apply();
            }
            if ((object = (Map)maps.get(prefContainer.getName())) == null || (object = object.keySet()) == null) continue;
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                SharedPreferences sharedPreferences2 = prefContainer.getSharedPreferences();
                if (sharedPreferences2 == null || (sharedPreferences2 = sharedPreferences2.edit()) == null) continue;
                Map map = (Map)maps.get(prefContainer.getName());
                if ((sharedPreferences2 = sharedPreferences2.putString(it, map != null ? (String)map.get(it) : null)) == null) continue;
                sharedPreferences2.apply();
            }
        }
        mCrypter = newCrypter;
        Logger.INSTANCE.logChangeCrypter();
    }

    public final boolean observe(@NotNull Function2<? super String, Object, Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return prefChangedCallbacks.add(function);
    }

    public final boolean stopObserve(@NotNull Function2<? super String, Object, Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return prefChangedCallbacks.remove(function);
    }

    @NotNull
    public final <T> PowerfulPreference<T> newPref(@NotNull String key, T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.newPref(key, value, null);
    }

    @NotNull
    public final <T> PowerfulPreference<T> newPref(@NotNull String key, T value, @Nullable String prefName) {
        PowerfulPreference powerfulPreference;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        T t = value;
        if (t instanceof Integer) {
            T t2 = value;
            if (t2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            powerfulPreference = new IPreference(key, (Integer)t2, prefName);
        } else if (t instanceof Float) {
            T t3 = value;
            if (t3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
            }
            powerfulPreference = new FPreference(key, ((Float)t3).floatValue(), prefName);
        } else if (t instanceof Double) {
            T t4 = value;
            if (t4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            powerfulPreference = new DPreference(key, (Double)t4, prefName);
        } else if (t instanceof Boolean) {
            T t5 = value;
            if (t5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            powerfulPreference = new BPreference(key, (Boolean)t5, prefName);
        } else if (t instanceof String) {
            T t6 = value;
            if (t6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            powerfulPreference = new SPreference(key, (String)t6, prefName);
        } else if (t instanceof Long) {
            T t7 = value;
            if (t7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
            }
            powerfulPreference = new LPreference(key, (Long)t7, prefName);
        } else {
            powerfulPreference = null;
        }
        if (powerfulPreference == null) {
            throw (Throwable)new RuntimeException("Cannot understand preference type. Please, provide a valid class");
        }
        PowerfulPreference preference = powerfulPreference;
        Logger.INSTANCE.logNewPref(key, preference.toPreferences(value), preference.getPrefClass());
        return preference;
    }

    @NotNull
    public final <T extends Enum<T>> PowerfulPreference<T> newEnumPref(@NotNull Class<T> clazz, @NotNull String key, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.newEnumPref(clazz, key, value, null);
    }

    @NotNull
    public final <T extends Enum<T>> PowerfulPreference<T> newEnumPref(@NotNull Class<T> clazz, @NotNull String key, @NotNull T value, @Nullable String prefName) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        PowerfulPreference preference = new EnumPreference<T>(clazz, key, value, prefName);
        Logger.INSTANCE.logNewPref(key, preference.toPreferences(value), preference.getPrefClass());
        return preference;
    }

    @NotNull
    public final synchronized String get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (String)this.get(new DummyPreference(key, "", null));
    }

    @NotNull
    public final synchronized String get(@NotNull String key, @NotNull String preferenceName) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)preferenceName, (String)"preferenceName");
        return (String)this.get(new DummyPreference(key, "", preferenceName));
    }

    public final synchronized <T> T get(@NotNull PowerfulPreference<T> preference) {
        Object object;
        T valueToReturn;
        Intrinsics.checkParameterIsNotNull(preference, (String)"preference");
        if (mCacheEnabled && cacheMap.containsKey(preference.getCacheMapKey$powerfulsharedpreferences_release())) {
            Object value = cacheMap.get(preference.getCacheMapKey$powerfulsharedpreferences_release());
            Logger.INSTANCE.logGetCached(preference.getKey(), preference.toPreferences(value), preference.getPrefClass());
            return (T)value;
        }
        String value = this.getAndDecrypt(preference.getKey(), preference.getPreferencesFileName());
        if (TextUtils.isEmpty((CharSequence)value)) {
            Logger.INSTANCE.logParseNotFound(preference.getKey(), preference.toPreferences(preference.getDefaultValue()) + "");
            valueToReturn = preference.getDefaultValue();
        } else {
            try {
                T parsed = preference.parse(value);
                Logger.INSTANCE.logGet(preference.getKey(), value, preference.getPrefClass());
                object = parsed;
            }
            catch (NumberFormatException e) {
                Logger.INSTANCE.logParseNumberException(e, preference.getKey(), value, preference.toPreferences(preference.getDefaultValue()) + "", preference.getPrefClass());
                object = preference.getDefaultValue();
            }
            catch (Exception e) {
                Logger.INSTANCE.logParseTypeException(preference.getKey(), value, preference.toPreferences(preference.getDefaultValue()) + "", preference.getPrefClass());
                object = preference.getDefaultValue();
            }
            valueToReturn = object;
        }
        if (mCacheEnabled) {
            object = cacheMap;
            String string = preference.getCacheMapKey$powerfulsharedpreferences_release();
            T t = valueToReturn;
            object.put((String)string, t);
        }
        return valueToReturn;
    }

    public final synchronized <T> void put(@NotNull String key, T value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        PowerfulPreference powerfulPreference = new DummyPreference(key, (Object)value, null);
        T t = value;
        if (t == null || (t = t.toString()) == null) {
            t = "";
        }
        this.put(powerfulPreference, t);
    }

    public final synchronized <T> void put(@NotNull String key, T value, @NotNull String preferenceName) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)preferenceName, (String)"preferenceName");
        PowerfulPreference powerfulPreference = new DummyPreference(key, (Object)value, preferenceName);
        T t = value;
        if (t == null || (t = t.toString()) == null) {
            t = "";
        }
        this.put(powerfulPreference, t);
    }

    public final synchronized <T> void put(@NotNull PowerfulPreference<T> preference, T value) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull(preference, (String)"preference");
        if (mCacheEnabled) {
            Map map = cacheMap;
            String string3 = preference.getCacheMapKey$powerfulsharedpreferences_release();
            T t = value;
            map.put(string3, t);
        }
        if (preference instanceof DummyPreference) {
            cacheMap.remove(preference.getCacheMapKey$powerfulsharedpreferences_release());
        }
        Iterable $receiver$iv = prefChangedCallbacks;
        for (Object element$iv : $receiver$iv) {
            Function2 it = (Function2)element$iv;
            T t = value;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            it.invoke((Object)preference.getKey(), t);
        }
        preference.callOnChange$powerfulsharedpreferences_release(value);
        String string4 = preference.getKey();
        if (preference instanceof EnumPreference) {
            T t = value;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            string2 = ((Enum)t).name();
        } else {
            string2 = preference.toPreferences(value);
        }
        Logger.INSTANCE.logPut(string4, string2, preference.getPrefClass());
        String string5 = preference.getKey();
        if (preference instanceof EnumPreference) {
            T t = value;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            string = ((Enum)t).name();
        } else {
            string = preference.toPreferences(value);
        }
        this.encryptAndPut(string5, string, preference.getPreferencesFileName());
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <T> void remove(@NotNull PowerfulPreference<T> preference) {
        block8: {
            Intrinsics.checkParameterIsNotNull(preference, (String)"preference");
            if (mCacheEnabled) {
                cacheMap.remove(preference.getCacheMapKey$powerfulsharedpreferences_release());
            }
            Iterable $receiver$iv = prefChangedCallbacks;
            for (Object element$iv : $receiver$iv) {
                Function2 it = (Function2)element$iv;
                T t = preference.getDefaultValue();
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
                }
                it.invoke((Object)preference.getKey(), t);
            }
            preference.callOnChange$powerfulsharedpreferences_release(preference.getDefaultValue());
            SharedPreferences.Editor editor = this.findPref(preference.getPreferencesFileName()).edit();
            if (this.findCrypter(preference.getPreferencesFileName()) == null) {
                SharedPreferences.Editor editor2 = editor;
                if (editor2 != null) {
                    editor2.remove(preference.getKey());
                }
            }
            SharedPreferences.Editor editor3 = editor;
            if (editor3 != null) {
                String string;
                String string2 = preference.getKey();
                SharedPreferences.Editor editor4 = editor3;
                try {
                    Crypter crypter = INSTANCE.findCrypter(preference.getPreferencesFileName());
                    string = crypter != null ? crypter.encrypt(preference.getKey()) : null;
                }
                catch (Exception e$iv) {
                    void default$iv;
                    string = default$iv;
                }
                void var9_8 = string;
                editor4.remove((String)var9_8);
            }
            SharedPreferences.Editor editor5 = editor;
            if (editor5 == null) break block8;
            editor5.apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <T> boolean contains(@NotNull PowerfulPreference<T> preference) {
        String string;
        Intrinsics.checkParameterIsNotNull(preference, (String)"preference");
        SharedPreferences sharedPreferences = this.findPref(preference.getPreferencesFileName());
        if (this.findCrypter(preference.getPreferencesFileName()) == null) {
            boolean found = sharedPreferences.contains(preference.getKey());
            Logger.INSTANCE.logContains(preference.getKey(), found);
            return found;
        }
        String string2 = preference.getKey();
        SharedPreferences sharedPreferences2 = sharedPreferences;
        try {
            Crypter crypter = INSTANCE.findCrypter(preference.getPreferencesFileName());
            string = crypter != null ? crypter.encrypt(preference.getKey()) : null;
        }
        catch (Exception e$iv) {
            void default$iv;
            string = default$iv;
        }
        void var9_9 = string;
        boolean found = sharedPreferences2.contains((String)var9_9);
        Logger.INSTANCE.logContains(preference.getKey(), found);
        return found;
    }

    @NotNull
    public final synchronized SharedPreferences.Editor clear() {
        return this.clear(null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized SharedPreferences.Editor clear(@Nullable String preferencesFileName) {
        HashSet keySet = new HashSet();
        if (mCacheEnabled) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Set<String> set = cacheMap.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"cacheMap.keys");
            Iterable iterable = set;
            HashSet hashSet = keySet;
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it;
                String string = it = (String)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = preferencesFileName;
                if (string2 == null && (string2 = mDefaultName) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultName");
                }
                if (!StringsKt.startsWith$default((String)string, (String)stringBuilder.append(string2).append('$').toString(), (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            hashSet.addAll(list);
            $receiver$iv = keySet;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                cacheMap.remove(it);
            }
        }
        Logger.INSTANCE.logClear();
        SharedPreferences.Editor editor = this.findPref(preferencesFileName).edit().clear();
        editor.apply();
        SharedPreferences.Editor editor2 = editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        return editor2;
    }

    @NotNull
    public final Map<String, ?> getAll() {
        return this.getAll(null);
    }

    @NotNull
    public final Map<String, ?> getAll(@Nullable String preferencesFileName) {
        Logger.INSTANCE.logGetAll();
        Map map = this.findPref(preferencesFileName).getAll();
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private final String getAndDecrypt(String key, String preferencesFileName) {
        SharedPreferences sharedPreferences = this.findPref(preferencesFileName);
        Crypter crypter = this.findCrypter(preferencesFileName);
        if (crypter == null) {
            String string = sharedPreferences.getString(key, "");
            if (string == null) {
                string = "";
            }
            return string;
        }
        Crypter crypter2 = crypter;
        try {
            String encryptedKey = crypter2.encrypt(key);
            String string = sharedPreferences.getString(encryptedKey, "");
            if (string == null) {
                return "";
            }
            String encryptedValue = string;
            CharSequence charSequence = encryptedValue;
            if (charSequence.length() == 0) {
                return "";
            }
            String value = StringsKt.replace$default((String)crypter2.decrypt(encryptedValue), (String)encryptedKey, (String)"", (boolean)false, (int)4, null);
            Logger.INSTANCE.logDecrypt(key, encryptedKey, encryptedValue, value);
            return value;
        }
        catch (Exception e) {
            Logger.INSTANCE.logDecryptException(e, key);
            String string = sharedPreferences.getString(key, "");
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    private final void encryptAndPut(String key, String value, String preferencesFileName) {
        SharedPreferences sharedPreferences = this.findPref(preferencesFileName);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Crypter crypter = this.findCrypter(preferencesFileName);
        if (crypter == null) {
            String string = value;
            String string2 = key;
            SharedPreferences.Editor editor2 = editor;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            editor2.putString(string2, string4).apply();
            return;
        }
        Crypter crypter2 = crypter;
        try {
            String encryptedKey = crypter2.encrypt(key);
            String string = value;
            CharSequence charSequence = new StringBuilder();
            Object object = crypter2;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            String encryptedValue = object.encrypt(charSequence.append(string6).append(encryptedKey).toString());
            string = value;
            String string7 = encryptedValue;
            string6 = encryptedKey;
            charSequence = key;
            object = Logger.INSTANCE;
            String string8 = string;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string9 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
            ((Logger)object).logEncrypt((String)charSequence, string6, string7, string9);
            editor.putString(encryptedKey, encryptedValue).apply();
        }
        catch (Exception e) {
            Logger.INSTANCE.logEncryptException(e, key, value);
        }
    }

    private final SharedPreferences findPref(String name) {
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            SharedPreferences sharedPreferences = mDefaultPrefs;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultPrefs");
            }
            return sharedPreferences;
        }
        PrefContainer prefContainer = prefMap.get(name);
        if ((prefContainer == null || (prefContainer = prefContainer.getSharedPreferences()) == null) && (prefContainer = mDefaultPrefs) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultPrefs");
        }
        return prefContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Crypter findCrypter(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return mCrypter;
        }
        Map map = prefMap;
        PrefContainer prefContainer = (PrefContainer)map.get(name);
        if (prefContainer == null) return null;
        if (!prefContainer.getUseCrypter()) return null;
        Crypter crypter = mCrypter;
        return crypter;
    }

    private Prefs() {
    }

    static {
        Prefs prefs;
        INSTANCE = prefs = new Prefs();
        prefMap = new HashMap();
        cacheMap = new HashMap();
        prefChangedCallbacks = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getPrefMap$p(Prefs $this) {
        Prefs prefs = $this;
        return prefMap;
    }

    @NotNull
    public static final /* synthetic */ SharedPreferences access$getMDefaultPrefs$p(Prefs $this) {
        Prefs prefs = $this;
        SharedPreferences sharedPreferences = mDefaultPrefs;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultPrefs");
        }
        return sharedPreferences;
    }

    public static final /* synthetic */ void access$setMDefaultPrefs$p(Prefs $this, @NotNull SharedPreferences sharedPreferences) {
        Prefs prefs = $this;
        mDefaultPrefs = sharedPreferences;
    }

    @NotNull
    public static final /* synthetic */ String access$getMDefaultName$p(Prefs $this) {
        Prefs prefs = $this;
        String string = mDefaultName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDefaultName");
        }
        return string;
    }

    public static final /* synthetic */ void access$setMDefaultName$p(Prefs $this, @NotNull String string) {
        Prefs prefs = $this;
        mDefaultName = string;
    }

    public static final /* synthetic */ boolean access$getMCacheEnabled$p(Prefs $this) {
        Prefs prefs = $this;
        return mCacheEnabled;
    }

    public static final /* synthetic */ void access$setMCacheEnabled$p(Prefs $this, boolean bl) {
        Prefs prefs = $this;
        mCacheEnabled = bl;
    }

    @Nullable
    public static final /* synthetic */ Crypter access$getMCrypter$p(Prefs $this) {
        Prefs prefs = $this;
        return mCrypter;
    }

    public static final /* synthetic */ void access$setMCrypter$p(Prefs $this, @Nullable Crypter crypter) {
        Prefs prefs = $this;
        mCrypter = crypter;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stefanosiano/powerfullibraries/sharedpreferences/Prefs$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cacheEnabled", "", "kotlin.jvm.PlatformType", "crypter", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/Crypter;", "defaultPrefsMode", "", "defaultPrefsName", "", "logLevel", "password", "salt", "", "addPrefs", "prefsName", "mode", "useCrypter", "build", "", "disableCache", "setCrypter", "pass", "setDefaultPrefs", "setLogLevel", "Companion", "powerfulsharedpreferences_release"})
    public static final class Builder {
        private Crypter crypter;
        private final Context context;
        private String defaultPrefsName;
        private String password;
        private byte[] salt;
        private int defaultPrefsMode;
        private boolean cacheEnabled;
        private int logLevel;
        private static final int LOG_DISABLED = 0;
        private static final int LOG_ERRORS = 1;
        private static final int LOG_VALUES = 2;
        private static final int LOG_VERBOSE = 3;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder setCrypter(@NotNull Crypter crypter) {
            Intrinsics.checkParameterIsNotNull((Object)crypter, (String)"crypter");
            this.crypter = crypter;
            return this;
        }

        @NotNull
        public final Builder setCrypter(@NotNull String pass, @Nullable byte[] salt) {
            Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
            this.password = pass;
            this.salt = salt;
            return this;
        }

        @NotNull
        public final Builder setDefaultPrefs(@NotNull String prefsName, int mode) {
            Intrinsics.checkParameterIsNotNull((Object)prefsName, (String)"prefsName");
            this.defaultPrefsName = prefsName;
            this.defaultPrefsMode = mode;
            return this;
        }

        @NotNull
        public final Builder disableCache() {
            this.cacheEnabled = false;
            return this;
        }

        @NotNull
        public final Builder addPrefs(@NotNull String prefsName, int mode, boolean useCrypter) {
            Intrinsics.checkParameterIsNotNull((Object)prefsName, (String)"prefsName");
            Map map = Prefs.access$getPrefMap$p(INSTANCE);
            PrefContainer prefContainer = new PrefContainer(useCrypter, prefsName, mode);
            map.put(prefsName, prefContainer);
            return this;
        }

        @NotNull
        public final Builder setLogLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public final void build() {
            Crypter crypter;
            boolean bl;
            Context context = this.context;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(this.defaultPrefsName, this.defaultPrefsMode);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.applicationConte\u2026fsName, defaultPrefsMode)");
            Prefs.access$setMDefaultPrefs$p(INSTANCE, sharedPreferences);
            String string = this.defaultPrefsName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"defaultPrefsName");
            Prefs.access$setMDefaultName$p(INSTANCE, string);
            Prefs.access$setMCacheEnabled$p(INSTANCE, this.cacheEnabled);
            CharSequence charSequence = this.password;
            Prefs prefs = INSTANCE;
            boolean bl2 = bl = charSequence == null || charSequence.length() == 0;
            if (bl) {
                crypter = this.crypter;
            } else {
                SharedPreferences sharedPreferences2 = Prefs.access$getMDefaultPrefs$p(INSTANCE);
                String string2 = this.password;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                crypter = Companion.generateDefaultCrypter$powerfulsharedpreferences_release(sharedPreferences2, string2, this.salt);
            }
            Prefs.access$setMCrypter$p(prefs, crypter);
            Prefs.access$getPrefMap$p(INSTANCE).remove(this.defaultPrefsName);
            Collection collection = Prefs.access$getPrefMap$p(INSTANCE).values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"prefMap.values");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                PrefContainer it = (PrefContainer)element$iv;
                Context context2 = this.context;
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
                it.build(context2);
            }
            Logger.INSTANCE.setLevel(this.logLevel);
            String string3 = this.defaultPrefsName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"defaultPrefsName");
            Logger.INSTANCE.logBuild(string3, Prefs.access$getMCrypter$p(INSTANCE), Prefs.access$getPrefMap$p(INSTANCE));
            this.password = "";
            this.salt = new byte[0];
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context.getApplicationContext();
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            this.defaultPrefsName = context2.getPackageName();
            this.cacheEnabled = true;
            this.logLevel = LOG_DISABLED;
        }

        static {
            LOG_ERRORS = 1;
            LOG_VALUES = 2;
            LOG_VERBOSE = 3;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/stefanosiano/powerfullibraries/sharedpreferences/Prefs$Builder$Companion;", "", "()V", "LOG_DISABLED", "", "getLOG_DISABLED", "()I", "LOG_ERRORS", "getLOG_ERRORS", "LOG_VALUES", "getLOG_VALUES", "LOG_VERBOSE", "getLOG_VERBOSE", "generateDefaultCrypter", "Lcom/stefanosiano/powerfullibraries/sharedpreferences/Crypter;", "prefs", "Landroid/content/SharedPreferences;", "pass", "", "saltPassed", "", "generateDefaultCrypter$powerfulsharedpreferences_release", "powerfulsharedpreferences_release"})
        public static final class Companion {
            public final int getLOG_DISABLED() {
                return LOG_DISABLED;
            }

            public final int getLOG_ERRORS() {
                return LOG_ERRORS;
            }

            public final int getLOG_VALUES() {
                return LOG_VALUES;
            }

            public final int getLOG_VERBOSE() {
                return LOG_VERBOSE;
            }

            @NotNull
            public final Crypter generateDefaultCrypter$powerfulsharedpreferences_release(@NotNull SharedPreferences prefs, @NotNull String pass, @Nullable byte[] saltPassed) {
                Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
                Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
                byte[] salt = saltPassed;
                if (salt == null) {
                    try {
                        byte[] byArray;
                        String string = pass;
                        String string2 = pass;
                        Object object = Charsets.UTF_8;
                        byte[] byArray2 = string.getBytes((Charset)object);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] byArray3 = byArray = byArray2;
                        String string3 = string2;
                        DefaultCrypter c = new DefaultCrypter(string3, byArray3);
                        String encryptedSalt = prefs.getString(c.encrypt("key") + "!", "");
                        object = encryptedSalt;
                        if (object == null || object.length() == 0) {
                            encryptedSalt = String.valueOf(new SecureRandom().nextLong()) + "";
                            prefs.edit().putString(c.encrypt("key") + "!", c.encrypt(encryptedSalt)).apply();
                        } else {
                            encryptedSalt = c.decrypt(encryptedSalt);
                        }
                        object = encryptedSalt;
                        Object object2 = Prefs.CHARSET_UTF8;
                        Charset charset = Charset.forName((String)object2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                        object2 = charset;
                        Object object3 = object;
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray4 = ((String)object3).getBytes((Charset)object2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
                        salt = byArray4;
                    }
                    catch (Exception e) {
                        throw (Throwable)new RuntimeException("Salt generation error");
                    }
                }
                return new DefaultCrypter(pass, salt);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

