/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.sama.utils;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.stefanosiano.powerful_libraries.sama.ExtensionsKt;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stefanosiano/powerful_libraries/sama/utils/FileUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "sel", "args", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getForApi19", "toFileFromProviders", "Ljava/io/File;", "powerfulsama_release"})
public final class FileUtils {
    public static final FileUtils INSTANCE;

    @Nullable
    public final File toFileFromProviders(@NotNull Uri $this$toFileFromProviders, @NotNull Context context) {
        File file;
        String path;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFileFromProviders, (String)"$this$toFileFromProviders");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ExtensionsKt.logDebug($this$toFileFromProviders, "File Uri: " + $this$toFileFromProviders + ", with scheme: " + $this$toFileFromProviders.getScheme());
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)$this$toFileFromProviders)) {
            string = this.getForApi19(context, $this$toFileFromProviders);
        } else if (StringsKt.equals((String)"content", (String)$this$toFileFromProviders.getScheme(), (boolean)true) && Intrinsics.areEqual((Object)$this$toFileFromProviders.getAuthority(), (Object)"com.google.android.apps.photos.content")) {
            string = $this$toFileFromProviders.getLastPathSegment();
        } else if (StringsKt.equals((String)"content", (String)$this$toFileFromProviders.getScheme(), (boolean)true)) {
            string = this.getDataColumn(context, $this$toFileFromProviders, null, null);
        } else if (StringsKt.equals((String)"file", (String)$this$toFileFromProviders.getScheme(), (boolean)true)) {
            string = $this$toFileFromProviders.getPath();
        } else {
            ExtensionsKt.logError($this$toFileFromProviders, "Uri's scheme unknown: " + $this$toFileFromProviders.getScheme());
            string = null;
        }
        String string2 = path = string;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=19)
    private final String getForApi19(Context context, Uri uri) {
        block20: {
            Uri uri2;
            String string;
            String docId;
            block21: {
                docId = DocumentsContract.getDocumentId((Uri)uri);
                ExtensionsKt.logDebug(this, "Document URI");
                String string2 = uri.getAuthority();
                if (string2 == null) break block20;
                String string3 = string2;
                switch (string3.hashCode()) {
                    case 320699453: {
                        if (!string3.equals("com.android.providers.downloads.documents")) return null;
                        break;
                    }
                    case 1734583286: {
                        if (!string3.equals("com.android.providers.media.documents")) return null;
                        break block21;
                    }
                    case 596745902: {
                        if (!string3.equals("com.android.externalstorage.documents")) return null;
                        ExtensionsKt.logDebug(this, "External Document URI");
                        String string4 = docId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"docId");
                        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string4, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] docTypePath = stringArray;
                        String type = docTypePath[0];
                        if (!StringsKt.equals((String)"primary", (String)type, (boolean)true)) return null;
                        string = Environment.getExternalStorageDirectory().toString() + "/" + docTypePath[1];
                        return string;
                    }
                }
                ExtensionsKt.logDebug(this, "Downloads External Document URI");
                Uri uri3 = Uri.parse((String)"content://downloads/public_downloads");
                String string5 = docId;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"docId");
                Long l = StringsKt.toLongOrNull((String)string5);
                Uri uri4 = ContentUris.withAppendedId((Uri)uri3, (long)(l != null ? l : -1L));
                Intrinsics.checkExpressionValueIsNotNull((Object)uri4, (String)"ContentUris.withAppended\u2026cId.toLongOrNull() ?: -1)");
                Uri contentUri = uri4;
                string = this.getDataColumn(context, contentUri, null, null);
                return string;
            }
            String string6 = docId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"docId");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string6, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] split = stringArray;
            String type = split[0];
            ExtensionsKt.logDebug(this, "Media Document URI with uri type: " + type);
            switch (type) {
                case "image": {
                    uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    break;
                }
                case "video": {
                    uri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    break;
                }
                case "audio": {
                    uri2 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    break;
                }
                default: {
                    uri2 = null;
                }
            }
            if (uri2 == null) return null;
            Uri contentUri = uri2;
            String selection = "_id=?";
            String[] selectionArgs = new String[]{split[1]};
            string = this.getDataColumn(context, contentUri, selection, selectionArgs);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getDataColumn(Context context, Uri uri, String sel, String[] args) {
        Cursor cursor = null;
        try {
            Cursor cursor2 = cursor = context.getContentResolver().query(uri, new String[]{"_data"}, sel, args, null);
            String string = cursor2 != null && cursor2.moveToFirst() ? cursor.getString(cursor.getColumnIndexOrThrow("_data")) : null;
            return string;
        }
        finally {
            Cursor cursor3 = cursor;
            if (cursor3 != null) {
                cursor3.close();
            }
        }
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

