/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.sama.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.widget.ImageViewCompat;
import androidx.databinding.BindingAdapter;
import androidx.databinding.ObservableField;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textfield.TextInputLayout;
import com.stefanosiano.powerful_libraries.sama.ui.SamaSearchView;
import com.stefanosiano.powerful_libraries.sama.ui.SamaSpinner;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\nH\u0007\u001a \u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\u0018\u00010\nH\u0007\u001a'\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u000e\u0018\u00010\nH\u0007\u001a'\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u0012\u001a&\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000b\u0018\u00010\nH\u0007\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bH\u0007\u001a \u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\nH\u0007\u001a\u001e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0005H\u0007\u001a\u001a\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0007\u001a\u001f\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%H\u0007\u00a2\u0006\u0002\u0010&\u001a\u0018\u0010'\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020%H\u0007\u001a\u0018\u0010)\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0005H\u0007\u001a\u0018\u0010+\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020%H\u0007\u001a'\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00112\b\u00101\u001a\u0004\u0018\u000102H\u0007\u00a2\u0006\u0002\u00103\u001a\u0018\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0007\u001a\u0018\u00108\u001a\u00020\u00012\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020%H\u0007\u001a\u0018\u00108\u001a\u00020\u00012\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0011H\u0007\u001a\u0018\u0010<\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u0005H\u0007\u001a\u0018\u0010>\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010?\u001a\u00020%H\u0007\u001a\u0018\u0010@\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010A\u001a\u00020%H\u0007\u001a\u0018\u0010@\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u0011H\u0007\u00a8\u0006B"}, d2={"bindRecyclerViewItems", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "hasFixedSize", "", "bindSpinnerItems", "spinner", "Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSpinner;", "value", "Landroidx/databinding/ObservableField;", "", "Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSpinner$SamaSpinnerItem;", "bindSpinnerItemsArray", "", "(Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSpinner;[Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSpinner$SamaSpinnerItem;)V", "bindSpinnerItemsArrayString", "", "(Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSpinner;[Ljava/lang/String;)V", "bindSpinnerItemsString", "bindSpinnerKey", "key", "bindSpinnerValue", "setDisabled", "view", "Landroid/view/View;", "disable", "setEnabled", "enable", "setHidden", "hidden", "setImageViewSource", "imageView", "Landroid/widget/ImageView;", "drawable", "Landroid/graphics/drawable/Drawable;", "id", "", "(Landroid/widget/ImageView;Ljava/lang/Integer;)V", "setImageViewTint", "color", "setInvisibility", "invisible", "setLayoutManager", "columns", "setQuery", "searchView", "Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSearchView;", "query", "millis", "", "(Lcom/stefanosiano/powerful_libraries/sama/ui/SamaSearchView;Ljava/lang/String;Ljava/lang/Long;)V", "setShapeBackgroundColor", "textView", "Landroid/widget/TextView;", "strikethrough", "setTextInputLayoutError", "textInputLayoutError", "Lcom/google/android/material/textfield/TextInputLayout;", "error", "setVisibility", "visible", "setVisibleOnOrientation", "orientation", "showTooltip", "tooltip", "powerfulsama_release"})
public final class SamaDataBindingUtilsKt {
    @BindingAdapter(value={"app:src"})
    public static final void setImageViewSource(@NotNull ImageView imageView, @Nullable Drawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        imageView.post(new Runnable(imageView, drawable){
            final /* synthetic */ ImageView $imageView;
            final /* synthetic */ Drawable $drawable;

            public final void run() {
                this.$imageView.setImageDrawable(this.$drawable);
            }
            {
                this.$imageView = imageView;
                this.$drawable = drawable;
            }
        });
    }

    @BindingAdapter(value={"app:src"})
    public static final void setImageViewSource(@NotNull ImageView imageView, @Nullable Integer id) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        imageView.post(new Runnable(imageView, id){
            final /* synthetic */ ImageView $imageView;
            final /* synthetic */ Integer $id;

            public final void run() {
                Integer n = this.$id;
                this.$imageView.setImageResource(n != null ? n : 0);
            }
            {
                this.$imageView = imageView;
                this.$id = n;
            }
        });
    }

    @BindingAdapter(value={"app:visible"})
    public static final void setVisibility(@NotNull View view, boolean visible) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setVisibility(visible ? 0 : 8);
    }

    @BindingAdapter(value={"app:invisible"})
    public static final void setInvisibility(@NotNull View view, boolean invisible) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setVisibility(invisible ? 4 : 0);
    }

    @BindingAdapter(value={"app:hidden"})
    public static final void setHidden(@NotNull View view, boolean hidden) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setVisibility(hidden ? 8 : 0);
    }

    @BindingAdapter(value={"app:visibleOnOrientation"})
    public static final void setVisibleOnOrientation(@NotNull View view, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"view.context.resources");
        view.setVisibility(resources.getConfiguration().orientation == orientation ? 0 : 8);
    }

    @BindingAdapter(value={"app:disabled"})
    public static final void setDisabled(@NotNull View view, boolean disable) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setEnabled(!disable);
    }

    @BindingAdapter(value={"app:enabled"})
    public static final void setEnabled(@NotNull View view, boolean enable) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setEnabled(enable);
    }

    @BindingAdapter(value={"app:tooltip"})
    public static final void showTooltip(@NotNull View view, @NotNull String tooltip) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)tooltip, (String)"tooltip");
        view.setOnLongClickListener(new View.OnLongClickListener(view, tooltip){
            final /* synthetic */ View $view;
            final /* synthetic */ String $tooltip;

            public final boolean onLongClick(View it) {
                Toast.makeText((Context)this.$view.getContext(), (CharSequence)this.$tooltip, (int)0).show();
                return true;
            }
            {
                this.$view = view;
                this.$tooltip = string;
            }
        });
    }

    @BindingAdapter(value={"app:tooltip"})
    public static final void showTooltip(@NotNull View view, int tooltip) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.setOnLongClickListener(new View.OnLongClickListener(view, tooltip){
            final /* synthetic */ View $view;
            final /* synthetic */ int $tooltip;

            public final boolean onLongClick(View it) {
                Toast.makeText((Context)this.$view.getContext(), (int)this.$tooltip, (int)0).show();
                return true;
            }
            {
                this.$view = view;
                this.$tooltip = n;
            }
        });
    }

    @BindingAdapter(value={"app:dbuImgTint"})
    public static final void setImageViewTint(@NotNull ImageView imageView, int color) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        ImageViewCompat.setImageTintList((ImageView)imageView, (ColorStateList)ColorStateList.valueOf((int)color));
    }

    @BindingAdapter(value={"app:columns"})
    public static final void setLayoutManager(@NotNull RecyclerView recyclerView, int columns) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        recyclerView.setLayoutManager(columns <= 1 ? (RecyclerView.LayoutManager)new LinearLayoutManager(recyclerView.getContext()) : (RecyclerView.LayoutManager)new GridLayoutManager(recyclerView.getContext(), columns));
    }

    @BindingAdapter(value={"app:fixedSize"})
    public static final void bindRecyclerViewItems(@NotNull RecyclerView recyclerView, boolean hasFixedSize) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        recyclerView.setHasFixedSize(hasFixedSize);
    }

    @BindingAdapter(value={"app:strikethrough"})
    public static final void setShapeBackgroundColor(@NotNull TextView textView, boolean strikethrough) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        textView.setPaintFlags(strikethrough ? textView.getPaintFlags() | 0x10 : textView.getPaintFlags() & ~16);
    }

    @BindingAdapter(requireAll=false, value={"app:query", "app:searchMillis"})
    public static final void setQuery(@NotNull SamaSearchView searchView, @NotNull String query, @Nullable Long millis) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)searchView), (String)"searchView");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Long l = millis;
        searchView.setMillis(l != null ? l : 0L);
        searchView.setQuery(query, false);
    }

    @BindingAdapter(value={"app:dbuTilError"})
    public static final void setTextInputLayoutError(@NotNull TextInputLayout textInputLayoutError, int error) {
        String stringError;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)textInputLayoutError, (String)"textInputLayoutError");
        try {
            string = textInputLayoutError.getContext().getString(error);
        }
        catch (Exception e) {
            string = "";
        }
        String string2 = stringError = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stringError");
        SamaDataBindingUtilsKt.setTextInputLayoutError(textInputLayoutError, string2);
    }

    @BindingAdapter(value={"app:dbuTilError"})
    public static final void setTextInputLayoutError(@NotNull TextInputLayout textInputLayoutError, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)textInputLayoutError, (String)"textInputLayoutError");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        textInputLayoutError.setError((CharSequence)error);
        textInputLayoutError.setErrorEnabled(!TextUtils.isEmpty((CharSequence)error));
    }

    @BindingAdapter(value={"app:bindKey"})
    public static final void bindSpinnerKey(@NotNull SamaSpinner spinner, @Nullable ObservableField<String> key) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        spinner.bindKey(key);
    }

    @BindingAdapter(value={"app:bindValue"})
    public static final void bindSpinnerValue(@NotNull SamaSpinner spinner, @NotNull ObservableField<String> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        spinner.bindValue(value);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsString(@NotNull SamaSpinner spinner, @Nullable ObservableField<Collection<String>> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        spinner.bindItems(value);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsArrayString(@NotNull SamaSpinner spinner, @Nullable ObservableField<String[]> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        spinner.bindItemsArray(value);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItems(@NotNull SamaSpinner spinner, @Nullable ObservableField<Collection<SamaSpinner.SamaSpinnerItem>> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        SamaSpinner.bindItems$default(spinner, value, false, 2, null);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsArray(@NotNull SamaSpinner spinner, @Nullable ObservableField<SamaSpinner.SamaSpinnerItem[]> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        SamaSpinner.bindItemsArray$default(spinner, value, false, 2, null);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsString(@NotNull SamaSpinner spinner, @Nullable Collection<String> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        spinner.setItems(value);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsArrayString(@NotNull SamaSpinner spinner, @Nullable String[] value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        spinner.setItems(value);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItems(@NotNull SamaSpinner spinner, @Nullable Collection<? extends SamaSpinner.SamaSpinnerItem> value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        SamaSpinner.setItems$default(spinner, value, false, 2, null);
    }

    @BindingAdapter(value={"app:items"})
    public static final void bindSpinnerItemsArray(@NotNull SamaSpinner spinner, @Nullable SamaSpinner.SamaSpinnerItem[] value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)spinner), (String)"spinner");
        SamaSpinner.setItems$default(spinner, value, false, 2, null);
    }
}

