/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.progress.drawers;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/HorizontalIndeterminateProgressDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawer;", "()V", "isShrinking", "", "listener", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager$ProgressDrawerListener;", "mEndX", "", "mIsProgressReversed", "mLeft", "mProgressAnimationDuration", "", "mProgressAnimator", "Landroid/animation/ValueAnimator;", "mProgressPaint", "Landroid/graphics/Paint;", "mRight", "mStartX", "draw", "", "canvas", "Landroid/graphics/Canvas;", "progressBounds", "Landroid/graphics/RectF;", "setAnimationDuration", "millis", "setAnimationEnabled", "enabled", "setListener", "setProgressPercent", "progressPercent", "setProgressValues", "currentX", "setup", "progressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "startIndeterminateAnimation", "stopIndeterminateAnimation", "powerfulimageview_rs_release"})
public final class HorizontalIndeterminateProgressDrawer
implements ProgressDrawer {
    private float mLeft;
    private float mRight;
    private Paint mProgressPaint = new Paint();
    private ValueAnimator mProgressAnimator;
    private float mStartX;
    private float mEndX;
    private boolean isShrinking;
    private boolean mIsProgressReversed;
    private long mProgressAnimationDuration;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    @Override
    public void setProgressPercent(float progressPercent) {
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
    }

    @Override
    public void setup(@NotNull ProgressOptions progressOptions) {
        Intrinsics.checkParameterIsNotNull((Object)progressOptions, (String)"progressOptions");
        this.mProgressPaint.setColor(progressOptions.getIndeterminateColor());
        this.mProgressPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getRect().left;
        this.mRight = progressOptions.getRect().right;
        this.setProgressValues(this.isShrinking ? this.mStartX : this.mEndX);
        this.mIsProgressReversed = progressOptions.isProgressReversed();
        long l = this.mProgressAnimationDuration = (long)progressOptions.getAnimationDuration() < 0L ? 1000L : (long)progressOptions.getAnimationDuration();
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    private final void setProgressValues(float currentX) {
        block2: {
            if (this.isShrinking) {
                this.mStartX = currentX;
                this.mEndX = this.mRight;
            } else {
                this.mStartX = this.mLeft;
                this.mEndX = currentX;
            }
            ProgressDrawerManager.ProgressDrawerListener progressDrawerListener = this.listener;
            if (progressDrawerListener == null) break block2;
            progressDrawerListener.onRequestInvalidate();
        }
    }

    @Override
    public void startIndeterminateAnimation() {
        this.mProgressAnimator.cancel();
        this.isShrinking = false;
        this.setProgressValues(this.mLeft);
        this.mProgressAnimator.start();
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF progressBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)progressBounds, (String)"progressBounds");
        if (!this.mIsProgressReversed) {
            canvas.drawRect(this.mStartX, progressBounds.top, this.mEndX, progressBounds.bottom, this.mProgressPaint);
        } else {
            canvas.drawRect(progressBounds.right - this.mEndX, progressBounds.top, progressBounds.right + progressBounds.left - this.mStartX, progressBounds.bottom, this.mProgressPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
        this.mProgressAnimator.cancel();
    }

    @Override
    public void setAnimationDuration(long millis) {
        long l = this.mProgressAnimationDuration = millis < 0L ? 1000L : millis;
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    @Override
    public void setListener(@NotNull ProgressDrawerManager.ProgressDrawerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public HorizontalIndeterminateProgressDrawer() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0f, 1f)");
        this.mProgressAnimator = valueAnimator;
        this.mProgressAnimationDuration = -1L;
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 1000L : this.mProgressAnimationDuration);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mProgressAnimator.setRepeatCount(-1);
        this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                isShrinking = !isShrinking;
            }
        });
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator it) {
                float f = mLeft;
                float f2 = mRight - mLeft;
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                this.setProgressValues(f + f2 * valueAnimator.getAnimatedFraction());
            }
        });
    }

    public static final /* synthetic */ void access$setMLeft$p(HorizontalIndeterminateProgressDrawer $this, float f) {
        $this.mLeft = f;
    }

    public static final /* synthetic */ void access$setMRight$p(HorizontalIndeterminateProgressDrawer $this, float f) {
        $this.mRight = f;
    }
}

