/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.progress.drawers;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/CircularIndeterminateProgressDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawer;", "()V", "isShrinking", "", "listener", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager$ProgressDrawerListener;", "mIsProgressReversed", "mLastStartAngleOffset", "", "mLastSweepAngleOffset", "mOffset", "mOffsetAnimator", "Landroid/animation/ValueAnimator;", "mProgressAnimationDuration", "", "mProgressAnimator", "mProgressPaint", "Landroid/graphics/Paint;", "mProgressStartAngle", "mProgressSweepAngle", "draw", "", "canvas", "Landroid/graphics/Canvas;", "progressBounds", "Landroid/graphics/RectF;", "setAnimationDuration", "millis", "setAnimationEnabled", "enabled", "setListener", "setProgressAngle", "startAngleOffset", "sweepAngleOffset", "setProgressPercent", "progressPercent", "", "setup", "progressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "startIndeterminateAnimation", "stopIndeterminateAnimation", "powerfulimageview_rs_release"})
public final class CircularIndeterminateProgressDrawer
implements ProgressDrawer {
    private Paint mProgressPaint = new Paint();
    private ValueAnimator mOffsetAnimator;
    private ValueAnimator mProgressAnimator;
    private int mProgressStartAngle;
    private int mProgressSweepAngle;
    private boolean isShrinking;
    private long mProgressAnimationDuration;
    private int mOffset;
    private int mLastStartAngleOffset;
    private int mLastSweepAngleOffset;
    private boolean mIsProgressReversed;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    @Override
    public void setup(@NotNull ProgressOptions progressOptions) {
        Intrinsics.checkParameterIsNotNull((Object)progressOptions, (String)"progressOptions");
        this.mProgressPaint.setColor(progressOptions.getIndeterminateColor());
        this.mProgressPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        long l = this.mProgressAnimationDuration = (long)progressOptions.getAnimationDuration() < 0L ? 800L : (long)progressOptions.getAnimationDuration();
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
        this.mIsProgressReversed = progressOptions.isProgressReversed();
        this.setProgressAngle(this.mLastStartAngleOffset, this.mLastSweepAngleOffset);
    }

    @Override
    public void startIndeterminateAnimation() {
        this.mOffsetAnimator.cancel();
        this.mProgressAnimator.cancel();
        this.mOffset = 0;
        this.isShrinking = false;
        this.mLastStartAngleOffset = 0;
        this.mLastSweepAngleOffset = 0;
        this.setProgressAngle(this.mLastStartAngleOffset, this.mLastSweepAngleOffset);
        this.mProgressAnimator.start();
        this.mOffsetAnimator.start();
    }

    private final void setProgressAngle(int startAngleOffset, int sweepAngleOffset) {
        block2: {
            this.mLastStartAngleOffset = startAngleOffset;
            this.mLastSweepAngleOffset = sweepAngleOffset;
            if (this.isShrinking) {
                this.mProgressStartAngle = -90 + startAngleOffset + this.mOffset;
                this.mProgressSweepAngle = 340 - sweepAngleOffset;
            } else {
                this.mProgressStartAngle = -90 + this.mOffset;
                this.mProgressSweepAngle = sweepAngleOffset + 50;
            }
            ProgressDrawerManager.ProgressDrawerListener progressDrawerListener = this.listener;
            if (progressDrawerListener == null) break block2;
            progressDrawerListener.onRequestInvalidate();
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF progressBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)progressBounds, (String)"progressBounds");
        if (!this.mIsProgressReversed) {
            canvas.drawArc(progressBounds, (float)this.mProgressStartAngle, (float)this.mProgressSweepAngle, false, this.mProgressPaint);
        } else {
            canvas.drawArc(progressBounds, (float)(-this.mProgressStartAngle), (float)(-this.mProgressSweepAngle), false, this.mProgressPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
        this.mOffsetAnimator.cancel();
        this.mProgressAnimator.cancel();
    }

    @Override
    public void setProgressPercent(float progressPercent) {
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
    }

    @Override
    public void setAnimationDuration(long millis) {
        long l = this.mProgressAnimationDuration = millis < 0L ? 800L : millis;
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    @Override
    public void setListener(@NotNull ProgressDrawerManager.ProgressDrawerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public CircularIndeterminateProgressDrawer() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0f, 1f)");
        this.mOffsetAnimator = valueAnimator;
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"ValueAnimator.ofFloat(0f, 1f)");
        this.mProgressAnimator = valueAnimator2;
        this.mProgressAnimationDuration = -1L;
        this.mProgressStartAngle = -90;
        this.mProgressSweepAngle = 180;
        this.mLastStartAngleOffset = 0;
        this.mLastSweepAngleOffset = 0;
        this.mOffsetAnimator.setDuration(3000L);
        this.mOffsetAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mOffsetAnimator.setRepeatCount(-1);
        this.mOffsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator it) {
                float f = 360;
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                mOffset = (int)(f * valueAnimator.getAnimatedFraction());
            }
        });
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 800L : this.mProgressAnimationDuration);
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mProgressAnimator.setRepeatCount(-1);
        this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                isShrinking = !isShrinking;
            }
        });
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator it) {
                float f = 360;
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                this.setProgressAngle((int)(f * valueAnimator.getAnimatedFraction()), (int)((float)290 * it.getAnimatedFraction()));
            }
        });
    }

    public static final /* synthetic */ int access$getMOffset$p(CircularIndeterminateProgressDrawer $this) {
        return $this.mOffset;
    }
}

