/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.blur.algorithms;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.RenderScript;
import com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.RenderscriptException;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H&J\u0012\u0010\u0010\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0005H\u0016R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BaseConvolveRenderscriptBlurAlgorithm;", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurAlgorithm;", "()V", "renderscript", "Ljava/lang/ref/WeakReference;", "Landroidx/renderscript/RenderScript;", "blur", "Landroid/graphics/Bitmap;", "original", "radius", "", "options", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;", "runScript", "Landroidx/renderscript/Allocation;", "rs", "setRenderscript", "powerfulimageview_rs_release"})
public abstract class BaseConvolveRenderscriptBlurAlgorithm
implements BlurAlgorithm {
    private WeakReference<RenderScript> renderscript;

    @NotNull
    public abstract Allocation runScript(int var1, @NotNull RenderScript var2, @NotNull Bitmap var3);

    @Override
    @NotNull
    public BlurAlgorithm setRenderscript(@Nullable RenderScript renderscript) {
        this.renderscript = new WeakReference<RenderScript>(renderscript);
        return this;
    }

    @Override
    @NotNull
    public Bitmap blur(@NotNull Bitmap original, int radius, @NotNull BlurOptions options) throws RenderscriptException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        RenderScript renderScript = this.renderscript;
        if (renderScript == null || (renderScript = (RenderScript)renderScript.get()) == null) {
            throw (Throwable)new RenderscriptException("Renderscript is null!");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)renderScript, (String)"renderscript?.get() ?: t\u2026(\"Renderscript is null!\")");
        RenderScript rs = renderScript;
        Allocation output = null;
        try {
            output = this.runScript(radius, rs, original);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (Throwable)new RenderscriptException("Renderscript error while blurring! \n" + e.getLocalizedMessage());
        }
        if (!options.isStaticBlur()) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            output.copyTo(bitmap2);
            output.destroy();
            Bitmap bitmap3 = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
            return bitmap3;
        }
        if (original.isMutable()) {
            output.copyTo(original);
            output.destroy();
            bitmap = original;
        } else {
            Bitmap bitmap4 = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            original.recycle();
            output.copyTo(bitmap4);
            output.destroy();
            Bitmap bitmap5 = bitmap4;
            bitmap = bitmap5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"bitmap");
        }
        return bitmap;
    }
}

