/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeScaleType;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.ShapeDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J0\u0010 \u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0006H$J \u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0006H$J(\u0010$\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH$J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0011H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/BaseNormalShapeDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/ShapeDrawer;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "mBackPaint", "Landroid/graphics/Paint;", "getMBackPaint", "()Landroid/graphics/Paint;", "mBackgroundDrawable", "mBorderPaint", "getMBorderPaint", "mDrawable", "mForegroundDrawable", "mFrontPaint", "getMFrontPaint", "mMatrix", "Landroid/graphics/Matrix;", "mScaleType", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeScaleType;", "changeBitmap", "", "bitmap", "Landroid/graphics/Bitmap;", "changeDrawable", "draw", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "Landroid/graphics/RectF;", "shapeBounds", "imageBounds", "drawBorder", "borderPaint", "drawPaint", "paint", "drawSolid", "requireBitmap", "", "setMatrix", "scaleType", "matrix", "setup", "shapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "powerfulimageview_rs_release"})
public abstract class BaseNormalShapeDrawer
implements ShapeDrawer {
    @NotNull
    private final Paint mBackPaint = new Paint();
    @NotNull
    private final Paint mFrontPaint = new Paint();
    @NotNull
    private final Paint mBorderPaint = new Paint();
    private Matrix mMatrix = new Matrix();
    private Drawable mDrawable;
    private Drawable mBackgroundDrawable;
    private Drawable mForegroundDrawable;
    private PivShapeScaleType mScaleType;

    @NotNull
    protected final Paint getMBackPaint() {
        return this.mBackPaint;
    }

    @NotNull
    protected final Paint getMFrontPaint() {
        return this.mFrontPaint;
    }

    @NotNull
    protected final Paint getMBorderPaint() {
        return this.mBorderPaint;
    }

    @Override
    public void changeDrawable(@Nullable Drawable drawable) {
        this.mDrawable = drawable;
    }

    @Override
    public boolean requireBitmap() {
        return false;
    }

    @Override
    public void changeBitmap(@Nullable Bitmap bitmap) {
    }

    @Override
    public void setMatrix(@NotNull PivShapeScaleType scaleType, @NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)scaleType), (String)"scaleType");
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        this.mScaleType = scaleType;
        this.mMatrix = matrix;
    }

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        this.mBackPaint.setColor(shapeOptions.getBackgroundColor());
        this.mFrontPaint.setColor(shapeOptions.getForegroundColor());
        this.mForegroundDrawable = shapeOptions.getForegroundDrawable();
        this.mBackgroundDrawable = shapeOptions.getBackgroundDrawable();
        this.mBorderPaint.setColor(shapeOptions.getBorderColor());
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)shapeOptions.getBorderWidth());
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        if (this.mBackPaint.getColor() != 0) {
            this.drawPaint(canvas, shapeBounds, this.mBackPaint);
        }
        if (this.mDrawable != null) {
            int saveCount = canvas.getSaveCount();
            if (this.mScaleType == PivShapeScaleType.FIT_XY) {
                Drawable drawable = this.mDrawable;
                if (drawable != null) {
                    drawable.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
                }
            } else {
                canvas.save();
                canvas.concat(this.mMatrix);
            }
            Drawable drawable = this.mBackgroundDrawable;
            if (drawable != null) {
                Drawable drawable2 = this.mDrawable;
                if (drawable2 == null || (drawable2 = drawable2.getBounds()) == null) {
                    drawable2 = new Rect();
                }
                drawable.setBounds((Rect)drawable2);
            }
            Drawable drawable3 = this.mBackgroundDrawable;
            if (drawable3 != null) {
                drawable3.draw(canvas);
            }
            Drawable drawable4 = this.mDrawable;
            if (drawable4 != null) {
                drawable4.draw(canvas);
            }
            Drawable drawable5 = this.mForegroundDrawable;
            if (drawable5 != null) {
                Drawable drawable6 = this.mDrawable;
                if (drawable6 == null || (drawable6 = drawable6.getBounds()) == null) {
                    drawable6 = new Rect();
                }
                drawable5.setBounds((Rect)drawable6);
            }
            Drawable drawable7 = this.mForegroundDrawable;
            if (drawable7 != null) {
                drawable7.draw(canvas);
            }
            if (this.mScaleType == null || this.mScaleType != PivShapeScaleType.FIT_XY) {
                canvas.restoreToCount(saveCount);
            }
        }
        if (this.mFrontPaint.getColor() != 0) {
            this.drawPaint(canvas, shapeBounds, this.mFrontPaint);
        }
        if (this.mBorderPaint.getStrokeWidth() > 0.0f && this.mBorderPaint.getColor() != 0) {
            this.drawBorder(canvas, borderBounds, shapeBounds, imageBounds, this.mBorderPaint);
        }
        this.drawSolid(canvas, borderBounds, shapeBounds, imageBounds);
    }

    protected abstract void drawPaint(@NotNull Canvas var1, @NotNull RectF var2, @NotNull Paint var3);

    protected abstract void drawBorder(@NotNull Canvas var1, @NotNull RectF var2, @NotNull RectF var3, @NotNull RectF var4, @NotNull Paint var5);

    protected abstract void drawSolid(@NotNull Canvas var1, @NotNull RectF var2, @NotNull RectF var3, @NotNull RectF var4);

    public BaseNormalShapeDrawer(@Nullable Drawable drawable) {
        this.mDrawable = drawable;
    }
}

