/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.progress.drawers;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/CircularProgressDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawer;", "()V", "drawWedge", "", "listener", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager$ProgressDrawerListener;", "mCurrentProgressFrontSweepAngle", "", "mIsProgressReversed", "mOldProgressFrontSweepAngle", "mProgressAnimationDuration", "", "mProgressAnimator", "Landroid/animation/ValueAnimator;", "mProgressBackPaint", "Landroid/graphics/Paint;", "mProgressBackStartAngle", "mProgressBackSweepAngle", "mProgressFrontPaint", "mProgressFrontSweepAngle", "mUseProgressAnimation", "draw", "", "canvas", "Landroid/graphics/Canvas;", "progressBounds", "Landroid/graphics/RectF;", "getOldSweepAngle", "getSweepAngle", "setAnimationDuration", "millis", "setAnimationEnabled", "enabled", "setListener", "setProgressPercent", "progressPercent", "", "setRealProgressAngle", "progressAngle", "setup", "progressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "startIndeterminateAnimation", "stopIndeterminateAnimation", "powerfulimageview_rs_release"})
public final class CircularProgressDrawer
implements ProgressDrawer {
    private Paint mProgressFrontPaint = new Paint();
    private Paint mProgressBackPaint = new Paint();
    private ValueAnimator mProgressAnimator;
    private long mProgressAnimationDuration;
    private int mProgressBackStartAngle;
    private int mProgressBackSweepAngle;
    private int mProgressFrontSweepAngle;
    private int mCurrentProgressFrontSweepAngle;
    private int mOldProgressFrontSweepAngle;
    private boolean mUseProgressAnimation;
    private boolean drawWedge;
    private boolean mIsProgressReversed;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    private final void setRealProgressAngle(int progressAngle) {
        block0: {
            this.mProgressBackStartAngle = progressAngle - 90;
            this.mProgressBackSweepAngle = 360 - progressAngle;
            this.mCurrentProgressFrontSweepAngle = progressAngle;
            ProgressDrawerManager.ProgressDrawerListener progressDrawerListener = this.listener;
            if (progressDrawerListener == null) break block0;
            progressDrawerListener.onRequestInvalidate();
        }
    }

    @Override
    public void setProgressPercent(float progressPercent) {
        int mProgressAngle = (int)(progressPercent * 3.6f);
        if (mProgressAngle > 360) {
            mProgressAngle %= 360;
        }
        this.mOldProgressFrontSweepAngle = this.mCurrentProgressFrontSweepAngle;
        this.mProgressFrontSweepAngle = mProgressAngle;
        if (this.mUseProgressAnimation) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        } else {
            this.setRealProgressAngle(mProgressAngle);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.mUseProgressAnimation = enabled;
    }

    @Override
    public void setAnimationDuration(long millis) {
        long l = this.mProgressAnimationDuration = millis < 0L ? 100L : millis;
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    @Override
    public void setListener(@NotNull ProgressDrawerManager.ProgressDrawerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @Override
    public void setup(@NotNull ProgressOptions progressOptions) {
        Intrinsics.checkParameterIsNotNull((Object)progressOptions, (String)"progressOptions");
        this.mUseProgressAnimation = progressOptions.getDeterminateAnimationEnabled();
        this.drawWedge = progressOptions.getDrawWedge();
        this.mProgressFrontPaint.setColor(progressOptions.getFrontColor());
        this.mProgressFrontPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressFrontPaint.setAntiAlias(true);
        this.mProgressFrontPaint.setStyle(this.drawWedge ? Paint.Style.FILL_AND_STROKE : Paint.Style.STROKE);
        this.mProgressBackPaint.setColor(progressOptions.getBackColor());
        this.mProgressBackPaint.setStrokeWidth((float)progressOptions.getCalculatedBorderWidth());
        this.mProgressBackPaint.setAntiAlias(true);
        this.mProgressBackPaint.setStyle(Paint.Style.STROKE);
        this.mIsProgressReversed = progressOptions.isProgressReversed();
        long l = this.mProgressAnimationDuration = (long)progressOptions.getAnimationDuration() < 0L ? 100L : (long)progressOptions.getAnimationDuration();
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
        this.setProgressPercent(progressOptions.getValuePercent());
    }

    @Override
    public void startIndeterminateAnimation() {
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF progressBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)progressBounds, (String)"progressBounds");
        if (!this.mIsProgressReversed) {
            canvas.drawArc(progressBounds, (float)this.mProgressBackStartAngle, (float)this.mProgressBackSweepAngle, this.drawWedge, this.mProgressBackPaint);
            canvas.drawArc(progressBounds, -90.0f, (float)this.mCurrentProgressFrontSweepAngle, this.drawWedge, this.mProgressFrontPaint);
        } else {
            canvas.drawArc(progressBounds, -90.0f, (float)this.mProgressBackSweepAngle, this.drawWedge, this.mProgressBackPaint);
            canvas.drawArc(progressBounds, -90.0f, (float)(-this.mCurrentProgressFrontSweepAngle), this.drawWedge, this.mProgressFrontPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
    }

    private final int getOldSweepAngle() {
        return this.mOldProgressFrontSweepAngle;
    }

    private final int getSweepAngle() {
        return this.mProgressFrontSweepAngle;
    }

    public CircularProgressDrawer() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0f, 1f)");
        this.mProgressAnimator = valueAnimator;
        this.mProgressAnimationDuration = -1L;
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 100L : this.mProgressAnimationDuration);
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator it) {
                float f = this.getOldSweepAngle();
                float f2 = this.getSweepAngle() - this.getOldSweepAngle();
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                this.setRealProgressAngle((int)(f + f2 * valueAnimator.getAnimatedFraction()));
            }
        });
    }
}

