/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.shape.drawers;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.BaseNormalShapeDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0014J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\tH\u0014J(\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidRoundedRectangleShapeDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/BaseNormalShapeDrawer;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "mRadiusX", "", "mRadiusY", "mSolidPaint", "Landroid/graphics/Paint;", "mSolidRect", "Landroid/graphics/RectF;", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "shapeBounds", "imageBounds", "borderPaint", "drawPaint", "paint", "drawSolid", "setup", "shapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "powerfulimageview_release"})
public final class SolidRoundedRectangleShapeDrawer
extends BaseNormalShapeDrawer {
    private final Paint mSolidPaint = new Paint();
    private final RectF mSolidRect = new RectF();
    private float mRadiusX;
    private float mRadiusY;

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        super.setup(shapeOptions);
        this.mRadiusX = shapeOptions.getRadiusX();
        this.mRadiusY = shapeOptions.getRadiusY();
        this.getMBackPaint().setAntiAlias(true);
        this.getMBackPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        this.getMFrontPaint().setAntiAlias(true);
        this.getMFrontPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSolidPaint.setColor(shapeOptions.getSolidColor());
        this.mSolidPaint.setAntiAlias(true);
        this.mSolidPaint.setStyle(Paint.Style.STROKE);
        float width = Math.max(shapeOptions.getViewBounds().width() - shapeOptions.getBorderBounds().width() + this.mRadiusX, shapeOptions.getViewBounds().height() - shapeOptions.getBorderBounds().height() + this.mRadiusY) / (float)2;
        this.mSolidPaint.setStrokeWidth(width);
        this.mSolidRect.set(shapeOptions.getBorderBounds());
        this.mSolidRect.inset(-width / (float)2 - (float)(shapeOptions.getBorderWidth() / 2), -width / (float)2 - (float)(shapeOptions.getBorderWidth() / 2));
    }

    @Override
    protected void drawPaint(@NotNull Canvas canvas, @NotNull RectF shapeBounds, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.drawRoundRect(shapeBounds, this.mRadiusX, this.mRadiusY, paint);
    }

    @Override
    protected void drawBorder(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds, @NotNull Paint borderPaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        Intrinsics.checkParameterIsNotNull((Object)borderPaint, (String)"borderPaint");
        canvas.drawRoundRect(borderBounds, this.mRadiusX * (borderBounds.width() / shapeBounds.width()), this.mRadiusY * (borderBounds.height() / shapeBounds.height()), borderPaint);
    }

    @Override
    protected void drawSolid(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        canvas.drawRoundRect(this.mSolidRect, this.mRadiusX, this.mRadiusY, this.mSolidPaint);
    }

    public SolidRoundedRectangleShapeDrawer(@Nullable Drawable drawable) {
        super(drawable);
    }
}

