/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeMode;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeScaleType;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.CircleShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.NormalShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.OvalShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.RoundedRectangleShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.ShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.ShapeDrawerManager$WhenMappings;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.SolidCircleShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.SolidOvalShapeDrawer;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.SolidRoundedRectangleShapeDrawer;
import java.lang.ref.WeakReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\u0010J\u000e\u0010F\u001a\u00020D2\u0006\u0010G\u001a\u00020/J\u001e\u0010H\u001a\u0004\u0018\u00010\u00152\b\u0010I\u001a\u0004\u0018\u00010\u00102\b\u0010E\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020KJ\u0006\u0010M\u001a\u00020/J\u0006\u0010N\u001a\u00020\u0005J\u000e\u0010O\u001a\u00020D2\u0006\u0010P\u001a\u00020QJ.\u0010R\u001a\u00020D2\u0006\u0010S\u001a\u00020\u00172\u0006\u0010T\u001a\u00020\u00172\u0006\u0010U\u001a\u00020K2\u0006\u0010V\u001a\u00020K2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010W\u001a\u00020D2\u0006\u0010X\u001a\u00020\u0005H\u0016J\u0010\u0010Y\u001a\u00020D2\u0006\u0010X\u001a\u00020\u0005H\u0016J6\u0010Z\u001a\u00020D2\u0006\u0010S\u001a\u00020K2\u0006\u0010T\u001a\u00020K2\u0006\u0010[\u001a\u00020K2\u0006\u0010\\\u001a\u00020K2\u0006\u0010]\u001a\u00020K2\u0006\u0010^\u001a\u00020KJ\u0010\u0010_\u001a\u00020D2\u0006\u0010X\u001a\u00020\u0005H\u0016J\u0010\u0010`\u001a\u00020D2\b\u0010a\u001a\u0004\u0018\u00010bJ\u0006\u0010c\u001a\u00020bJ\u000e\u0010d\u001a\u00020D2\u0006\u0010e\u001a\u00020\u0013J\u0010\u0010f\u001a\u00020D2\b\u0010g\u001a\u0004\u0018\u00010)J\u0012\u0010h\u001a\u00020D2\b\u0010G\u001a\u0004\u0018\u00010/H\u0002J\u0015\u0010i\u001a\u0004\u0018\u00010K*\u00020\u0015H\u0000\u00a2\u0006\u0004\bj\u0010kJ\u0015\u0010l\u001a\u0004\u0018\u00010K*\u00020\u0015H\u0000\u00a2\u0006\u0004\bm\u0010kR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000e\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000e\u001a\u0004\b%\u0010&R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000e\u001a\u0004\b3\u00104R\u001b\u00106\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u000e\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u000e\u001a\u0004\b=\u0010>R\u001c\u0010@\u001a\u0010\u0012\f\u0012\n B*\u0004\u0018\u00010\u00030\u00030AX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/ShapeDrawerManager;", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions$ShapeOptionsListener;", "view", "Landroid/view/View;", "shapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "(Landroid/view/View;Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;)V", "mBorderBounds", "Landroid/graphics/RectF;", "mCircleShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/CircleShapeDrawer;", "getMCircleShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/CircleShapeDrawer;", "mCircleShapeDrawer$delegate", "Lkotlin/Lazy;", "mDrawable", "Landroid/graphics/drawable/Drawable;", "mImageBounds", "mImageMatrix", "Landroid/graphics/Matrix;", "mLastBitmap", "Landroid/graphics/Bitmap;", "mMeasuredHeight", "", "mMeasuredWidth", "mNormalShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/NormalShapeDrawer;", "getMNormalShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/NormalShapeDrawer;", "mNormalShapeDrawer$delegate", "mOvalShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/OvalShapeDrawer;", "getMOvalShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/OvalShapeDrawer;", "mOvalShapeDrawer$delegate", "mRoundedRectangleShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/RoundedRectangleShapeDrawer;", "getMRoundedRectangleShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/RoundedRectangleShapeDrawer;", "mRoundedRectangleShapeDrawer$delegate", "mScaleType", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeScaleType;", "mShaderMatrix", "mShapeBounds", "mShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/ShapeDrawer;", "mShapeMode", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeMode;", "mShapeOptions", "mSolidCircleShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidCircleShapeDrawer;", "getMSolidCircleShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidCircleShapeDrawer;", "mSolidCircleShapeDrawer$delegate", "mSolidOvalShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidOvalShapeDrawer;", "getMSolidOvalShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidOvalShapeDrawer;", "mSolidOvalShapeDrawer$delegate", "mSolidRoundedRectangleShapeDrawer", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidRoundedRectangleShapeDrawer;", "getMSolidRoundedRectangleShapeDrawer", "()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidRoundedRectangleShapeDrawer;", "mSolidRoundedRectangleShapeDrawer$delegate", "mView", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "changeDrawable", "", "drawable", "changeShapeMode", "shapeMode", "getBitmapFromDrawable", "mLastDrawable", "getMeasuredHeight", "", "getMeasuredWidth", "getShapeMode", "getShapeOptions", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "w", "h", "wMode", "hMode", "onOptionsUpdated", "options", "onRequestMeasure", "onSizeChanged", "paddingLeft", "paddingTop", "paddingRight", "paddingBottom", "onSizeUpdated", "restoreInstanceState", "state", "Landroid/os/Bundle;", "saveInstanceState", "setImageMatrix", "matrix", "setScaleType", "scaleType", "updateDrawers", "safeHeight", "safeHeight$powerfulimageview_release", "(Landroid/graphics/Bitmap;)Ljava/lang/Integer;", "safeWidth", "safeWidth$powerfulimageview_release", "powerfulimageview_release"})
public final class ShapeDrawerManager
implements ShapeOptions.ShapeOptionsListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final WeakReference<View> mView;
    private final RectF mShapeBounds;
    private final RectF mBorderBounds;
    private final RectF mImageBounds;
    private final Matrix mShaderMatrix;
    private Matrix mImageMatrix;
    private PivShapeScaleType mScaleType;
    private Drawable mDrawable;
    private Bitmap mLastBitmap;
    private float mMeasuredWidth;
    private float mMeasuredHeight;
    private final Lazy mCircleShapeDrawer$delegate;
    private final Lazy mNormalShapeDrawer$delegate;
    private final Lazy mOvalShapeDrawer$delegate;
    private final Lazy mSolidCircleShapeDrawer$delegate;
    private final Lazy mRoundedRectangleShapeDrawer$delegate;
    private final Lazy mSolidOvalShapeDrawer$delegate;
    private final Lazy mSolidRoundedRectangleShapeDrawer$delegate;
    private ShapeDrawer mShapeDrawer;
    private PivShapeMode mShapeMode;
    private ShapeOptions mShapeOptions;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mCircleShapeDrawer", "getMCircleShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/CircleShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mNormalShapeDrawer", "getMNormalShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/NormalShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mOvalShapeDrawer", "getMOvalShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/OvalShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mSolidCircleShapeDrawer", "getMSolidCircleShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidCircleShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mRoundedRectangleShapeDrawer", "getMRoundedRectangleShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/RoundedRectangleShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mSolidOvalShapeDrawer", "getMSolidOvalShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidOvalShapeDrawer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShapeDrawerManager.class), "mSolidRoundedRectangleShapeDrawer", "getMSolidRoundedRectangleShapeDrawer()Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidRoundedRectangleShapeDrawer;"))};
    }

    private final CircleShapeDrawer getMCircleShapeDrawer() {
        Lazy lazy = this.mCircleShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (CircleShapeDrawer)lazy.getValue();
    }

    private final NormalShapeDrawer getMNormalShapeDrawer() {
        Lazy lazy = this.mNormalShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (NormalShapeDrawer)lazy.getValue();
    }

    private final OvalShapeDrawer getMOvalShapeDrawer() {
        Lazy lazy = this.mOvalShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (OvalShapeDrawer)lazy.getValue();
    }

    private final SolidCircleShapeDrawer getMSolidCircleShapeDrawer() {
        Lazy lazy = this.mSolidCircleShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[3];
        return (SolidCircleShapeDrawer)lazy.getValue();
    }

    private final RoundedRectangleShapeDrawer getMRoundedRectangleShapeDrawer() {
        Lazy lazy = this.mRoundedRectangleShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[4];
        return (RoundedRectangleShapeDrawer)lazy.getValue();
    }

    private final SolidOvalShapeDrawer getMSolidOvalShapeDrawer() {
        Lazy lazy = this.mSolidOvalShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[5];
        return (SolidOvalShapeDrawer)lazy.getValue();
    }

    private final SolidRoundedRectangleShapeDrawer getMSolidRoundedRectangleShapeDrawer() {
        Lazy lazy = this.mSolidRoundedRectangleShapeDrawer$delegate;
        ShapeDrawerManager shapeDrawerManager = this;
        KProperty kProperty = $$delegatedProperties[6];
        return (SolidRoundedRectangleShapeDrawer)lazy.getValue();
    }

    public final void changeDrawable(@Nullable Drawable drawable) {
        Drawable mLastDrawable = this.mDrawable;
        this.mDrawable = drawable;
        this.mShapeDrawer.changeDrawable(drawable);
        if (this.mShapeDrawer.requireBitmap()) {
            this.mLastBitmap = this.getBitmapFromDrawable(mLastDrawable, drawable);
            this.mShapeDrawer.changeBitmap(this.mLastBitmap);
        } else {
            this.mLastBitmap = null;
        }
        this.setScaleType(this.mScaleType);
    }

    private final Bitmap getBitmapFromDrawable(Drawable mLastDrawable, Drawable drawable) {
        if (drawable == null || this.mMeasuredWidth <= 0.0f || this.mMeasuredHeight <= 0.0f) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"drawable.bitmap");
            return bitmap.isRecycled() ? null : ((BitmapDrawable)drawable).getBitmap();
        }
        try {
            Bitmap bitmap;
            if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
                Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = bitmap2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
            } else if (drawable instanceof ColorDrawable) {
                Bitmap bitmap3 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = bitmap3;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
            } else {
                float ratio = (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight();
                Ref.IntRef sizeX = new Ref.IntRef();
                Ref.IntRef sizeY = new Ref.IntRef();
                int maxWidth = (int)Math.max(this.mImageBounds.width(), this.mImageBounds.height() * ratio);
                int maxHeight = (int)Math.max(this.mImageBounds.height(), this.mImageBounds.width() / ratio);
                if (drawable.getIntrinsicWidth() > maxWidth && maxWidth > 0 && drawable.getIntrinsicHeight() > maxHeight && maxHeight > 0) {
                    sizeX.element = maxWidth;
                    sizeY.element = maxHeight;
                } else {
                    sizeX.element = drawable.getIntrinsicWidth();
                    sizeY.element = drawable.getIntrinsicHeight();
                }
                if (Intrinsics.areEqual((Object)drawable.getClass().getName(), (Object)"android.graphics.drawable.VectorDrawable") || drawable instanceof VectorDrawableCompat) {
                    sizeX.element = maxWidth;
                    sizeY.element = maxHeight;
                }
                Bitmap bitmap4 = this.mLastBitmap;
                if (bitmap4 != null) {
                    if (!bitmap4.isRecycled()) {
                        Bitmap bitmap5 = this.mLastBitmap;
                        if (bitmap5 != null) {
                            Bitmap bitmap6;
                            Bitmap it = bitmap6 = bitmap5;
                            if (sizeX.element > 0 && sizeY.element > 0 && mLastDrawable == this.mDrawable) {
                                return it.isRecycled() ? null : it;
                            }
                        }
                        Bitmap bitmap7 = this.mLastBitmap;
                        if (bitmap7 != null) {
                            bitmap7.recycle();
                        }
                    }
                }
                Bitmap bitmap8 = Bitmap.createBitmap((int)sizeX.element, (int)sizeY.element, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap = bitmap8;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap8, (String)"Bitmap.createBitmap(size\u2026 Bitmap.Config.ARGB_8888)");
            }
            Bitmap bitmap9 = bitmap;
            Canvas canvas = new Canvas(bitmap9);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap9.isRecycled() ? null : bitmap9;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void updateDrawers(PivShapeMode shapeMode) {
        ShapeDrawer shapeDrawer;
        PivShapeMode pivShapeMode = shapeMode;
        if (pivShapeMode == null) {
            pivShapeMode = PivShapeMode.NORMAL;
        }
        switch (ShapeDrawerManager$WhenMappings.$EnumSwitchMapping$0[pivShapeMode.ordinal()]) {
            case 1: {
                shapeDrawer = this.getMCircleShapeDrawer();
                break;
            }
            case 2: {
                shapeDrawer = this.getMNormalShapeDrawer();
                break;
            }
            case 3: {
                shapeDrawer = this.getMNormalShapeDrawer();
                break;
            }
            case 4: {
                shapeDrawer = this.getMOvalShapeDrawer();
                break;
            }
            case 5: {
                shapeDrawer = this.getMRoundedRectangleShapeDrawer();
                break;
            }
            case 6: {
                shapeDrawer = this.getMSolidCircleShapeDrawer();
                break;
            }
            case 7: {
                shapeDrawer = this.getMSolidOvalShapeDrawer();
                break;
            }
            case 8: {
                shapeDrawer = this.getMSolidRoundedRectangleShapeDrawer();
                break;
            }
            case 9: {
                shapeDrawer = this.getMNormalShapeDrawer();
                break;
            }
            default: {
                shapeDrawer = this.getMNormalShapeDrawer();
            }
        }
        this.mShapeDrawer = shapeDrawer;
    }

    public final void onSizeChanged(int w, int h, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mShapeOptions.calculateBounds(w, h, paddingLeft, paddingTop, paddingRight, paddingBottom, this.mShapeMode);
        this.onSizeUpdated(this.mShapeOptions);
    }

    public final void onMeasure(float w, float h, int wMode, int hMode, @NotNull View view) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Drawable drawable = this.mDrawable;
        Float drawableWidth = drawable != null ? Float.valueOf(drawable.getIntrinsicWidth() + view.getPaddingLeft() + view.getPaddingRight()) : null;
        Drawable drawable2 = this.mDrawable;
        Float drawableHeight = drawable2 != null ? Float.valueOf(drawable2.getIntrinsicHeight() + view.getPaddingTop() + view.getPaddingBottom()) : null;
        switch (ShapeDrawerManager$WhenMappings.$EnumSwitchMapping$1[this.mShapeMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                f = 1.0f;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.mShapeOptions.getRatio() <= 0.0f) {
                    Float f2 = drawableWidth;
                    Float f3 = drawableHeight;
                    f = (f2 != null ? f2.floatValue() : w) / (f3 != null ? f3.floatValue() : h);
                    break;
                }
                f = this.mShapeOptions.getRatio();
                break;
            }
            default: {
                if (this.mShapeOptions.getRatio() <= 0.0f) {
                    Float f4 = drawableWidth;
                    Float f5 = drawableHeight;
                    f = (f4 != null ? f4.floatValue() : w) / (f5 != null ? f5.floatValue() : h);
                    break;
                }
                f = this.mShapeOptions.getRatio();
            }
        }
        float usedRatio = f;
        Float f6 = drawableWidth;
        float w2 = f6 != null ? RangesKt.coerceAtMost((float)f6.floatValue(), (float)w) : w;
        Float f7 = drawableHeight;
        float h2 = f7 != null ? RangesKt.coerceAtMost((float)f7.floatValue(), (float)h) : h;
        block4 : switch (wMode) {
            case 0x40000000: {
                this.mMeasuredWidth = w;
                this.mMeasuredHeight = w / usedRatio;
                switch (hMode) {
                    case 0x40000000: {
                        this.mMeasuredHeight = h;
                        break;
                    }
                    case -2147483648: {
                        this.mMeasuredHeight = Math.min(w / usedRatio, h);
                        break;
                    }
                    case 0: {
                        float cfr_ignored_0 = w / usedRatio;
                    }
                }
                break;
            }
            case -2147483648: {
                this.mMeasuredWidth = w;
                this.mMeasuredHeight = w / usedRatio;
                if (hMode == 0x40000000) {
                    this.mMeasuredWidth = Math.min(h * usedRatio, w);
                    this.mMeasuredHeight = h;
                }
                if (hMode == Integer.MIN_VALUE) {
                    this.mMeasuredWidth = Math.min(h2 * usedRatio, w2);
                    this.mMeasuredHeight = Math.min(h2, w2 / usedRatio);
                }
                if (hMode != 0) break;
                this.mMeasuredWidth = w2;
                this.mMeasuredHeight = w2 / usedRatio;
                break;
            }
            default: {
                this.mMeasuredWidth = w2;
                this.mMeasuredHeight = w2 / usedRatio;
                switch (hMode) {
                    case 0x40000000: {
                        this.mMeasuredWidth = h * usedRatio;
                        this.mMeasuredHeight = h;
                        break block4;
                    }
                    case -2147483648: {
                        this.mMeasuredWidth = h2 * usedRatio;
                        this.mMeasuredHeight = h2;
                        break block4;
                    }
                    case 0: {
                        this.mMeasuredWidth = w2;
                        this.mMeasuredHeight = w2 / usedRatio;
                    }
                }
            }
        }
    }

    public final void setImageMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        this.mImageMatrix = matrix;
        this.setScaleType(PivShapeScaleType.MATRIX);
    }

    public final void setScaleType(@Nullable PivShapeScaleType scaleType) {
        this.mScaleType = scaleType;
        if (this.mDrawable == null || scaleType == null) {
            return;
        }
        this.mShaderMatrix.reset();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        Drawable drawable = this.mDrawable;
        int dWidth = drawable != null ? drawable.getIntrinsicWidth() : 0;
        Drawable drawable2 = this.mDrawable;
        int dHeight = drawable2 != null ? drawable2.getIntrinsicHeight() : 0;
        Bitmap bitmap = this.mLastBitmap;
        if (bitmap != null) {
            if (!bitmap.isRecycled()) {
                Object object = this.mLastBitmap;
                scaleX = (float)dWidth / (float)(object != null && (object = this.safeWidth$powerfulimageview_release((Bitmap)object)) != null ? (Integer)object : dWidth);
                Object object2 = this.mLastBitmap;
                scaleY = (float)dHeight / (float)(object2 != null && (object2 = this.safeHeight$powerfulimageview_release((Bitmap)object2)) != null ? (Integer)object2 : dHeight);
            }
        }
        float vWidth = this.mImageBounds.width();
        float vHeight = this.mImageBounds.height();
        Rect padding = new Rect(0, 0, 0, 0);
        if (this.mView.get() != null) {
            View view = (View)this.mView.get();
            View view2 = (View)this.mView.get();
            View view3 = (View)this.mView.get();
            View view4 = (View)this.mView.get();
            padding.set(view != null ? view.getPaddingLeft() : padding.left, view2 != null ? view2.getPaddingBottom() : padding.right, view3 != null ? view3.getPaddingRight() : padding.bottom, view4 != null ? view4.getPaddingTop() : padding.top);
        }
        switch (ShapeDrawerManager$WhenMappings.$EnumSwitchMapping$2[scaleType.ordinal()]) {
            case 1: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = (vHeight - (float)dHeight * scale) * 0.5f;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case 2: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = 0.0f;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case 3: {
                float dy;
                float dx;
                float scale;
                if ((float)dWidth * vHeight > vWidth * (float)dHeight) {
                    scale = vHeight / (float)dHeight;
                    dx = (vWidth - (float)dWidth * scale) * 0.5f;
                    dy = 0.0f;
                } else {
                    scale = vWidth / (float)dWidth;
                    dy = vHeight - (float)dHeight * scale;
                    dx = 0.0f;
                }
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case 4: {
                float scale = (float)dWidth <= vWidth && (float)dHeight <= vHeight ? 1.0f : Math.min(vWidth / (float)dWidth, vHeight / (float)dHeight);
                float dx = (vWidth - (float)dWidth * scale) * 0.5f;
                float dy = (vHeight - (float)dHeight * scale) * 0.5f;
                this.mShaderMatrix.setScale(scale * scaleX, scale * scaleY);
                this.mShaderMatrix.postTranslate(dx + this.mImageBounds.left, dy + this.mImageBounds.top);
                break;
            }
            case 5: {
                Object object;
                Object object3 = this.mLastBitmap;
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)(object3 != null && (object3 = this.safeWidth$powerfulimageview_release((Bitmap)object3)) != null ? (Integer)object3 : dWidth), (float)((object = this.mLastBitmap) != null && (object = this.safeHeight$powerfulimageview_release((Bitmap)object)) != null ? (Integer)object : dHeight)), this.mImageBounds, Matrix.ScaleToFit.CENTER);
                break;
            }
            case 6: {
                Object object;
                Object object4 = this.mLastBitmap;
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)(object4 != null && (object4 = this.safeWidth$powerfulimageview_release((Bitmap)object4)) != null ? (Integer)object4 : dWidth), (float)((object = this.mLastBitmap) != null && (object = this.safeHeight$powerfulimageview_release((Bitmap)object)) != null ? (Integer)object : dHeight)), this.mImageBounds, Matrix.ScaleToFit.END);
                break;
            }
            case 7: {
                Object object;
                Object object5 = this.mLastBitmap;
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)(object5 != null && (object5 = this.safeWidth$powerfulimageview_release((Bitmap)object5)) != null ? (Integer)object5 : dWidth), (float)((object = this.mLastBitmap) != null && (object = this.safeHeight$powerfulimageview_release((Bitmap)object)) != null ? (Integer)object : dHeight)), this.mImageBounds, Matrix.ScaleToFit.START);
                break;
            }
            case 8: {
                Object object;
                Object object6 = this.mLastBitmap;
                this.mShaderMatrix.setRectToRect(new RectF(0.0f, 0.0f, (float)(object6 != null && (object6 = this.safeWidth$powerfulimageview_release((Bitmap)object6)) != null ? (Integer)object6 : dWidth), (float)((object = this.mLastBitmap) != null && (object = this.safeHeight$powerfulimageview_release((Bitmap)object)) != null ? (Integer)object : dHeight)), this.mImageBounds, Matrix.ScaleToFit.FILL);
                break;
            }
            case 9: {
                this.mShaderMatrix.preScale(scaleX, scaleY);
                if (this.mImageMatrix != null) {
                    this.mShaderMatrix.set(this.mImageMatrix);
                }
                this.mShaderMatrix.postTranslate(this.mImageBounds.left, this.mImageBounds.top);
                break;
            }
            case 10: {
                this.mShaderMatrix.setScale(scaleX, scaleY);
                this.mShaderMatrix.postTranslate((vWidth - (float)dWidth) * 0.5f + this.mImageBounds.left, (vHeight - (float)dHeight) * 0.5f + this.mImageBounds.top);
                break;
            }
            default: {
                this.mShaderMatrix.setScale(scaleX, scaleY);
                this.mShaderMatrix.postTranslate((vWidth - (float)dWidth) * 0.5f + this.mImageBounds.left, (vHeight - (float)dHeight) * 0.5f + this.mImageBounds.top);
            }
        }
        this.mShapeDrawer.setMatrix(scaleType, this.mShaderMatrix);
    }

    @Nullable
    public final Integer safeWidth$powerfulimageview_release(@NotNull Bitmap $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.isRecycled() ? null : Integer.valueOf($receiver.getWidth());
    }

    @Nullable
    public final Integer safeHeight$powerfulimageview_release(@NotNull Bitmap $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.isRecycled() ? null : Integer.valueOf($receiver.getHeight());
    }

    public final void changeShapeMode(@NotNull PivShapeMode shapeMode) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)shapeMode), (String)"shapeMode");
            if (this.mShapeMode == shapeMode) {
                return;
            }
            this.mShapeMode = shapeMode;
            this.updateDrawers(this.mShapeMode);
            this.mShapeDrawer.setup(this.mShapeOptions);
            View view = (View)this.mView.get();
            if (view == null) break block1;
            view.postInvalidate();
        }
    }

    public final void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.mShapeDrawer.draw(canvas, this.mBorderBounds, this.mShapeBounds, this.mImageBounds);
    }

    @NotNull
    public final ShapeOptions getShapeOptions() {
        return this.mShapeOptions;
    }

    @Override
    public void onRequestMeasure(@NotNull ShapeOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.mShapeOptions = options;
        View view = (View)this.mView.get();
        if (view != null) {
            view.requestLayout();
        }
        this.mShapeDrawer.setup(options);
    }

    @Override
    public void onOptionsUpdated(@NotNull ShapeOptions options) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            this.mShapeOptions = options;
            this.mShapeDrawer.setup(options);
            View view = (View)this.mView.get();
            if (view == null) break block0;
            view.postInvalidate();
        }
    }

    @Override
    public void onSizeUpdated(@NotNull ShapeOptions options) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            this.mShapeOptions = options;
            this.mShapeBounds.set(this.mShapeOptions.getShapeBounds());
            this.mBorderBounds.set(this.mShapeOptions.getBorderBounds());
            this.mImageBounds.set(this.mShapeOptions.getImageBounds());
            this.changeDrawable(this.mDrawable);
            this.mShapeDrawer.setup(this.mShapeOptions);
            View view = (View)this.mView.get();
            if (view == null) break block0;
            view.postInvalidate();
        }
    }

    public final int getMeasuredHeight() {
        return (int)this.mMeasuredHeight;
    }

    public final int getMeasuredWidth() {
        return (int)this.mMeasuredWidth;
    }

    @NotNull
    public final PivShapeMode getShapeMode() {
        return this.mShapeMode;
    }

    @NotNull
    public final Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("shape_options", (Parcelable)this.mShapeOptions);
        bundle.putInt("shape_mode", this.mShapeMode.getValue$powerfulimageview_release());
        return bundle;
    }

    public final void restoreInstanceState(@Nullable Bundle state) {
        if (state == null) {
            return;
        }
        Parcelable parcelable = state.getParcelable("shape_options");
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions");
        }
        this.mShapeOptions.setOptions((ShapeOptions)parcelable);
        PivShapeMode shapeMode = PivShapeMode.Companion.fromValue(state.getInt("shape_mode"));
        this.onSizeUpdated(this.mShapeOptions);
        this.changeShapeMode(shapeMode);
    }

    public ShapeDrawerManager(@NotNull View view, @NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        this.mView = new WeakReference<View>(view);
        this.mShapeBounds = new RectF();
        this.mBorderBounds = new RectF();
        this.mImageBounds = new RectF();
        this.mShaderMatrix = new Matrix();
        this.mCircleShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CircleShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final CircleShapeDrawer invoke() {
                return new CircleShapeDrawer(ShapeDrawerManager.access$getBitmapFromDrawable(this.this$0, ShapeDrawerManager.access$getMDrawable$p(this.this$0), ShapeDrawerManager.access$getMDrawable$p(this.this$0)));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mNormalShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NormalShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final NormalShapeDrawer invoke() {
                return new NormalShapeDrawer(ShapeDrawerManager.access$getMDrawable$p(this.this$0));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mOvalShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OvalShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final OvalShapeDrawer invoke() {
                return new OvalShapeDrawer(ShapeDrawerManager.access$getBitmapFromDrawable(this.this$0, ShapeDrawerManager.access$getMDrawable$p(this.this$0), ShapeDrawerManager.access$getMDrawable$p(this.this$0)));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mSolidCircleShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SolidCircleShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final SolidCircleShapeDrawer invoke() {
                return new SolidCircleShapeDrawer(ShapeDrawerManager.access$getMDrawable$p(this.this$0));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mRoundedRectangleShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RoundedRectangleShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final RoundedRectangleShapeDrawer invoke() {
                return new RoundedRectangleShapeDrawer(ShapeDrawerManager.access$getBitmapFromDrawable(this.this$0, ShapeDrawerManager.access$getMDrawable$p(this.this$0), ShapeDrawerManager.access$getMDrawable$p(this.this$0)));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mSolidOvalShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SolidOvalShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final SolidOvalShapeDrawer invoke() {
                return new SolidOvalShapeDrawer(ShapeDrawerManager.access$getMDrawable$p(this.this$0));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mSolidRoundedRectangleShapeDrawer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SolidRoundedRectangleShapeDrawer>(this){
            final /* synthetic */ ShapeDrawerManager this$0;

            @NotNull
            public final SolidRoundedRectangleShapeDrawer invoke() {
                return new SolidRoundedRectangleShapeDrawer(ShapeDrawerManager.access$getMDrawable$p(this.this$0));
            }
            {
                this.this$0 = shapeDrawerManager;
                super(0);
            }
        }));
        this.mShapeDrawer = new NormalShapeDrawer(null);
        this.mShapeMode = PivShapeMode.NORMAL;
        this.mShapeOptions = shapeOptions;
        this.mShapeOptions.setListener(this);
        this.mShaderMatrix.reset();
    }

    @Nullable
    public static final /* synthetic */ Bitmap access$getBitmapFromDrawable(ShapeDrawerManager $this, @Nullable Drawable mLastDrawable, @Nullable Drawable drawable) {
        return $this.getBitmapFromDrawable(mLastDrawable, drawable);
    }

    @Nullable
    public static final /* synthetic */ Drawable access$getMDrawable$p(ShapeDrawerManager $this) {
        return $this.mDrawable;
    }

    public static final /* synthetic */ void access$setMDrawable$p(ShapeDrawerManager $this, @Nullable Drawable drawable) {
        $this.mDrawable = drawable;
    }
}

