/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import com.stefanosiano.powerful_libraries.imageview.ImageViewWrapper;
import com.stefanosiano.powerful_libraries.imageview.R;
import com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerful_libraries.imageview.blur.PivBlurMode;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurManager;
import com.stefanosiano.powerful_libraries.imageview.progress.PivProgressGravity;
import com.stefanosiano.powerful_libraries.imageview.progress.PivProgressMode;
import com.stefanosiano.powerful_libraries.imageview.progress.PivShapeCutGravity;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeMode;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeScaleType;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.ShapeDrawerManager;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0011H\u0002J\b\u0010?\u001a\u0004\u0018\u00010@J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020DJ\b\u0010E\u001a\u0004\u0018\u00010@J\u0006\u0010F\u001a\u00020\tJ\u0006\u0010G\u001a\u00020\fJ\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020QH\u0014J\b\u0010R\u001a\u00020QH\u0014J\u0010\u0010S\u001a\u00020Q2\u0006\u0010T\u001a\u00020UH\u0014J\r\u0010V\u001a\u00020QH\u0010\u00a2\u0006\u0002\bWJ\u0018\u0010X\u001a\u00020Q2\u0006\u0010Y\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0014J(\u0010[\u001a\u00020Q2\u0006\u0010\\\u001a\u00020\t2\u0006\u0010]\u001a\u00020\t2\u0006\u0010^\u001a\u00020\t2\u0006\u0010_\u001a\u00020\tH\u0014J\u0016\u0010`\u001a\u00020Q2\u0006\u0010a\u001a\u00020B2\u0006\u0010b\u001a\u00020\tJ\u000e\u0010c\u001a\u00020Q2\u0006\u0010b\u001a\u00020\tJ\u0010\u0010d\u001a\u00020Q2\u0006\u0010e\u001a\u00020fH\u0016J\u000e\u0010g\u001a\u00020Q2\u0006\u0010h\u001a\u00020\tJ\u000e\u0010i\u001a\u00020Q2\u0006\u0010a\u001a\u00020BJ\u000e\u0010j\u001a\u00020Q2\u0006\u0010k\u001a\u00020\tJ\u000e\u0010l\u001a\u00020Q2\u0006\u0010m\u001a\u00020\tJ\u000e\u0010n\u001a\u00020Q2\u0006\u0010o\u001a\u00020\u0011J\u000e\u0010p\u001a\u00020Q2\u0006\u0010q\u001a\u00020\u0011J\u000e\u0010r\u001a\u00020Q2\u0006\u0010s\u001a\u00020\tJ\u000e\u0010t\u001a\u00020Q2\u0006\u0010u\u001a\u00020\tJ\u000e\u0010v\u001a\u00020Q2\u0006\u0010w\u001a\u00020\tJ\u000e\u0010x\u001a\u00020Q2\u0006\u0010w\u001a\u00020\fJ\u000e\u0010y\u001a\u00020Q2\u0006\u0010z\u001a\u00020\u0011J\u000e\u0010{\u001a\u00020Q2\u0006\u0010|\u001a\u00020\u0011J\u000e\u0010}\u001a\u00020Q2\u0006\u0010~\u001a\u00020\tJ\u0010\u0010\u007f\u001a\u00020Q2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001J\u0010\u0010\u0082\u0001\u001a\u00020Q2\u0007\u0010\u0083\u0001\u001a\u00020\u0011J\u0010\u0010\u0084\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\tJ\u0010\u0010\u0086\u0001\u001a\u00020Q2\u0007\u0010\u0087\u0001\u001a\u00020IJ\u0010\u0010\u0088\u0001\u001a\u00020Q2\u0007\u0010\u0089\u0001\u001a\u00020\tJ\u0010\u0010\u008a\u0001\u001a\u00020Q2\u0007\u0010\u008b\u0001\u001a\u00020\u0011J\u0010\u0010\u008c\u0001\u001a\u00020Q2\u0007\u0010\u008d\u0001\u001a\u00020\u0011J\u0010\u0010\u008e\u0001\u001a\u00020Q2\u0007\u0010\u008f\u0001\u001a\u00020\u0011J\u0010\u0010\u0090\u0001\u001a\u00020Q2\u0007\u0010\u0091\u0001\u001a\u00020\tJ\u0010\u0010\u0092\u0001\u001a\u00020Q2\u0007\u0010\u0093\u0001\u001a\u00020\fJ\u0010\u0010\u0094\u0001\u001a\u00020Q2\u0007\u0010\u0095\u0001\u001a\u00020\tJ\u0010\u0010\u0096\u0001\u001a\u00020Q2\u0007\u0010\u0097\u0001\u001a\u00020\u0011J\u0010\u0010\u0098\u0001\u001a\u00020Q2\u0007\u0010\u0099\u0001\u001a\u00020\tJ\u0010\u0010\u009a\u0001\u001a\u00020Q2\u0007\u0010\u0099\u0001\u001a\u00020\fJ\u0010\u0010\u009b\u0001\u001a\u00020Q2\u0007\u0010\u009c\u0001\u001a\u00020\tJ\u0010\u0010\u009d\u0001\u001a\u00020Q2\u0007\u0010\u009c\u0001\u001a\u00020\fJ\u0010\u0010\u009e\u0001\u001a\u00020Q2\u0007\u0010\u009f\u0001\u001a\u00020\fJ\u0011\u0010\u00a0\u0001\u001a\u00020Q2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001J\u0010\u0010\u00a3\u0001\u001a\u00020Q2\u0007\u0010\u00a4\u0001\u001a\u00020\tJ\u0010\u0010\u00a5\u0001\u001a\u00020Q2\u0007\u0010\u00a6\u0001\u001a\u00020\tJ\u0010\u0010\u00a7\u0001\u001a\u00020Q2\u0007\u0010\u00a8\u0001\u001a\u00020\u0011J\u0010\u0010\u00a9\u0001\u001a\u00020Q2\u0007\u0010\u00aa\u0001\u001a\u00020\tJ\u0011\u0010\u00ab\u0001\u001a\u00020Q2\b\u0010\u00ac\u0001\u001a\u00030\u00a2\u0001J\u0010\u0010\u00ad\u0001\u001a\u00020Q2\u0007\u0010\u00ae\u0001\u001a\u00020\tJ\u0010\u0010\u00af\u0001\u001a\u00020Q2\u0007\u0010\u00b0\u0001\u001a\u00020\tJ\u0010\u0010\u00b1\u0001\u001a\u00020Q2\u0007\u0010\u00b0\u0001\u001a\u00020\fJ\u0010\u0010\u00b2\u0001\u001a\u00020Q2\u0007\u0010\u00b3\u0001\u001a\u00020MJ\u0010\u0010\u00b4\u0001\u001a\u00020Q2\u0007\u0010\u00b5\u0001\u001a\u00020\fJ\u0010\u0010\u00b6\u0001\u001a\u00020Q2\u0007\u0010\u00b7\u0001\u001a\u00020\fJ\u0010\u0010\u00b8\u0001\u001a\u00020Q2\u0007\u0010\u00b9\u0001\u001a\u00020\fJ\u0011\u0010\u00ba\u0001\u001a\u00020Q2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001J\u0010\u0010\u00bd\u0001\u001a\u00020Q2\u0007\u0010\u00be\u0001\u001a\u00020\tJ\u0010\u0010\u00bf\u0001\u001a\u00020Q2\u0007\u0010\u00c0\u0001\u001a\u00020\u0011J\u0010\u0010\u00c1\u0001\u001a\u00020Q2\u0007\u0010\u0087\u0001\u001a\u00020IJ\u0010\u0010\u00c2\u0001\u001a\u00020Q2\u0007\u0010\u00c3\u0001\u001a\u00020\fJ\u0013\u0010\u00c4\u0001\u001a\u00020Q2\b\u0010\u00c5\u0001\u001a\u00030\u00c6\u0001H\u0016J\u0010\u0010\u00c7\u0001\u001a\u00020Q2\u0007\u0010\u00b3\u0001\u001a\u00020MJ\u0011\u0010\u00c8\u0001\u001a\u00020Q2\b\u0010\u00c5\u0001\u001a\u00030\u00bc\u0001R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c9\u0001"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/PowerfulImageView;", "Lcom/stefanosiano/powerful_libraries/imageview/ImageViewWrapper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_BLUR_DOWNSAMPLING_RATE", "", "DEFAULT_BLUR_MODE", "DEFAULT_BLUR_NUM_THREADS", "DEFAULT_BLUR_RADIUS", "DEFAULT_BLUR_STATIC", "", "DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK", "DEFAULT_PROGRESS_ANIMATION_DURATION", "DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE", "DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT", "DEFAULT_PROGRESS_GRAVITY", "DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION", "DEFAULT_PROGRESS_INDETERMINATE", "DEFAULT_PROGRESS_MODE", "DEFAULT_PROGRESS_PADDING", "DEFAULT_PROGRESS_REMOVED_ON_CHANGE", "DEFAULT_PROGRESS_REVERSED", "DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH", "DEFAULT_PROGRESS_SHADOW_ENABLED", "DEFAULT_PROGRESS_SHADOW_PADDING", "DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT", "DEFAULT_PROGRESS_SIZE", "DEFAULT_PROGRESS_SIZE_PERCENT", "DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION", "DEFAULT_PROGRESS_VALUE", "DEFAULT_PROGRESS_WIDTH", "DEFAULT_PROGRESS_WIDTH_PERCENT", "DEFAULT_SHAPE_BORDER_OVERLAY", "DEFAULT_SHAPE_BORDER_WIDTH", "DEFAULT_SHAPE_CUT_GRAVITY", "DEFAULT_SHAPE_CUT_RADIUS_1", "DEFAULT_SHAPE_CUT_RADIUS_1_PERCENT", "DEFAULT_SHAPE_CUT_RADIUS_2", "DEFAULT_SHAPE_CUT_RADIUS_2_PERCENT", "DEFAULT_SHAPE_INNER_PADDING", "DEFAULT_SHAPE_INNER_PADDING_PERCENT", "DEFAULT_SHAPE_MODE", "DEFAULT_SHAPE_RADIUS_X", "DEFAULT_SHAPE_RADIUS_Y", "DEFAULT_SHAPE_RATIO", "initialized", "mBlurManager", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurManager;", "mCheckBlur", "mProgressDrawerManager", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager;", "mShapeDrawerManager", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/ShapeDrawerManager;", "mShouldCheckRemoveProgress", "blurBitmap", "changeDrawable", "getBlurBlurredBitmap", "Landroid/graphics/Bitmap;", "getBlurMode", "Lcom/stefanosiano/powerful_libraries/imageview/blur/PivBlurMode;", "getBlurOptions", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;", "getBlurOriginalBitmap", "getBlurRadius", "getProgress", "getProgressMode", "Lcom/stefanosiano/powerful_libraries/imageview/progress/PivProgressMode;", "getProgressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "getShapeMode", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeMode;", "getShapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "onAttachedToWindow", "", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDrawableChanged", "onDrawableChanged$powerfulimageview_release", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setBlurMode", "blurMode", "radius", "setBlurRadius", "setImageMatrix", "matrix", "Landroid/graphics/Matrix;", "setPivBlurDownSamplingRate", "blurDownSamplingRate", "setPivBlurMode", "setPivBlurNumThreads", "blurNumThreads", "setPivBlurRadius", "blurRadius", "setPivBlurStatic", "blurStatic", "setPivBlurUseRsFallback", "blurUseRsFallback", "setPivProgressAnimationDuration", "duration", "setPivProgressBackColor", "progressBackColor", "setPivProgressBorderWidth", "progressBorderWidth", "setPivProgressBorderWidthPercent", "setPivProgressDeterminateAnimationEnabled", "progressDeterminateAnimationEnabled", "setPivProgressDrawWedge", "progressDrawWedge", "setPivProgressFrontColor", "progressFrontColor", "setPivProgressGravity", "progressGravity", "Lcom/stefanosiano/powerful_libraries/imageview/progress/PivProgressGravity;", "setPivProgressIndeterminate", "progressIndeterminate", "setPivProgressIndeterminateColor", "progressIndeterminateColor", "setPivProgressMode", "progressMode", "setPivProgressPadding", "progressPadding", "setPivProgressRemovedOnChange", "progressRemovedOnChange", "setPivProgressReversed", "progressReversed", "setPivProgressRtlDisabled", "progressRtlDisabled", "setPivProgressShadowBorderColor", "progressShadowBorderColor", "setPivProgressShadowBorderWidth", "progressShadowBorderWidth", "setPivProgressShadowColor", "progressShadowColor", "setPivProgressShadowEnabled", "progressShadowEnabled", "setPivProgressShadowPadding", "progressShadowPadding", "setPivProgressShadowPaddingPercent", "setPivProgressSize", "progressSize", "setPivProgressSizePercent", "setPivProgressValue", "progressValue", "setPivShapeBackground", "shapeBackground", "Landroid/graphics/drawable/Drawable;", "setPivShapeBackgroundColor", "shapeBackgroundColor", "setPivShapeBorderColor", "shapeBorderColor", "setPivShapeBorderOverlay", "shapeBorderOverlay", "setPivShapeBorderWidth", "shapeBorderWidth", "setPivShapeForeground", "shapeForeground", "setPivShapeForegroundColor", "shapeForegroundColor", "setPivShapeInnerPadding", "shapeInnerPadding", "setPivShapeInnerPaddingPercent", "setPivShapeMode", "shapeMode", "setPivShapeRadiusX", "shapeRadiusX", "setPivShapeRadiusY", "shapeRadiusY", "setPivShapeRatio", "shapeRatio", "setPivShapeScaleType", "shapeScaleType", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeScaleType;", "setPivShapeSolidColor", "shapeSolidColor", "setProgressIndeterminate", "isIndeterminate", "setProgressMode", "setProgressValue", "progress", "setScaleType", "scaleType", "Landroid/widget/ImageView$ScaleType;", "setShapeMode", "setShapeScaleType", "powerfulimageview_release"})
public class PowerfulImageView
extends ImageViewWrapper {
    private final boolean DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
    private final int DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
    private final int DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION = 600;
    private final int DEFAULT_PROGRESS_WIDTH = -1;
    private final float DEFAULT_PROGRESS_WIDTH_PERCENT = 10.0f;
    private final int DEFAULT_PROGRESS_SIZE = -1;
    private final float DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
    private final int DEFAULT_PROGRESS_PADDING = 2;
    private final int DEFAULT_PROGRESS_VALUE = 0;
    private final int DEFAULT_PROGRESS_GRAVITY;
    private final boolean DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT = false;
    private final boolean DEFAULT_PROGRESS_INDETERMINATE = true;
    private final boolean DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE = false;
    private final boolean DEFAULT_PROGRESS_SHADOW_ENABLED = true;
    private final boolean DEFAULT_PROGRESS_REVERSED = false;
    private final boolean DEFAULT_PROGRESS_REMOVED_ON_CHANGE = true;
    private final int DEFAULT_PROGRESS_MODE;
    private final int DEFAULT_PROGRESS_SHADOW_PADDING = -1;
    private final float DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT = 0.0f;
    private final int DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH = 1;
    private final int DEFAULT_SHAPE_MODE;
    private final int DEFAULT_SHAPE_CUT_GRAVITY;
    private final int DEFAULT_SHAPE_INNER_PADDING = -1;
    private final float DEFAULT_SHAPE_INNER_PADDING_PERCENT = 0.0f;
    private final boolean DEFAULT_SHAPE_BORDER_OVERLAY = false;
    private final int DEFAULT_SHAPE_BORDER_WIDTH = 0;
    private final float DEFAULT_SHAPE_RATIO = 0.0f;
    private final float DEFAULT_SHAPE_RADIUS_X = 1.0f;
    private final float DEFAULT_SHAPE_RADIUS_Y = 1.0f;
    private final int DEFAULT_SHAPE_CUT_RADIUS_1 = 0;
    private final float DEFAULT_SHAPE_CUT_RADIUS_1_PERCENT = 25.0f;
    private final int DEFAULT_SHAPE_CUT_RADIUS_2 = 0;
    private final float DEFAULT_SHAPE_CUT_RADIUS_2_PERCENT = 100.0f;
    private final int DEFAULT_BLUR_RADIUS = 0;
    private final float DEFAULT_BLUR_DOWNSAMPLING_RATE = 4.0f;
    private final boolean DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK = true;
    private final int DEFAULT_BLUR_NUM_THREADS = 0;
    private final boolean DEFAULT_BLUR_STATIC = false;
    private final int DEFAULT_BLUR_MODE;
    private final ProgressDrawerManager mProgressDrawerManager;
    private final ShapeDrawerManager mShapeDrawerManager;
    private final BlurManager mBlurManager;
    private boolean mCheckBlur;
    private boolean mShouldCheckRemoveProgress;
    private boolean initialized;
    private HashMap _$_findViewCache;

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (!this.initialized) {
            return;
        }
        if (w == oldw && h == oldh) {
            return;
        }
        this.mProgressDrawerManager.onSizeChanged(w, h);
        this.mShapeDrawerManager.onSizeChanged(w, h, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        int n = this.mShapeDrawerManager.getMeasuredWidth();
        int n2 = this.mShapeDrawerManager.getMeasuredHeight();
        Drawable drawable = this.getDrawable();
        if (drawable == null || (drawable = drawable.getCurrent()) == null) {
            drawable = this.getDrawable();
        }
        this.mBlurManager.onSizeChanged(n, n2, drawable);
        this.mShouldCheckRemoveProgress = false;
        this.blurBitmap(false);
        this.mShouldCheckRemoveProgress = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.initialized) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mShapeDrawerManager.onMeasure(widthSize, heightSize, widthMode, heightMode, (View)this);
        this.setMeasuredDimension(this.mShapeDrawerManager.getMeasuredWidth(), this.mShapeDrawerManager.getMeasuredHeight());
    }

    @Override
    public void onDrawableChanged$powerfulimageview_release() {
        if (!this.initialized) {
            return;
        }
        if (this.blurBitmap(true)) {
            return;
        }
        if (this.mShouldCheckRemoveProgress && this.getDrawable() != null) {
            Drawable drawable = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
            Drawable drawable2 = drawable.getCurrent();
            if (drawable2 == null) {
                Drawable drawable3 = this.getDrawable();
                drawable2 = drawable3;
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"drawable");
            }
            this.mProgressDrawerManager.changeDrawable(drawable2);
        }
        if (this.getDrawable() != null) {
            Drawable drawable = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
            Drawable drawable4 = drawable.getCurrent();
            if (drawable4 == null) {
                drawable4 = this.getDrawable();
            }
            this.mShapeDrawerManager.changeDrawable(drawable4);
        }
    }

    @Override
    public void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.setScaleType(scaleType);
        if (!this.initialized) {
            return;
        }
        this.mShapeDrawerManager.setScaleType(PivShapeScaleType.Companion.getFromScaleType(scaleType));
    }

    public final void setShapeScaleType(@NotNull PivShapeScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)scaleType), (String)"scaleType");
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.mShapeDrawerManager.setScaleType(scaleType);
    }

    @Override
    public void setImageMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        if (!this.initialized) {
            super.setImageMatrix(matrix);
            return;
        }
        super.setImageMatrix(matrix);
        this.mShapeDrawerManager.setImageMatrix(matrix);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.initialized) {
            super.onDraw(canvas);
            return;
        }
        this.mShapeDrawerManager.onDraw(canvas);
        this.mProgressDrawerManager.onDraw(canvas);
    }

    public final void setProgressMode(@NotNull PivProgressMode progressMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)progressMode), (String)"progressMode");
        this.mProgressDrawerManager.changeProgressMode(progressMode, false);
    }

    public final void setShapeMode(@NotNull PivShapeMode shapeMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shapeMode), (String)"shapeMode");
        this.mShapeDrawerManager.changeShapeMode(shapeMode);
    }

    public final void setBlurMode(@NotNull PivBlurMode blurMode, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blurMode), (String)"blurMode");
        this.mCheckBlur = blurMode != PivBlurMode.DISABLED;
        this.mBlurManager.changeMode(blurMode, radius);
        this.blurBitmap(false);
    }

    public final void setBlurRadius(int radius) {
        this.mCheckBlur = this.mBlurManager.getBlurMode() != PivBlurMode.DISABLED;
        this.mBlurManager.changeRadius(radius);
        this.blurBitmap(false);
    }

    private final boolean blurBitmap(boolean changeDrawable) {
        if (!this.mCheckBlur || this.getDrawable() == null) {
            return false;
        }
        Drawable drawable = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
        boolean shouldBlur = this.mBlurManager.shouldBlur(drawable.getCurrent(), changeDrawable);
        if (changeDrawable) {
            Drawable drawable2 = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
            this.mBlurManager.changeDrawable(drawable2.getCurrent());
        }
        Bitmap blurredBitmap = null;
        if (shouldBlur && (blurredBitmap = this.mBlurManager.getLastBlurredBitmap()) != null) {
            this.mCheckBlur = false;
            this.setImageBitmap(blurredBitmap);
            this.mCheckBlur = true;
        }
        return shouldBlur && blurredBitmap != null && !blurredBitmap.isRecycled();
    }

    public final void setProgressIndeterminate(boolean isIndeterminate) {
        this.mProgressDrawerManager.getProgressOptions().setIsIndeterminate(isIndeterminate);
    }

    @NotNull
    public final ProgressOptions getProgressOptions() {
        return this.mProgressDrawerManager.getProgressOptions();
    }

    public final float getProgress() {
        return this.mProgressDrawerManager.getProgressOptions().getValuePercent();
    }

    @NotNull
    public final PivProgressMode getProgressMode() {
        return this.mProgressDrawerManager.getProgressMode();
    }

    @NotNull
    public final PivShapeMode getShapeMode() {
        return this.mShapeDrawerManager.getShapeMode();
    }

    @NotNull
    public final PivBlurMode getBlurMode() {
        return this.mBlurManager.getBlurMode();
    }

    @NotNull
    public final ShapeOptions getShapeOptions() {
        return this.mShapeDrawerManager.getShapeOptions();
    }

    @NotNull
    public final BlurOptions getBlurOptions() {
        return this.mBlurManager.getBlurOptions();
    }

    public final int getBlurRadius() {
        return this.mBlurManager.getRadius();
    }

    @Nullable
    public final Bitmap getBlurBlurredBitmap() {
        return this.mBlurManager.getLastBlurredBitmap();
    }

    @Nullable
    public final Bitmap getBlurOriginalBitmap() {
        return this.mBlurManager.getOriginalBitmap();
    }

    public final void setProgressValue(float progress) {
        this.getProgressOptions().setValue(progress);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.initialized) {
            return;
        }
        this.mBlurManager.addContext(true);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.initialized) {
            return;
        }
        this.mBlurManager.removeContext(true);
    }

    public final void setPivProgressGravity(@NotNull PivProgressGravity progressGravity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)progressGravity), (String)"progressGravity");
        this.getProgressOptions().setGravity(progressGravity);
    }

    public final void setPivProgressMode(@NotNull PivProgressMode progressMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)progressMode), (String)"progressMode");
        this.setProgressMode(progressMode);
    }

    public final void setPivProgressIndeterminate(boolean progressIndeterminate) {
        this.getProgressOptions().setIsIndeterminate(progressIndeterminate);
    }

    public final void setPivProgressAnimationDuration(int duration) {
        this.getProgressOptions().setAnimationDuration(duration);
    }

    public final void setPivProgressValue(float progressValue) {
        if (this.getProgress() == 100.0f && progressValue != 100.0f && this.getProgressOptions().getDeterminateAnimationEnabled()) {
            this.getProgressOptions().setDeterminateAnimationEnabled(false);
            this.setProgressValue(0.0f);
            this.getProgressOptions().setDeterminateAnimationEnabled(true);
        }
        this.setProgressValue(progressValue);
    }

    public final void setPivProgressSize(int progressSize) {
        this.getProgressOptions().setSize(progressSize);
    }

    public final void setPivProgressSizePercent(float progressSize) {
        this.getProgressOptions().setSize(progressSize);
    }

    public final void setPivProgressPadding(int progressPadding) {
        this.getProgressOptions().setPadding(progressPadding);
    }

    public final void setPivProgressBorderWidth(int progressBorderWidth) {
        this.getProgressOptions().setBorderWidth(progressBorderWidth);
    }

    public final void setPivProgressBorderWidthPercent(float progressBorderWidth) {
        this.getProgressOptions().setBorderWidth(progressBorderWidth);
    }

    public final void setPivProgressShadowBorderWidth(float progressShadowBorderWidth) {
        this.getProgressOptions().setShadowBorderWidth(progressShadowBorderWidth);
    }

    public final void setPivProgressShadowPadding(int progressShadowPadding) {
        this.getProgressOptions().setShadowPadding(progressShadowPadding);
    }

    public final void setPivProgressShadowPaddingPercent(float progressShadowPadding) {
        this.getProgressOptions().setShadowPadding(progressShadowPadding);
    }

    public final void setPivProgressShadowEnabled(boolean progressShadowEnabled) {
        this.getProgressOptions().setShadowEnabled(progressShadowEnabled);
    }

    public final void setPivProgressDeterminateAnimationEnabled(boolean progressDeterminateAnimationEnabled) {
        this.getProgressOptions().setDeterminateAnimationEnabled(progressDeterminateAnimationEnabled);
    }

    public final void setPivProgressRtlDisabled(boolean progressRtlDisabled) {
        this.getProgressOptions().setRtlDisabled(progressRtlDisabled);
    }

    public final void setPivProgressDrawWedge(boolean progressDrawWedge) {
        this.getProgressOptions().setDrawWedge(progressDrawWedge);
    }

    public final void setPivProgressReversed(boolean progressReversed) {
        this.getProgressOptions().setProgressReversed(progressReversed);
    }

    public final void setPivProgressRemovedOnChange(boolean progressRemovedOnChange) {
        this.getProgressOptions().setRemovedOnChange(progressRemovedOnChange);
    }

    public final void setPivProgressFrontColor(int progressFrontColor) {
        this.getProgressOptions().setFrontColor(progressFrontColor);
    }

    public final void setPivProgressBackColor(int progressBackColor) {
        this.getProgressOptions().setBackColor(progressBackColor);
    }

    public final void setPivProgressIndeterminateColor(int progressIndeterminateColor) {
        this.getProgressOptions().setIndeterminateColor(progressIndeterminateColor);
    }

    public final void setPivProgressShadowColor(int progressShadowColor) {
        this.getProgressOptions().setShadowColor(progressShadowColor);
    }

    public final void setPivProgressShadowBorderColor(int progressShadowBorderColor) {
        this.getProgressOptions().setShadowBorderColor(progressShadowBorderColor);
    }

    public final void setPivShapeMode(@NotNull PivShapeMode shapeMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shapeMode), (String)"shapeMode");
        this.setShapeMode(shapeMode);
    }

    public final void setPivShapeScaleType(@NotNull PivShapeScaleType shapeScaleType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shapeScaleType), (String)"shapeScaleType");
        this.setShapeScaleType(shapeScaleType);
    }

    public final void setPivShapeInnerPadding(int shapeInnerPadding) {
        this.getShapeOptions().setInnerPadding(shapeInnerPadding);
    }

    public final void setPivShapeInnerPaddingPercent(float shapeInnerPadding) {
        this.getShapeOptions().setInnerPadding(shapeInnerPadding);
    }

    public final void setPivShapeBorderWidth(int shapeBorderWidth) {
        this.getShapeOptions().setBorderWidth(shapeBorderWidth);
    }

    public final void setPivShapeRatio(float shapeRatio) {
        this.getShapeOptions().setRatio(shapeRatio);
    }

    public final void setPivShapeRadiusX(float shapeRadiusX) {
        this.getShapeOptions().setRadiusX(shapeRadiusX);
    }

    public final void setPivShapeRadiusY(float shapeRadiusY) {
        this.getShapeOptions().setRadiusY(shapeRadiusY);
    }

    public final void setPivShapeBorderOverlay(boolean shapeBorderOverlay) {
        this.getShapeOptions().setBorderOverlay(shapeBorderOverlay);
    }

    public final void setPivShapeSolidColor(int shapeSolidColor) {
        this.getShapeOptions().setSolidColor(shapeSolidColor);
    }

    public final void setPivShapeBackgroundColor(int shapeBackgroundColor) {
        this.getShapeOptions().setBackgroundColor(shapeBackgroundColor);
    }

    public final void setPivShapeForegroundColor(int shapeForegroundColor) {
        this.getShapeOptions().setForegroundColor(shapeForegroundColor);
    }

    public final void setPivShapeBackground(@NotNull Drawable shapeBackground) {
        Intrinsics.checkParameterIsNotNull((Object)shapeBackground, (String)"shapeBackground");
        this.getShapeOptions().setBackgroundDrawable(shapeBackground);
    }

    public final void setPivShapeForeground(@NotNull Drawable shapeForeground) {
        Intrinsics.checkParameterIsNotNull((Object)shapeForeground, (String)"shapeForeground");
        this.getShapeOptions().setForegroundDrawable(shapeForeground);
    }

    public final void setPivShapeBorderColor(int shapeBorderColor) {
        this.getShapeOptions().setBorderColor(shapeBorderColor);
    }

    public final void setPivBlurMode(@NotNull PivBlurMode blurMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blurMode), (String)"blurMode");
        this.setBlurMode(blurMode, this.getBlurRadius());
    }

    public final void setPivBlurRadius(int blurRadius) {
        this.setBlurRadius(blurRadius);
    }

    public final void setPivBlurDownSamplingRate(int blurDownSamplingRate) {
        this.getBlurOptions().setDownSamplingRate(blurDownSamplingRate);
    }

    public final void setPivBlurStatic(boolean blurStatic) {
        this.getBlurOptions().setStaticBlur(blurStatic);
    }

    public final void setPivBlurUseRsFallback(boolean blurUseRsFallback) {
        this.getBlurOptions().setUseRsFallback(blurUseRsFallback);
    }

    public final void setPivBlurNumThreads(int blurNumThreads) {
        this.getBlurOptions().setNumThreads(blurNumThreads);
    }

    public PowerfulImageView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public PowerfulImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public PowerfulImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
        this.DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
        this.DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION = 600;
        this.DEFAULT_PROGRESS_WIDTH = -1;
        this.DEFAULT_PROGRESS_WIDTH_PERCENT = 10.0f;
        this.DEFAULT_PROGRESS_SIZE = -1;
        this.DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
        this.DEFAULT_PROGRESS_PADDING = 2;
        this.DEFAULT_PROGRESS_GRAVITY = PivProgressGravity.CENTER.getValue();
        this.DEFAULT_PROGRESS_INDETERMINATE = true;
        this.DEFAULT_PROGRESS_SHADOW_ENABLED = true;
        this.DEFAULT_PROGRESS_REMOVED_ON_CHANGE = true;
        this.DEFAULT_PROGRESS_MODE = PivProgressMode.NONE.getValue();
        this.DEFAULT_PROGRESS_SHADOW_PADDING = -1;
        this.DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH = 1;
        this.DEFAULT_SHAPE_MODE = PivShapeMode.NORMAL.getValue$powerfulimageview_release();
        this.DEFAULT_SHAPE_CUT_GRAVITY = PivShapeCutGravity.BOTTOM.getValue();
        this.DEFAULT_SHAPE_INNER_PADDING = -1;
        this.DEFAULT_SHAPE_RADIUS_X = 1.0f;
        this.DEFAULT_SHAPE_RADIUS_Y = 1.0f;
        this.DEFAULT_SHAPE_CUT_RADIUS_1_PERCENT = 25.0f;
        this.DEFAULT_SHAPE_CUT_RADIUS_2_PERCENT = 100.0f;
        this.DEFAULT_BLUR_DOWNSAMPLING_RATE = 4.0f;
        this.DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK = true;
        this.DEFAULT_BLUR_MODE = PivBlurMode.DISABLED.getValue();
        this.mShouldCheckRemoveProgress = true;
        this.initialized = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PowerfulImageView, defStyleAttr, 0);
        TypedValue tvSize = new TypedValue();
        TypedValue tvBorderWidth = new TypedValue();
        TypedValue tvShadowPadding = new TypedValue();
        TypedValue tvCutRadius1 = new TypedValue();
        TypedValue tvCutRadius2 = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_pivProgressSize, tvSize);
        a.getValue(R.styleable.PowerfulImageView_pivProgressBorderWidth, tvBorderWidth);
        a.getValue(R.styleable.PowerfulImageView_pivProgressShadowPadding, tvShadowPadding);
        a.getValue(R.styleable.PowerfulImageView_pivShapeCutRadius1, tvCutRadius1);
        a.getValue(R.styleable.PowerfulImageView_pivShapeCutRadius2, tvCutRadius2);
        PivProgressMode progressMode = PivProgressMode.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_pivProgressMode, this.DEFAULT_PROGRESS_MODE));
        boolean useDeterminateAnimation = a.getBoolean(R.styleable.PowerfulImageView_pivProgressDeterminateAnimationEnabled, this.DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION);
        boolean bl = this.isInEditMode() ? false : useDeterminateAnimation;
        int n7 = a.getInt(R.styleable.PowerfulImageView_pivProgressAnimationDuration, useDeterminateAnimation ? this.DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION : this.DEFAULT_PROGRESS_ANIMATION_DURATION);
        if (tvBorderWidth.type == 5) {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            n6 = (int)tvBorderWidth.getDimension(resources.getDisplayMetrics());
        } else {
            n6 = this.DEFAULT_PROGRESS_WIDTH;
        }
        float f = tvBorderWidth.type == 6 ? tvBorderWidth.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_WIDTH_PERCENT;
        if (tvSize.type == 5) {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            n5 = (int)tvSize.getDimension(resources.getDisplayMetrics());
        } else {
            n5 = this.DEFAULT_PROGRESS_SIZE;
        }
        float f2 = tvSize.type == 6 ? tvSize.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_SIZE_PERCENT;
        float f3 = this.DEFAULT_PROGRESS_PADDING;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        int n8 = a.getDimensionPixelSize(R.styleable.PowerfulImageView_pivProgressPadding, (int)TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)resources.getDisplayMetrics()));
        float f4 = a.getFloat(R.styleable.PowerfulImageView_pivProgressValue, (float)this.DEFAULT_PROGRESS_VALUE);
        TypedArray typedArray = a;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
        int n9 = this.getColor(typedArray, R.styleable.PowerfulImageView_pivProgressFrontColor, R.color.piv_default_progress_front_color);
        int n10 = this.getColor(a, R.styleable.PowerfulImageView_pivProgressBackColor, R.color.piv_default_progress_back_color);
        int n11 = this.getColor(a, R.styleable.PowerfulImageView_pivProgressIndeterminateColor, R.color.piv_default_progress_indeterminate_color);
        int n12 = a.getInteger(R.styleable.PowerfulImageView_pivProgressGravity, this.DEFAULT_PROGRESS_GRAVITY);
        boolean bl2 = Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1;
        boolean bl3 = a.getBoolean(R.styleable.PowerfulImageView_pivProgressRtlDisabled, this.DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT);
        boolean bl4 = a.getBoolean(R.styleable.PowerfulImageView_pivProgressIndeterminate, this.DEFAULT_PROGRESS_INDETERMINATE);
        boolean bl5 = a.getBoolean(R.styleable.PowerfulImageView_pivProgressDrawWedge, this.DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE);
        boolean bl6 = a.getBoolean(R.styleable.PowerfulImageView_pivProgressShadowEnabled, this.DEFAULT_PROGRESS_SHADOW_ENABLED);
        int n13 = this.getColor(a, R.styleable.PowerfulImageView_pivProgressShadowColor, R.color.piv_default_progress_shadow_color);
        if (tvShadowPadding.type == 5) {
            Resources resources2 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
            n4 = (int)tvShadowPadding.getDimension(resources2.getDisplayMetrics());
        } else {
            n4 = this.DEFAULT_PROGRESS_SHADOW_PADDING;
        }
        float f5 = tvShadowPadding.type == 6 ? tvShadowPadding.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT;
        float f6 = this.DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH;
        Resources resources3 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources3, (String)"resources");
        ProgressOptions progressOptions = new ProgressOptions(bl, n7, n6, f, n5, f2, n8, f4, n9, n10, n11, n12, bl2, bl3, bl4, bl5, bl6, n13, n4, f5, a.getDimensionPixelSize(R.styleable.PowerfulImageView_pivProgressShadowBorderWidth, (int)TypedValue.applyDimension((int)1, (float)f6, (DisplayMetrics)resources3.getDisplayMetrics())), this.getColor(a, R.styleable.PowerfulImageView_pivProgressShadowBorderColor, R.color.piv_default_progress_shadow_border_color), a.getBoolean(R.styleable.PowerfulImageView_pivProgressReversed, this.DEFAULT_PROGRESS_REVERSED), a.getBoolean(R.styleable.PowerfulImageView_pivProgressRemovedOnChange, this.DEFAULT_PROGRESS_REMOVED_ON_CHANGE));
        TypedValue tvShapeInnerPadding = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_pivShapeInnerPadding, tvShapeInnerPadding);
        int n14 = this.getColor(a, R.styleable.PowerfulImageView_pivShapeBackgroundColor, 17170445);
        int n15 = this.getColor(a, R.styleable.PowerfulImageView_pivShapeForegroundColor, 17170445);
        if (tvShapeInnerPadding.type == 5) {
            Resources resources4 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources4, (String)"resources");
            n3 = (int)tvShapeInnerPadding.getDimension(resources4.getDisplayMetrics());
        } else {
            n3 = this.DEFAULT_SHAPE_INNER_PADDING;
        }
        float f7 = tvShapeInnerPadding.type == 6 ? tvShapeInnerPadding.getFraction(100.0f, 100.0f) : this.DEFAULT_SHAPE_INNER_PADDING_PERCENT;
        boolean bl7 = a.getBoolean(R.styleable.PowerfulImageView_pivShapeBorderOverlay, this.DEFAULT_SHAPE_BORDER_OVERLAY);
        int n16 = a.getInteger(R.styleable.PowerfulImageView_pivShapeCutGravity, this.DEFAULT_SHAPE_CUT_GRAVITY);
        int n17 = this.getColor(a, R.styleable.PowerfulImageView_pivShapeBorderColor, 17170445);
        float f8 = this.DEFAULT_SHAPE_BORDER_WIDTH;
        Resources resources5 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources5, (String)"resources");
        int n18 = a.getDimensionPixelSize(R.styleable.PowerfulImageView_pivShapeBorderWidth, (int)TypedValue.applyDimension((int)1, (float)f8, (DisplayMetrics)resources5.getDisplayMetrics()));
        float f9 = a.getFloat(R.styleable.PowerfulImageView_pivShapeRatio, this.DEFAULT_SHAPE_RATIO);
        float f10 = a.getFloat(R.styleable.PowerfulImageView_pivShapeRadiusX, this.DEFAULT_SHAPE_RADIUS_X);
        float f11 = a.getFloat(R.styleable.PowerfulImageView_pivShapeRadiusY, this.DEFAULT_SHAPE_RADIUS_Y);
        int n19 = this.getColor(a, R.styleable.PowerfulImageView_pivShapeSolidColor, R.color.piv_default_shape_solid_color);
        Drawable drawable = a.getDrawable(R.styleable.PowerfulImageView_pivShapeBackground);
        Drawable drawable2 = a.getDrawable(R.styleable.PowerfulImageView_pivShapeForeground);
        if (tvCutRadius1.type == 5) {
            Resources resources6 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources6, (String)"resources");
            n2 = (int)tvCutRadius1.getDimension(resources6.getDisplayMetrics());
        } else {
            n2 = this.DEFAULT_SHAPE_CUT_RADIUS_1;
        }
        float f12 = tvCutRadius1.type == 6 ? tvCutRadius1.getFraction(100.0f, 100.0f) : this.DEFAULT_SHAPE_CUT_RADIUS_1_PERCENT;
        if (tvCutRadius2.type == 5) {
            Resources resources7 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources7, (String)"resources");
            n = (int)tvCutRadius2.getDimension(resources7.getDisplayMetrics());
        } else {
            n = this.DEFAULT_SHAPE_CUT_RADIUS_2;
        }
        ShapeOptions shapeOptions = new ShapeOptions(n14, n15, n3, f7, bl7, n16, n17, n18, f9, f10, f11, n19, drawable, drawable2, n2, f12, n, tvCutRadius2.type == 6 ? tvCutRadius2.getFraction(100.0f, 100.0f) : this.DEFAULT_SHAPE_CUT_RADIUS_2_PERCENT);
        PivShapeMode shapeMode = PivShapeMode.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_pivShapeMode, this.DEFAULT_SHAPE_MODE));
        PivShapeScaleType scaleType = PivShapeScaleType.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_pivShapeScaleType, PivShapeScaleType.Companion.getFromScaleType(this.getScaleType()).getValue$powerfulimageview_release()));
        BlurOptions blurOptions = new BlurOptions(a.getFloat(R.styleable.PowerfulImageView_pivBlurDownSamplingRate, this.DEFAULT_BLUR_DOWNSAMPLING_RATE), a.getBoolean(R.styleable.PowerfulImageView_pivBlurStatic, this.DEFAULT_BLUR_STATIC), a.getBoolean(R.styleable.PowerfulImageView_pivBlurUseRsFallback, this.DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK), a.getInteger(R.styleable.PowerfulImageView_pivBlurNumThreads, this.DEFAULT_BLUR_NUM_THREADS));
        int blurRadius = a.getInteger(R.styleable.PowerfulImageView_pivBlurRadius, this.DEFAULT_BLUR_RADIUS);
        int blurModeValue = a.getInteger(R.styleable.PowerfulImageView_pivBlurMode, this.DEFAULT_BLUR_MODE);
        PivBlurMode blurMode = PivBlurMode.Companion.fromValue(blurModeValue);
        a.recycle();
        this.mProgressDrawerManager = new ProgressDrawerManager((View)this, progressOptions);
        this.mShapeDrawerManager = new ShapeDrawerManager((View)this, shapeOptions);
        this.mBlurManager = new BlurManager((ImageView)this, blurOptions);
        this.mShapeDrawerManager.setScaleType(scaleType);
        this.mShouldCheckRemoveProgress = false;
        this.onDrawableChanged$powerfulimageview_release();
        this.setProgressMode(progressMode);
        this.setShapeMode(shapeMode);
        this.setBlurMode(blurMode, blurRadius);
        this.mShouldCheckRemoveProgress = true;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

