/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.shape.drawers;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerful_libraries.imageview.progress.PivShapeCutGravity;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.BaseNormalShapeDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0014J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bH\u0014J(\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/SolidDiagonalShapeDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/BaseNormalShapeDrawer;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "mSolidBounds", "Landroid/graphics/RectF;", "mSolidPaint", "Landroid/graphics/Paint;", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "shapeBounds", "imageBounds", "borderPaint", "drawPaint", "paint", "drawSolid", "setup", "shapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "powerfulimageview_release"})
public final class SolidDiagonalShapeDrawer
extends BaseNormalShapeDrawer {
    private final Paint mSolidPaint = new Paint();
    private RectF mSolidBounds = new RectF();

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        float f;
        boolean bl;
        float cat1;
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        super.setup(shapeOptions);
        this.mSolidPaint.setColor(shapeOptions.getSolidColor());
        this.mSolidPaint.setAntiAlias(true);
        this.mSolidPaint.setStyle(Paint.Style.FILL);
        this.mSolidPaint.setStrokeWidth(shapeOptions.getShapeBounds().height() * 0.75f);
        RectF b = shapeOptions.getShapeBounds();
        float f2 = cat1 = shapeOptions.getCutRadius1() != 0 ? (float)shapeOptions.getCutRadius1() : shapeOptions.getCutRadius1Percent() / 100.0f * b.height();
        if (shapeOptions.getCutRadius2() != 0) {
            int n = shapeOptions.getCutRadius2();
            bl = false;
            f = Math.abs(n);
        } else {
            float f3 = shapeOptions.getCutRadius2Percent();
            bl = false;
            f = Math.abs(f3) / 100.0f * b.width();
        }
        float cat2 = f;
        double hypo = Math.sqrt(cat1 * cat1 + cat2 * cat2);
        double angle = Math.acos((double)cat1 / hypo);
        float h = (float)((double)(this.mSolidPaint.getStrokeWidth() / 2.0f) * Math.sin(angle));
        float w = (float)((double)(this.mSolidPaint.getStrokeWidth() / 2.0f) * Math.cos(angle));
        if (shapeOptions.getCutGravity().isGravityTop$powerfulimageview_release() || shapeOptions.getCutGravity() == PivShapeCutGravity.END) {
            this.mSolidBounds.left = b.left - (cat1 >= 0.0f ? cat2 - w - b.width() : -w);
            this.mSolidBounds.top = b.top - h - RangesKt.coerceAtMost((float)cat1, (float)0.0f);
            this.mSolidBounds.right = b.right - (cat1 >= 0.0f ? -w : b.width() - cat2 - w);
            this.mSolidBounds.bottom = b.top + RangesKt.coerceAtLeast((float)cat1, (float)0.0f) - h;
        } else {
            this.mSolidBounds.left = b.left - (cat1 >= 0.0f ? cat2 - w - b.width() : -w);
            this.mSolidBounds.top = b.bottom + h + RangesKt.coerceAtMost((float)cat1, (float)0.0f);
            this.mSolidBounds.right = b.right - (cat1 >= 0.0f ? -w : b.width() - cat2 - w);
            this.mSolidBounds.bottom = b.bottom - RangesKt.coerceAtLeast((float)cat1, (float)0.0f) + h;
        }
    }

    @Override
    protected void drawPaint(@NotNull Canvas canvas, @NotNull RectF shapeBounds, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.drawRect(shapeBounds, paint);
    }

    @Override
    protected void drawBorder(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds, @NotNull Paint borderPaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        Intrinsics.checkParameterIsNotNull((Object)borderPaint, (String)"borderPaint");
        canvas.drawRect(borderBounds, borderPaint);
    }

    @Override
    protected void drawSolid(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        canvas.drawLine(this.mSolidBounds.left, this.mSolidBounds.top, this.mSolidBounds.right, this.mSolidBounds.bottom, this.mSolidPaint);
    }

    public SolidDiagonalShapeDrawer(@Nullable Drawable drawable) {
        super(drawable);
    }
}

