/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.blur.algorithms;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.widget.ImageView;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerful_libraries.imageview.blur.PivBlurMode;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurManager;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurManager$WhenMappings;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.Box3x3BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.Box5x5BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.DummyBlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.Gaussian3x3BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.Gaussian5x5BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.GaussianBlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.RenderscriptException;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.SharedBlurManager;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.StackBlurAlgorithm;
import java.lang.ref.WeakReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020?J\u000e\u0010S\u001a\u00020Q2\u0006\u0010T\u001a\u00020=J\u0010\u0010U\u001a\u00020Q2\b\u0010V\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010W\u001a\u00020Q2\u0006\u0010X\u001a\u00020E2\u0006\u0010T\u001a\u00020=J\u000e\u0010Y\u001a\u00020Q2\u0006\u0010T\u001a\u00020=J\u0006\u0010Z\u001a\u00020EJ\u0006\u0010[\u001a\u00020\u0005J\b\u0010\\\u001a\u0004\u0018\u00010\u000bJ\b\u0010]\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010^\u001a\u0004\u0018\u00010\u000b2\b\u0010_\u001a\u0004\u0018\u00010\u001e2\b\u0010V\u001a\u0004\u0018\u00010\u001eH\u0002J\u0006\u0010`\u001a\u00020=J\b\u0010a\u001a\u00020QH\u0016J \u0010b\u001a\u00020Q2\u0006\u0010c\u001a\u00020=2\u0006\u0010d\u001a\u00020=2\b\u0010V\u001a\u0004\u0018\u00010\u001eJ\b\u0010e\u001a\u00020QH\u0016J\u000e\u0010f\u001a\u00020Q2\u0006\u0010R\u001a\u00020?J\u0010\u0010g\u001a\u00020Q2\b\u0010h\u001a\u0004\u0018\u00010iJ\u0006\u0010j\u001a\u00020iJ\u0018\u0010k\u001a\u00020?2\b\u0010V\u001a\u0004\u0018\u00010\u001e2\u0006\u0010l\u001a\u00020?J\u0012\u0010m\u001a\u00020Q2\b\u0010X\u001a\u0004\u0018\u00010EH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001b\u0010\u0018R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0011\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0011\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0011\u001a\u0004\b*\u0010'R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0011\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0011\u001a\u0004\b2\u0010/R\u001b\u00104\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u0011\u001a\u0004\b6\u00107R\u001b\u00109\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u0011\u001a\u0004\b:\u00107R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010H\u001a\u00020I8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\u0011\u001a\u0004\bJ\u0010KR\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurManager;", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions$BlurOptionsListener;", "view", "Landroid/widget/ImageView;", "blurOptions", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;", "(Landroid/widget/ImageView;Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;)V", "mBlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurAlgorithm;", "mBlurOptions", "mBlurredBitmap", "Landroid/graphics/Bitmap;", "mBox3x3BlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box3x3BlurAlgorithm;", "getMBox3x3BlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box3x3BlurAlgorithm;", "mBox3x3BlurAlgorithm$delegate", "Lkotlin/Lazy;", "mBox3x3RenderscriptBlurAlgorithm", "getMBox3x3RenderscriptBlurAlgorithm", "mBox3x3RenderscriptBlurAlgorithm$delegate", "mBox5x5BlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box5x5BlurAlgorithm;", "getMBox5x5BlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box5x5BlurAlgorithm;", "mBox5x5BlurAlgorithm$delegate", "mBox5x5RenderscriptBlurAlgorithm", "getMBox5x5RenderscriptBlurAlgorithm", "mBox5x5RenderscriptBlurAlgorithm$delegate", "mDrawable", "Landroid/graphics/drawable/Drawable;", "mDummyBlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/DummyBlurAlgorithm;", "getMDummyBlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/DummyBlurAlgorithm;", "mDummyBlurAlgorithm$delegate", "mGaussian3x3BlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian3x3BlurAlgorithm;", "getMGaussian3x3BlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian3x3BlurAlgorithm;", "mGaussian3x3BlurAlgorithm$delegate", "mGaussian3x3RenderscriptBlurAlgorithm", "getMGaussian3x3RenderscriptBlurAlgorithm", "mGaussian3x3RenderscriptBlurAlgorithm$delegate", "mGaussian5x5BlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian5x5BlurAlgorithm;", "getMGaussian5x5BlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian5x5BlurAlgorithm;", "mGaussian5x5BlurAlgorithm$delegate", "mGaussian5x5RenderscriptBlurAlgorithm", "getMGaussian5x5RenderscriptBlurAlgorithm", "mGaussian5x5RenderscriptBlurAlgorithm$delegate", "mGaussianBlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/GaussianBlurAlgorithm;", "getMGaussianBlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/GaussianBlurAlgorithm;", "mGaussianBlurAlgorithm$delegate", "mGaussianRenderscriptBlurAlgorithm", "getMGaussianRenderscriptBlurAlgorithm", "mGaussianRenderscriptBlurAlgorithm$delegate", "mHeight", "", "mIsAlreadyBlurred", "", "mIsRenderscriptManaged", "mLastRadius", "mLastSizeX", "mLastSizeY", "mMode", "Lcom/stefanosiano/powerful_libraries/imageview/blur/PivBlurMode;", "mOriginalBitmap", "mRadius", "mStackBlurAlgorithm", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/StackBlurAlgorithm;", "getMStackBlurAlgorithm", "()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/StackBlurAlgorithm;", "mStackBlurAlgorithm$delegate", "mView", "Ljava/lang/ref/WeakReference;", "mWidth", "addContext", "", "fromView", "blur", "radius", "changeDrawable", "drawable", "changeMode", "blurMode", "changeRadius", "getBlurMode", "getBlurOptions", "getLastBlurredBitmap", "getOriginalBitmap", "getOriginalBitmapFromDrawable", "mLastDrawable", "getRadius", "onDownsamplingRateChanged", "onSizeChanged", "width", "height", "onStaticBlurChanged", "removeContext", "restoreInstanceState", "state", "Landroid/os/Bundle;", "saveInstanceState", "shouldBlur", "checkDrawable", "updateAlgorithms", "powerfulimageview_release"})
public final class BlurManager
implements BlurOptions.BlurOptionsListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Drawable mDrawable;
    private Bitmap mOriginalBitmap;
    private Bitmap mBlurredBitmap;
    private BlurOptions mBlurOptions;
    private PivBlurMode mMode;
    private int mRadius;
    private boolean mIsRenderscriptManaged;
    private boolean mIsAlreadyBlurred;
    private int mWidth;
    private int mHeight;
    private int mLastSizeX;
    private int mLastSizeY;
    private int mLastRadius;
    private WeakReference<ImageView> mView;
    private final Lazy mBox3x3BlurAlgorithm$delegate;
    private final Lazy mBox3x3RenderscriptBlurAlgorithm$delegate;
    private final Lazy mBox5x5BlurAlgorithm$delegate;
    private final Lazy mBox5x5RenderscriptBlurAlgorithm$delegate;
    private final Lazy mGaussian5x5BlurAlgorithm$delegate;
    private final Lazy mGaussian5x5RenderscriptBlurAlgorithm$delegate;
    private final Lazy mGaussian3x3BlurAlgorithm$delegate;
    private final Lazy mGaussian3x3RenderscriptBlurAlgorithm$delegate;
    private final Lazy mGaussianBlurAlgorithm$delegate;
    private final Lazy mGaussianRenderscriptBlurAlgorithm$delegate;
    private final Lazy mStackBlurAlgorithm$delegate;
    private final Lazy mDummyBlurAlgorithm$delegate;
    private BlurAlgorithm mBlurAlgorithm;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mBox3x3BlurAlgorithm", "getMBox3x3BlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box3x3BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mBox3x3RenderscriptBlurAlgorithm", "getMBox3x3RenderscriptBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box3x3BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mBox5x5BlurAlgorithm", "getMBox5x5BlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box5x5BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mBox5x5RenderscriptBlurAlgorithm", "getMBox5x5RenderscriptBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Box5x5BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussian5x5BlurAlgorithm", "getMGaussian5x5BlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian5x5BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussian5x5RenderscriptBlurAlgorithm", "getMGaussian5x5RenderscriptBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian5x5BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussian3x3BlurAlgorithm", "getMGaussian3x3BlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian3x3BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussian3x3RenderscriptBlurAlgorithm", "getMGaussian3x3RenderscriptBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/Gaussian3x3BlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussianBlurAlgorithm", "getMGaussianBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/GaussianBlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mGaussianRenderscriptBlurAlgorithm", "getMGaussianRenderscriptBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/GaussianBlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mStackBlurAlgorithm", "getMStackBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/StackBlurAlgorithm;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BlurManager.class), "mDummyBlurAlgorithm", "getMDummyBlurAlgorithm()Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/DummyBlurAlgorithm;"))};
    }

    private final Box3x3BlurAlgorithm getMBox3x3BlurAlgorithm() {
        Lazy lazy = this.mBox3x3BlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Box3x3BlurAlgorithm)lazy.getValue();
    }

    private final Box3x3BlurAlgorithm getMBox3x3RenderscriptBlurAlgorithm() {
        Lazy lazy = this.mBox3x3RenderscriptBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (Box3x3BlurAlgorithm)lazy.getValue();
    }

    private final Box5x5BlurAlgorithm getMBox5x5BlurAlgorithm() {
        Lazy lazy = this.mBox5x5BlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (Box5x5BlurAlgorithm)lazy.getValue();
    }

    private final Box5x5BlurAlgorithm getMBox5x5RenderscriptBlurAlgorithm() {
        Lazy lazy = this.mBox5x5RenderscriptBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[3];
        boolean bl = false;
        return (Box5x5BlurAlgorithm)lazy.getValue();
    }

    private final Gaussian5x5BlurAlgorithm getMGaussian5x5BlurAlgorithm() {
        Lazy lazy = this.mGaussian5x5BlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[4];
        boolean bl = false;
        return (Gaussian5x5BlurAlgorithm)lazy.getValue();
    }

    private final Gaussian5x5BlurAlgorithm getMGaussian5x5RenderscriptBlurAlgorithm() {
        Lazy lazy = this.mGaussian5x5RenderscriptBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[5];
        boolean bl = false;
        return (Gaussian5x5BlurAlgorithm)lazy.getValue();
    }

    private final Gaussian3x3BlurAlgorithm getMGaussian3x3BlurAlgorithm() {
        Lazy lazy = this.mGaussian3x3BlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[6];
        boolean bl = false;
        return (Gaussian3x3BlurAlgorithm)lazy.getValue();
    }

    private final Gaussian3x3BlurAlgorithm getMGaussian3x3RenderscriptBlurAlgorithm() {
        Lazy lazy = this.mGaussian3x3RenderscriptBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[7];
        boolean bl = false;
        return (Gaussian3x3BlurAlgorithm)lazy.getValue();
    }

    private final GaussianBlurAlgorithm getMGaussianBlurAlgorithm() {
        Lazy lazy = this.mGaussianBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[8];
        boolean bl = false;
        return (GaussianBlurAlgorithm)lazy.getValue();
    }

    private final GaussianBlurAlgorithm getMGaussianRenderscriptBlurAlgorithm() {
        Lazy lazy = this.mGaussianRenderscriptBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[9];
        boolean bl = false;
        return (GaussianBlurAlgorithm)lazy.getValue();
    }

    private final StackBlurAlgorithm getMStackBlurAlgorithm() {
        Lazy lazy = this.mStackBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[10];
        boolean bl = false;
        return (StackBlurAlgorithm)lazy.getValue();
    }

    private final DummyBlurAlgorithm getMDummyBlurAlgorithm() {
        Lazy lazy = this.mDummyBlurAlgorithm$delegate;
        BlurManager blurManager = this;
        KProperty kProperty = $$delegatedProperties[11];
        boolean bl = false;
        return (DummyBlurAlgorithm)lazy.getValue();
    }

    public final void changeDrawable(@Nullable Drawable drawable) {
        if (Intrinsics.areEqual((Object)drawable, (Object)this.mDrawable)) {
            return;
        }
        if (!this.shouldBlur(drawable, true)) {
            return;
        }
        Drawable mLastDrawable = this.mDrawable;
        Bitmap lastOriginalBitmap = this.mOriginalBitmap;
        this.mDrawable = drawable;
        this.mOriginalBitmap = this.getOriginalBitmapFromDrawable(mLastDrawable, drawable);
        if (Intrinsics.areEqual((Object)lastOriginalBitmap, (Object)this.mOriginalBitmap) ^ true) {
            this.mIsAlreadyBlurred = false;
            Bitmap bitmap = lastOriginalBitmap;
            if (bitmap != null) {
                bitmap.recycle();
            }
            this.mLastRadius = -1;
        }
    }

    public final void changeMode(@NotNull PivBlurMode blurMode, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blurMode), (String)"blurMode");
        if (blurMode == this.mMode && radius == this.mRadius) {
            return;
        }
        this.removeContext(true);
        this.mMode = blurMode;
        this.addContext(true);
        this.updateAlgorithms(blurMode);
        this.mLastRadius = -1;
        this.mRadius = radius;
    }

    public final void changeRadius(int radius) {
        this.changeMode(this.mMode, radius);
    }

    public final void blur(int radius) {
        Bitmap bitmap;
        Bitmap bitmap2;
        this.mRadius = radius;
        Bitmap bitmap3 = this.mOriginalBitmap;
        if (bitmap3 == null) {
            return;
        }
        Bitmap origBitmap = bitmap3;
        if (origBitmap.isRecycled()) {
            return;
        }
        if (this.mLastRadius == radius && this.mBlurredBitmap != null) {
            return;
        }
        if (this.mIsAlreadyBlurred && this.mBlurOptions.isStaticBlur()) {
            return;
        }
        this.mLastRadius = radius;
        if (this.mBlurredBitmap != null && Intrinsics.areEqual((Object)origBitmap, (Object)this.mBlurredBitmap) ^ true) {
            Bitmap bitmap4 = this.mBlurredBitmap;
            if (bitmap4 != null) {
                bitmap4.recycle();
            }
        }
        Bitmap bitmap5 = null;
        this.addContext(false);
        try {
            bitmap5 = radius == 0 ? origBitmap : this.mBlurAlgorithm.blur(origBitmap, this.mRadius, this.mBlurOptions);
            this.mIsAlreadyBlurred = true;
        }
        catch (RenderscriptException e) {
            PivBlurMode pivBlurMode;
            if (this.mBlurOptions.getUseRsFallback()) {
                pivBlurMode = this.mMode.getFallbackMode();
                if (pivBlurMode == null) {
                    pivBlurMode = PivBlurMode.DISABLED;
                }
            } else {
                pivBlurMode = PivBlurMode.DISABLED;
            }
            this.mMode = pivBlurMode;
            Log.w((String)BlurManager.class.getSimpleName(), (String)(e.getLocalizedMessage() + "\nFalling back to another blurring method: " + this.mMode.name()));
            this.updateAlgorithms(this.mMode);
            try {
                bitmap5 = this.mBlurAlgorithm.blur(origBitmap, this.mRadius, this.mBlurOptions);
                this.mIsAlreadyBlurred = true;
            }
            catch (RenderscriptException e1) {
                bitmap5 = null;
            }
        }
        this.removeContext(false);
        if (this.mBlurOptions.isStaticBlur() && (bitmap2 = bitmap5) == null) {
            bitmap2 = this.mOriginalBitmap = origBitmap;
        }
        if ((bitmap = bitmap5) == null) {
            bitmap = this.mBlurredBitmap;
        }
        this.mBlurredBitmap = bitmap;
    }

    public final void onSizeChanged(int width, int height, @Nullable Drawable drawable) {
        this.mWidth = width;
        this.mHeight = height;
        if (drawable != null) {
            this.changeDrawable(drawable);
        }
    }

    private final void updateAlgorithms(PivBlurMode blurMode) {
        BlurAlgorithm blurAlgorithm;
        Object renderScript = SharedBlurManager.INSTANCE.getRenderScriptContext();
        PivBlurMode pivBlurMode = blurMode;
        if (pivBlurMode == null) {
            pivBlurMode = this.mMode = PivBlurMode.DISABLED;
        }
        if (this.mMode.getUsesRenderscript() && renderScript == null) {
            this.updateAlgorithms(this.mBlurOptions.getUseRsFallback() ? this.mMode.getFallbackMode() : PivBlurMode.DISABLED);
            return;
        }
        this.addContext(false);
        switch (BlurManager$WhenMappings.$EnumSwitchMapping$0[this.mMode.ordinal()]) {
            case 1: {
                blurAlgorithm = this.getMStackBlurAlgorithm();
                break;
            }
            case 2: {
                blurAlgorithm = this.getMGaussian5x5RenderscriptBlurAlgorithm();
                break;
            }
            case 3: {
                blurAlgorithm = this.getMGaussian5x5BlurAlgorithm();
                break;
            }
            case 4: {
                blurAlgorithm = this.getMGaussian3x3RenderscriptBlurAlgorithm();
                break;
            }
            case 5: {
                blurAlgorithm = this.getMGaussian3x3BlurAlgorithm();
                break;
            }
            case 6: {
                blurAlgorithm = this.getMBox5x5RenderscriptBlurAlgorithm();
                break;
            }
            case 7: {
                blurAlgorithm = this.getMBox5x5BlurAlgorithm();
                break;
            }
            case 8: {
                blurAlgorithm = this.getMBox3x3RenderscriptBlurAlgorithm();
                break;
            }
            case 9: {
                blurAlgorithm = this.getMBox3x3BlurAlgorithm();
                break;
            }
            case 10: {
                blurAlgorithm = this.getMGaussianRenderscriptBlurAlgorithm();
                break;
            }
            case 11: {
                blurAlgorithm = this.getMGaussianBlurAlgorithm();
                break;
            }
            case 12: {
                blurAlgorithm = this.getMDummyBlurAlgorithm();
                break;
            }
            default: {
                blurAlgorithm = this.getMDummyBlurAlgorithm();
            }
        }
        this.mBlurAlgorithm = blurAlgorithm;
        this.mBlurAlgorithm.setRenderscript(renderScript);
    }

    public final boolean shouldBlur(@Nullable Drawable drawable, boolean checkDrawable) {
        return this.mMode != PivBlurMode.DISABLED && (this.mLastRadius != this.mRadius || checkDrawable && Intrinsics.areEqual((Object)this.mDrawable, (Object)drawable) ^ true);
    }

    @Nullable
    public final Bitmap getLastBlurredBitmap() {
        this.blur(this.mRadius);
        Bitmap bitmap = this.mBlurredBitmap;
        if (bitmap == null) {
            bitmap = this.mOriginalBitmap;
        }
        return bitmap;
    }

    private final Bitmap getOriginalBitmapFromDrawable(Drawable mLastDrawable, Drawable drawable) {
        Bitmap bitmap = null;
        if (drawable == null || this.mWidth <= 0 || this.mHeight <= 0) {
            return null;
        }
        float ratio = (float)drawable.getIntrinsicWidth() / (float)drawable.getIntrinsicHeight();
        int sizeX = 0;
        int sizeY = 0;
        int maxWidth = (int)(Math.max((float)this.mWidth, (float)this.mHeight * ratio) / this.mBlurOptions.getDownSamplingRate());
        int maxHeight = (int)(Math.max((float)this.mHeight, (float)this.mWidth / ratio) / this.mBlurOptions.getDownSamplingRate());
        if (drawable.getIntrinsicWidth() > maxWidth && maxWidth > 0 && drawable.getIntrinsicHeight() > maxHeight && maxHeight > 0) {
            sizeX = maxWidth;
            sizeY = maxHeight;
        } else {
            sizeX = drawable.getIntrinsicWidth();
            sizeY = drawable.getIntrinsicHeight();
        }
        if (Intrinsics.areEqual((Object)drawable.getClass().getName(), (Object)"android.graphics.drawable.VectorDrawable") || drawable instanceof VectorDrawableCompat) {
            sizeX = maxWidth;
            sizeY = maxHeight;
        }
        if (sizeX > 0 && sizeY > 0 && this.mOriginalBitmap != null) {
            Bitmap bitmap2 = this.mOriginalBitmap;
            if (bitmap2 != null) {
                if (!bitmap2.isRecycled()) {
                    if (this.mLastSizeX == sizeX && this.mLastSizeY == sizeY && mLastDrawable == drawable) {
                        return this.mOriginalBitmap;
                    }
                }
            }
        }
        this.mLastSizeX = sizeX;
        this.mLastSizeY = sizeY;
        try {
            Bitmap bitmap3;
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap4 = Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap3 = bitmap4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"Bitmap.createBitmap(size\u2026 Bitmap.Config.ARGB_8888)");
            } else if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
                Bitmap bitmap5 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap3 = bitmap5;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
            } else if (drawable instanceof ColorDrawable) {
                Bitmap bitmap6 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap3 = bitmap6;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap6, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
            } else {
                Bitmap bitmap7 = Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap3 = bitmap7;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap7, (String)"Bitmap.createBitmap(size\u2026 Bitmap.Config.ARGB_8888)");
            }
            bitmap = bitmap3;
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.mOriginalBitmap;
        }
    }

    public final void addContext(boolean fromView) {
        if (this.mIsRenderscriptManaged || this.mView.get() == null) {
            return;
        }
        ImageView imageView = (ImageView)this.mView.get();
        if (imageView == null || (imageView = imageView.getContext()) == null || (imageView = imageView.getApplicationContext()) == null) {
            return;
        }
        ImageView context = imageView;
        if (this.mBlurOptions.isStaticBlur() != fromView && this.mMode.getUsesRenderscript()) {
            this.mIsRenderscriptManaged = true;
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            SharedBlurManager.INSTANCE.addRenderscriptContext(context2);
        }
    }

    public final void removeContext(boolean fromView) {
        if (!this.mIsRenderscriptManaged) {
            return;
        }
        if (this.mBlurOptions.isStaticBlur() != fromView && this.mMode.getUsesRenderscript()) {
            this.mIsRenderscriptManaged = false;
            SharedBlurManager.INSTANCE.removeRenderscriptContext();
            this.updateAlgorithms(this.mMode);
        }
    }

    @Override
    public void onStaticBlurChanged() {
        if (this.mBlurOptions.isStaticBlur()) {
            if (this.mBlurredBitmap != null && Intrinsics.areEqual((Object)this.mBlurredBitmap, (Object)this.mOriginalBitmap) ^ true) {
                Bitmap bitmap = this.mOriginalBitmap;
                if (bitmap != null) {
                    bitmap.recycle();
                }
                this.mOriginalBitmap = this.mBlurredBitmap;
                this.mBlurredBitmap = null;
            }
            this.removeContext(false);
        } else {
            this.addContext(true);
        }
    }

    @Override
    public void onDownsamplingRateChanged() {
        block1: {
            Bitmap bitmap;
            this.changeDrawable(this.mDrawable);
            this.blur(this.mRadius);
            if (this.mView.get() == null || (bitmap = this.getLastBlurredBitmap()) == null) break block1;
            ImageView imageView = (ImageView)this.mView.get();
            if (imageView != null) {
                imageView.setImageBitmap(this.getLastBlurredBitmap());
            }
        }
    }

    @NotNull
    public final PivBlurMode getBlurMode() {
        return this.mMode;
    }

    @NotNull
    public final BlurOptions getBlurOptions() {
        return this.mBlurOptions;
    }

    public final int getRadius() {
        return this.mRadius;
    }

    @Nullable
    public final Bitmap getOriginalBitmap() {
        return this.mOriginalBitmap;
    }

    @NotNull
    public final Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("blur_options", (Parcelable)this.mBlurOptions);
        bundle.putInt("blur_mode", this.mMode.getValue());
        bundle.putInt("blur_radius", this.mRadius);
        return bundle;
    }

    public final void restoreInstanceState(@Nullable Bundle state) {
        if (state == null) {
            return;
        }
        Parcelable parcelable = state.getParcelable("blur_options");
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions");
        }
        this.mBlurOptions.setOptions((BlurOptions)parcelable);
        PivBlurMode blurMode = PivBlurMode.Companion.fromValue(state.getInt("blur_mode"));
        this.mWidth = state.getInt("blur_width");
        this.mHeight = state.getInt("blur_height");
        this.mRadius = state.getInt("blur_radius");
        this.mLastRadius = -1;
        this.changeMode(blurMode, this.mRadius);
    }

    public BlurManager(@NotNull ImageView view, @NotNull BlurOptions blurOptions) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)blurOptions, (String)"blurOptions");
        this.mBlurOptions = blurOptions;
        this.mMode = PivBlurMode.DISABLED;
        this.mLastRadius = -1;
        this.mView = new WeakReference<ImageView>(view);
        this.mBox3x3BlurAlgorithm$delegate = LazyKt.lazy((Function0)mBox3x3BlurAlgorithm.2.INSTANCE);
        this.mBox3x3RenderscriptBlurAlgorithm$delegate = LazyKt.lazy((Function0)mBox3x3RenderscriptBlurAlgorithm.2.INSTANCE);
        this.mBox5x5BlurAlgorithm$delegate = LazyKt.lazy((Function0)mBox5x5BlurAlgorithm.2.INSTANCE);
        this.mBox5x5RenderscriptBlurAlgorithm$delegate = LazyKt.lazy((Function0)mBox5x5RenderscriptBlurAlgorithm.2.INSTANCE);
        this.mGaussian5x5BlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussian5x5BlurAlgorithm.2.INSTANCE);
        this.mGaussian5x5RenderscriptBlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussian5x5RenderscriptBlurAlgorithm.2.INSTANCE);
        this.mGaussian3x3BlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussian3x3BlurAlgorithm.2.INSTANCE);
        this.mGaussian3x3RenderscriptBlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussian3x3RenderscriptBlurAlgorithm.2.INSTANCE);
        this.mGaussianBlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussianBlurAlgorithm.2.INSTANCE);
        this.mGaussianRenderscriptBlurAlgorithm$delegate = LazyKt.lazy((Function0)mGaussianRenderscriptBlurAlgorithm.2.INSTANCE);
        this.mStackBlurAlgorithm$delegate = LazyKt.lazy((Function0)mStackBlurAlgorithm.2.INSTANCE);
        this.mDummyBlurAlgorithm$delegate = LazyKt.lazy((Function0)mDummyBlurAlgorithm.2.INSTANCE);
        this.mBlurAlgorithm = this.getMDummyBlurAlgorithm();
    }
}

