/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.progress.drawers;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawer;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/HorizontalProgressDrawer;", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawer;", "()V", "listener", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager$ProgressDrawerListener;", "mCurrentFrontX", "", "mCurrentProgress", "mIsProgressReversed", "", "mLeft", "mOldProgress", "mProgress", "mProgressAnimationDuration", "", "mProgressAnimator", "Landroid/animation/ValueAnimator;", "mProgressBackPaint", "Landroid/graphics/Paint;", "mProgressFrontPaint", "mRight", "mUseProgressAnimation", "draw", "", "canvas", "Landroid/graphics/Canvas;", "progressBounds", "Landroid/graphics/RectF;", "getOldProgress", "getProgress", "setAnimationDuration", "millis", "setAnimationEnabled", "enabled", "setListener", "setProgressPercent", "progressPercent", "setRealProgress", "progress", "setup", "progressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "startIndeterminateAnimation", "stopIndeterminateAnimation", "powerfulimageview_release"})
public final class HorizontalProgressDrawer
implements ProgressDrawer {
    private float mLeft;
    private float mRight;
    private Paint mProgressFrontPaint = new Paint();
    private Paint mProgressBackPaint = new Paint();
    private ValueAnimator mProgressAnimator;
    private long mProgressAnimationDuration;
    private boolean mUseProgressAnimation;
    private float mProgress;
    private float mCurrentProgress;
    private float mOldProgress;
    private float mCurrentFrontX;
    private boolean mIsProgressReversed;
    private ProgressDrawerManager.ProgressDrawerListener listener;

    private final void setRealProgress(float progress) {
        block0: {
            this.mCurrentProgress = progress;
            this.mCurrentFrontX = this.mLeft + (this.mRight - this.mLeft) * (progress / (float)100);
            ProgressDrawerManager.ProgressDrawerListener progressDrawerListener = this.listener;
            if (progressDrawerListener == null) break block0;
            progressDrawerListener.onRequestInvalidate();
        }
    }

    @Override
    public void setProgressPercent(float progressPercent) {
        float mProgress = progressPercent;
        if (mProgress > (float)100) {
            mProgress %= (float)100;
        }
        this.mOldProgress = this.mCurrentProgress;
        this.mProgress = mProgress;
        if (this.mUseProgressAnimation) {
            this.mProgressAnimator.cancel();
            this.mProgressAnimator.start();
        } else {
            this.setRealProgress(mProgress);
        }
    }

    @Override
    public void setAnimationEnabled(boolean enabled) {
        this.mUseProgressAnimation = enabled;
    }

    @Override
    public void setAnimationDuration(long millis) {
        long l = this.mProgressAnimationDuration = millis < 0L ? 100L : millis;
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    @Override
    public void setListener(@NotNull ProgressDrawerManager.ProgressDrawerListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @Override
    public void setup(@NotNull ProgressOptions progressOptions) {
        Intrinsics.checkParameterIsNotNull((Object)progressOptions, (String)"progressOptions");
        this.mProgressFrontPaint.setColor(progressOptions.getFrontColor());
        this.mProgressFrontPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mProgressBackPaint.setColor(progressOptions.getBackColor());
        this.mProgressBackPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLeft = progressOptions.getRect().left;
        this.mRight = progressOptions.getRect().right;
        this.mUseProgressAnimation = progressOptions.getDeterminateAnimationEnabled();
        this.mIsProgressReversed = progressOptions.isProgressReversed();
        this.setProgressPercent(progressOptions.getValuePercent());
        long l = this.mProgressAnimationDuration = (long)progressOptions.getAnimationDuration() < 0L ? 100L : (long)progressOptions.getAnimationDuration();
        if (this.mProgressAnimator.getDuration() != this.mProgressAnimationDuration) {
            this.mProgressAnimator.setDuration(this.mProgressAnimationDuration);
            if (this.mProgressAnimator.isRunning()) {
                this.mProgressAnimator.cancel();
                this.mProgressAnimator.start();
            }
        }
    }

    @Override
    public void startIndeterminateAnimation() {
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF progressBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)progressBounds, (String)"progressBounds");
        if (!this.mIsProgressReversed) {
            canvas.drawRect(this.mCurrentFrontX, progressBounds.top, progressBounds.right, progressBounds.bottom, this.mProgressBackPaint);
            canvas.drawRect(progressBounds.left, progressBounds.top, this.mCurrentFrontX, progressBounds.bottom, this.mProgressFrontPaint);
        } else {
            canvas.drawRect(progressBounds.left, progressBounds.top, progressBounds.right - this.mCurrentFrontX, progressBounds.bottom, this.mProgressBackPaint);
            canvas.drawRect(progressBounds.right - this.mCurrentFrontX, progressBounds.top, progressBounds.right, progressBounds.bottom, this.mProgressFrontPaint);
        }
    }

    @Override
    public void stopIndeterminateAnimation() {
    }

    private final float getOldProgress() {
        return this.mOldProgress;
    }

    private final float getProgress() {
        return this.mProgress;
    }

    public HorizontalProgressDrawer() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0f, 1f)");
        this.mProgressAnimator = valueAnimator;
        this.mProgressAnimationDuration = -1L;
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mProgressAnimator.setDuration(this.mProgressAnimationDuration < 0L ? 100L : this.mProgressAnimationDuration);
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator it) {
                float f = this.getOldProgress();
                float f2 = this.getProgress() - this.getOldProgress();
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                this.setRealProgress(f + f2 * valueAnimator.getAnimatedFraction());
            }
        });
    }
}

