/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview.blur.algorithms;

import android.graphics.Bitmap;
import android.graphics.Color;
import com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.RenderscriptException;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.SharedBlurManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0014H \u00a2\u0006\u0002\b\u0015J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BaseConvolveBlurAlgorithm;", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurAlgorithm;", "()V", "h", "", "w", "apply", "", "srcPix", "", "radius", "cores", "core", "step", "blur", "Landroid/graphics/Bitmap;", "original", "options", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;", "getFilter", "", "getFilter$powerfulimageview_release", "getPixel", "x2", "y2", "pix", "BlurTask", "powerfulimageview_release"})
public abstract class BaseConvolveBlurAlgorithm
implements BlurAlgorithm {
    private int w;
    private int h;

    @NotNull
    public abstract float[] getFilter$powerfulimageview_release();

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap blur(@NotNull Bitmap original, int radius, @NotNull BlurOptions options) throws RenderscriptException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.w = original.getWidth();
        this.h = original.getHeight();
        int[] pix = new int[this.w * this.h];
        original.getPixels(pix, 0, this.w, 0, 0, this.w, this.h);
        int cores = RangesKt.coerceAtLeast((int)options.getNumThreads(), (int)Runtime.getRuntime().availableProcessors());
        ArrayList<BlurTask> horizontal = new ArrayList<BlurTask>(cores);
        ArrayList<BlurTask> vertical = new ArrayList<BlurTask>(cores);
        int n = 0;
        int n2 = cores;
        while (n < n2) {
            void i;
            horizontal.add(new BlurTask(pix, this.w, this.h, radius, cores, (int)i, 1));
            vertical.add(new BlurTask(pix, this.w, this.h, radius, cores, (int)i, 2));
            ++i;
        }
        try {
            SharedBlurManager.INSTANCE.getExecutorService().invokeAll((Collection)horizontal);
            SharedBlurManager.INSTANCE.getExecutorService().invokeAll((Collection)vertical);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (!options.isStaticBlur()) {
            bitmap = Bitmap.createBitmap((int[])pix, (int)0, (int)this.w, (int)this.w, (int)this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else if (original.isMutable()) {
            original.setPixels(pix, 0, this.w, 0, 0, this.w, this.h);
            bitmap = original;
        } else {
            original.recycle();
            bitmap = Bitmap.createBitmap((int[])pix, (int)0, (int)this.w, (int)this.w, (int)this.h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return bitmap;
    }

    private final int getPixel(int x2, int y2, int[] pix) {
        int x = x2;
        int y = y2;
        if (x < 0) {
            x = 0;
        }
        if (x >= this.w) {
            x = this.w - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.h) {
            y = this.h - 1;
        }
        return pix[y * this.w + x];
    }

    /*
     * WARNING - void declaration
     */
    private final void apply(int[] srcPix, int w, int h, int radius, int cores, int core, int step) {
        int iteration;
        int n;
        int a;
        int n2;
        int position;
        int n3;
        int minIndex;
        int n4;
        float[] gaussianFilter = this.getFilter$powerfulimageview_release();
        int filterLength = gaussianFilter.length;
        int[] tmpPix = new int[filterLength];
        if (step == 1) {
            int n5 = 0;
            n4 = radius;
            while (n5 < n4) {
                int minY = core * h / cores;
                int maxY = (core + 1) * h / cores;
                minIndex = minY * w;
                n3 = minY;
                int n6 = maxY;
                while (n3 < n6) {
                    int x;
                    void y;
                    void row = y * w;
                    position = 0;
                    n2 = 0;
                    int n7 = w;
                    while (n2 < n7) {
                        int sum = 0;
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        a = 0;
                        n = 0;
                        int n8 = filterLength;
                        while (n < n8) {
                            void i;
                            int pixel = this.getPixel(x + i - filterLength / 2, (int)y, srcPix);
                            r += (int)((float)Color.red((int)pixel) * gaussianFilter[i]);
                            g += (int)((float)Color.green((int)pixel) * gaussianFilter[i]);
                            b += (int)((float)Color.blue((int)pixel) * gaussianFilter[i]);
                            a += (int)((float)Color.alpha((int)pixel) * gaussianFilter[i]);
                            ++i;
                        }
                        sum = Color.argb((int)a, (int)r, (int)g, (int)b);
                        position = row + x;
                        if (position >= minIndex + filterLength) {
                            srcPix[position - filterLength] = tmpPix[position % filterLength];
                        }
                        tmpPix[position % filterLength] = sum;
                        ++x;
                    }
                    ++position;
                    x = 0;
                    n7 = filterLength;
                    while (x < n7) {
                        void i;
                        srcPix[position - filterLength + i] = tmpPix[(position + i) % filterLength];
                        ++i;
                    }
                    ++y;
                }
                ++iteration;
            }
        }
        if (step == 2) {
            n4 = radius;
            for (iteration = 0; iteration < n4; ++iteration) {
                int minX = core * w / cores;
                int maxX = (core + 1) * w / cores;
                minIndex = minX;
                n3 = maxX;
                while (minIndex < n3) {
                    int y;
                    void x;
                    void row = x;
                    int position2 = 0;
                    position = 0;
                    n2 = h;
                    while (position < n2) {
                        int sum = 0;
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        int a2 = 0;
                        a = 0;
                        n = filterLength;
                        while (a < n) {
                            void i;
                            int pixel = this.getPixel((int)x, y + i - filterLength / 2, srcPix);
                            r += (int)((float)Color.red((int)pixel) * gaussianFilter[i]);
                            g += (int)((float)Color.green((int)pixel) * gaussianFilter[i]);
                            b += (int)((float)Color.blue((int)pixel) * gaussianFilter[i]);
                            a2 += (int)((float)Color.alpha((int)pixel) * gaussianFilter[i]);
                            ++i;
                        }
                        sum = Color.argb((int)a2, (int)r, (int)g, (int)b);
                        if (position2 >= filterLength) {
                            srcPix[row - filterLength * w] = tmpPix[position2 % filterLength];
                        }
                        tmpPix[position2 % filterLength] = sum;
                        ++position2;
                        row += w;
                        ++y;
                    }
                    y = 0;
                    n2 = filterLength;
                    while (y < n2) {
                        void i;
                        srcPix[row - (filterLength - i) * w] = tmpPix[(position2 + i) % filterLength];
                        ++i;
                    }
                    ++x;
                }
            }
        }
    }

    @Override
    @NotNull
    public BlurAlgorithm setRenderscript(@Nullable Object renderscript) {
        return BlurAlgorithm.DefaultImpls.setRenderscript(this, renderscript);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BaseConvolveBlurAlgorithm$BlurTask;", "Ljava/util/concurrent/Callable;", "Ljava/lang/Void;", "_src", "", "_w", "", "_h", "_radius", "_totalCores", "_coreIndex", "_round", "(Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BaseConvolveBlurAlgorithm;[IIIIIII)V", "call", "powerfulimageview_release"})
    private final class BlurTask
    implements Callable<Void> {
        private final int[] _src;
        private final int _w;
        private final int _h;
        private final int _radius;
        private final int _totalCores;
        private final int _coreIndex;
        private final int _round;

        @Override
        @Nullable
        public Void call() throws Exception {
            BaseConvolveBlurAlgorithm.this.apply(this._src, this._w, this._h, this._radius, this._totalCores, this._coreIndex, this._round);
            return null;
        }

        public BlurTask(int[] _src, int _w, int _h, int _radius, int _totalCores, int _coreIndex, int _round) {
            Intrinsics.checkParameterIsNotNull((Object)_src, (String)"_src");
            this._src = _src;
            this._w = _w;
            this._h = _h;
            this._radius = _radius;
            this._totalCores = _totalCores;
            this._coreIndex = _coreIndex;
            this._round = _round;
        }
    }
}

