/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerful_libraries.imageview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import com.stefanosiano.powerful_libraries.imageview.ImageViewWrapper;
import com.stefanosiano.powerful_libraries.imageview.R;
import com.stefanosiano.powerful_libraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerful_libraries.imageview.blur.PivBlurMode;
import com.stefanosiano.powerful_libraries.imageview.blur.algorithms.BlurManager;
import com.stefanosiano.powerful_libraries.imageview.progress.PivProgressGravity;
import com.stefanosiano.powerful_libraries.imageview.progress.PivProgressMode;
import com.stefanosiano.powerful_libraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerful_libraries.imageview.progress.drawers.ProgressDrawerManager;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeMode;
import com.stefanosiano.powerful_libraries.imageview.shape.PivShapeScaleType;
import com.stefanosiano.powerful_libraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerful_libraries.imageview.shape.drawers.ShapeDrawerManager;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0011H\u0002J\b\u0010:\u001a\u0004\u0018\u00010;J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020?J\b\u0010@\u001a\u0004\u0018\u00010;J\u0006\u0010A\u001a\u00020\tJ\u0006\u0010B\u001a\u00020\fJ\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020JJ\b\u0010K\u001a\u00020LH\u0014J\b\u0010M\u001a\u00020LH\u0014J\u0010\u0010N\u001a\u00020L2\u0006\u0010O\u001a\u00020PH\u0014J\r\u0010Q\u001a\u00020LH\u0010\u00a2\u0006\u0002\bRJ\u0018\u0010S\u001a\u00020L2\u0006\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tH\u0014J\u0012\u0010V\u001a\u00020L2\b\u0010W\u001a\u0004\u0018\u00010XH\u0014J\n\u0010Y\u001a\u0004\u0018\u00010XH\u0014J(\u0010Z\u001a\u00020L2\u0006\u0010[\u001a\u00020\t2\u0006\u0010\\\u001a\u00020\t2\u0006\u0010]\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0014J\u0016\u0010_\u001a\u00020L2\u0006\u0010`\u001a\u00020=2\u0006\u0010a\u001a\u00020\tJ\u000e\u0010b\u001a\u00020L2\u0006\u0010a\u001a\u00020\tJ\u0010\u0010c\u001a\u00020L2\u0006\u0010d\u001a\u00020eH\u0016J\u000e\u0010f\u001a\u00020L2\u0006\u0010g\u001a\u00020\u0011J\u000e\u0010h\u001a\u00020L2\u0006\u0010i\u001a\u00020DJ\u000e\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020\fJ\u0010\u0010l\u001a\u00020L2\u0006\u0010m\u001a\u00020nH\u0016J\u000e\u0010o\u001a\u00020L2\u0006\u0010p\u001a\u00020HJ\u000e\u0010q\u001a\u00020L2\u0006\u0010m\u001a\u00020rR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/stefanosiano/powerful_libraries/imageview/PowerfulImageView;", "Lcom/stefanosiano/powerful_libraries/imageview/ImageViewWrapper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_BLUR_DOWNSAMPLING_RATE", "", "DEFAULT_BLUR_MODE", "DEFAULT_BLUR_NUM_THREADS", "DEFAULT_BLUR_RADIUS", "DEFAULT_BLUR_STATIC", "", "DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK", "DEFAULT_PROGRESS_ANIMATION_DURATION", "DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE", "DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT", "DEFAULT_PROGRESS_GRAVITY", "DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION", "DEFAULT_PROGRESS_INDETERMINATE", "DEFAULT_PROGRESS_MODE", "DEFAULT_PROGRESS_PADDING", "DEFAULT_PROGRESS_REMOVED_ON_CHANGE", "DEFAULT_PROGRESS_REVERSED", "DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH", "DEFAULT_PROGRESS_SHADOW_ENABLED", "DEFAULT_PROGRESS_SHADOW_PADDING", "DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT", "DEFAULT_PROGRESS_SIZE", "DEFAULT_PROGRESS_SIZE_PERCENT", "DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION", "DEFAULT_PROGRESS_VALUE", "DEFAULT_PROGRESS_WIDTH", "DEFAULT_PROGRESS_WIDTH_PERCENT", "DEFAULT_SHAPE_BORDER_OVERLAY", "DEFAULT_SHAPE_BORDER_WIDTH", "DEFAULT_SHAPE_INNER_PADDING", "DEFAULT_SHAPE_INNER_PADDING_PERCENT", "DEFAULT_SHAPE_MODE", "DEFAULT_SHAPE_RADIUS_X", "DEFAULT_SHAPE_RADIUS_Y", "DEFAULT_SHAPE_RATIO", "initialized", "mBlurManager", "Lcom/stefanosiano/powerful_libraries/imageview/blur/algorithms/BlurManager;", "mCheckBlur", "mProgressDrawerManager", "Lcom/stefanosiano/powerful_libraries/imageview/progress/drawers/ProgressDrawerManager;", "mShapeDrawerManager", "Lcom/stefanosiano/powerful_libraries/imageview/shape/drawers/ShapeDrawerManager;", "mShouldCheckRemoveProgress", "blurBitmap", "changeDrawable", "getBlurBlurredBitmap", "Landroid/graphics/Bitmap;", "getBlurMode", "Lcom/stefanosiano/powerful_libraries/imageview/blur/PivBlurMode;", "getBlurOptions", "Lcom/stefanosiano/powerful_libraries/imageview/blur/BlurOptions;", "getBlurOriginalBitmap", "getBlurRadius", "getProgress", "getProgressMode", "Lcom/stefanosiano/powerful_libraries/imageview/progress/PivProgressMode;", "getProgressOptions", "Lcom/stefanosiano/powerful_libraries/imageview/progress/ProgressOptions;", "getShapeMode", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeMode;", "getShapeOptions", "Lcom/stefanosiano/powerful_libraries/imageview/shape/ShapeOptions;", "onAttachedToWindow", "", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDrawableChanged", "onDrawableChanged$powerfulimageview_release", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "setBlurMode", "blurMode", "radius", "setBlurRadius", "setImageMatrix", "matrix", "Landroid/graphics/Matrix;", "setProgressIndeterminate", "isIndeterminate", "setProgressMode", "progressMode", "setProgressValue", "progress", "setScaleType", "scaleType", "Landroid/widget/ImageView$ScaleType;", "setShapeMode", "shapeMode", "setShapeScaleType", "Lcom/stefanosiano/powerful_libraries/imageview/shape/PivShapeScaleType;", "powerfulimageview_release"})
public class PowerfulImageView
extends ImageViewWrapper {
    private final boolean DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
    private final int DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
    private final int DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION = 600;
    private final int DEFAULT_PROGRESS_WIDTH = -1;
    private final float DEFAULT_PROGRESS_WIDTH_PERCENT = 10.0f;
    private final int DEFAULT_PROGRESS_SIZE = -1;
    private final float DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
    private final int DEFAULT_PROGRESS_PADDING = 2;
    private final int DEFAULT_PROGRESS_VALUE = 0;
    private final int DEFAULT_PROGRESS_GRAVITY;
    private final boolean DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT = false;
    private final boolean DEFAULT_PROGRESS_INDETERMINATE = true;
    private final boolean DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE = false;
    private final boolean DEFAULT_PROGRESS_SHADOW_ENABLED = true;
    private final boolean DEFAULT_PROGRESS_REVERSED = false;
    private final boolean DEFAULT_PROGRESS_REMOVED_ON_CHANGE = true;
    private final int DEFAULT_PROGRESS_MODE;
    private final int DEFAULT_PROGRESS_SHADOW_PADDING = -1;
    private final float DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT = 0.0f;
    private final int DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH = 1;
    private final int DEFAULT_SHAPE_MODE;
    private final int DEFAULT_SHAPE_INNER_PADDING = -1;
    private final float DEFAULT_SHAPE_INNER_PADDING_PERCENT = 0.0f;
    private final boolean DEFAULT_SHAPE_BORDER_OVERLAY = false;
    private final int DEFAULT_SHAPE_BORDER_WIDTH = 0;
    private final float DEFAULT_SHAPE_RATIO = 0.0f;
    private final float DEFAULT_SHAPE_RADIUS_X = 1.0f;
    private final float DEFAULT_SHAPE_RADIUS_Y = 1.0f;
    private final int DEFAULT_BLUR_RADIUS = 0;
    private final float DEFAULT_BLUR_DOWNSAMPLING_RATE = 4.0f;
    private final boolean DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK = true;
    private final int DEFAULT_BLUR_NUM_THREADS = 0;
    private final boolean DEFAULT_BLUR_STATIC = false;
    private final int DEFAULT_BLUR_MODE;
    private final ProgressDrawerManager mProgressDrawerManager;
    private final ShapeDrawerManager mShapeDrawerManager;
    private final BlurManager mBlurManager;
    private boolean mCheckBlur;
    private boolean mShouldCheckRemoveProgress;
    private boolean initialized;
    private HashMap _$_findViewCache;

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (!this.initialized) {
            return;
        }
        if (w == oldw && h == oldh) {
            return;
        }
        this.mProgressDrawerManager.onSizeChanged(w, h);
        this.mShapeDrawerManager.onSizeChanged(w, h, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        int n = this.mShapeDrawerManager.getMeasuredWidth();
        int n2 = this.mShapeDrawerManager.getMeasuredHeight();
        Drawable drawable = this.getDrawable();
        if (drawable == null || (drawable = drawable.getCurrent()) == null) {
            drawable = this.getDrawable();
        }
        this.mBlurManager.onSizeChanged(n, n2, drawable);
        this.mShouldCheckRemoveProgress = false;
        this.blurBitmap(false);
        this.mShouldCheckRemoveProgress = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.initialized) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mShapeDrawerManager.onMeasure(widthSize, heightSize, widthMode, heightMode, (View)this);
        this.setMeasuredDimension(this.mShapeDrawerManager.getMeasuredWidth(), this.mShapeDrawerManager.getMeasuredHeight());
    }

    @Override
    public void onDrawableChanged$powerfulimageview_release() {
        if (!this.initialized) {
            return;
        }
        if (this.blurBitmap(true)) {
            return;
        }
        if (this.mShouldCheckRemoveProgress && this.getDrawable() != null) {
            Drawable drawable = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
            Drawable drawable2 = drawable.getCurrent();
            if (drawable2 == null) {
                Drawable drawable3 = this.getDrawable();
                drawable2 = drawable3;
                Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"drawable");
            }
            this.mProgressDrawerManager.changeDrawable(drawable2);
        }
        if (this.getDrawable() != null) {
            Drawable drawable = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
            Drawable drawable4 = drawable.getCurrent();
            if (drawable4 == null) {
                drawable4 = this.getDrawable();
            }
            this.mShapeDrawerManager.changeDrawable(drawable4);
        }
    }

    @Override
    public void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.setScaleType(scaleType);
        if (!this.initialized) {
            return;
        }
        this.mShapeDrawerManager.setScaleType(PivShapeScaleType.Companion.getFromScaleType(scaleType));
    }

    public final void setShapeScaleType(@NotNull PivShapeScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)scaleType), (String)"scaleType");
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.mShapeDrawerManager.setScaleType(scaleType);
    }

    @Override
    public void setImageMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        if (!this.initialized) {
            super.setImageMatrix(matrix);
            return;
        }
        super.setImageMatrix(matrix);
        this.mShapeDrawerManager.setImageMatrix(matrix);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.initialized) {
            super.onDraw(canvas);
            return;
        }
        this.mShapeDrawerManager.onDraw(canvas);
        this.mProgressDrawerManager.onDraw(canvas);
    }

    public final void setProgressMode(@NotNull PivProgressMode progressMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)progressMode), (String)"progressMode");
        this.mProgressDrawerManager.changeProgressMode(progressMode, false);
    }

    public final void setShapeMode(@NotNull PivShapeMode shapeMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shapeMode), (String)"shapeMode");
        this.mShapeDrawerManager.changeShapeMode(shapeMode);
    }

    public final void setBlurMode(@NotNull PivBlurMode blurMode, int radius) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blurMode), (String)"blurMode");
        this.mCheckBlur = blurMode != PivBlurMode.DISABLED;
        this.mBlurManager.changeMode(blurMode, radius);
        this.blurBitmap(false);
    }

    public final void setBlurRadius(int radius) {
        this.mCheckBlur = this.mBlurManager.getBlurMode() != PivBlurMode.DISABLED;
        this.mBlurManager.changeRadius(radius);
        this.blurBitmap(false);
    }

    private final boolean blurBitmap(boolean changeDrawable) {
        if (!this.mCheckBlur || this.getDrawable() == null) {
            return false;
        }
        Drawable drawable = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
        boolean shouldBlur = this.mBlurManager.shouldBlur(drawable.getCurrent(), changeDrawable);
        if (changeDrawable) {
            Drawable drawable2 = this.getDrawable();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
            this.mBlurManager.changeDrawable(drawable2.getCurrent());
        }
        Bitmap blurredBitmap = null;
        if (shouldBlur && (blurredBitmap = this.mBlurManager.getLastBlurredBitmap()) != null) {
            this.mCheckBlur = false;
            this.setImageBitmap(blurredBitmap);
            this.mCheckBlur = true;
        }
        return shouldBlur && blurredBitmap != null && !blurredBitmap.isRecycled();
    }

    public final void setProgressIndeterminate(boolean isIndeterminate) {
        this.mProgressDrawerManager.getProgressOptions().setIsIndeterminate(isIndeterminate);
    }

    @NotNull
    public final ProgressOptions getProgressOptions() {
        return this.mProgressDrawerManager.getProgressOptions();
    }

    public final float getProgress() {
        return this.mProgressDrawerManager.getProgressOptions().getValuePercent();
    }

    @NotNull
    public final PivProgressMode getProgressMode() {
        return this.mProgressDrawerManager.getProgressMode();
    }

    @NotNull
    public final PivShapeMode getShapeMode() {
        return this.mShapeDrawerManager.getShapeMode();
    }

    @NotNull
    public final PivBlurMode getBlurMode() {
        return this.mBlurManager.getBlurMode();
    }

    @NotNull
    public final ShapeOptions getShapeOptions() {
        return this.mShapeDrawerManager.getShapeOptions();
    }

    @NotNull
    public final BlurOptions getBlurOptions() {
        return this.mBlurManager.getBlurOptions();
    }

    public final int getBlurRadius() {
        return this.mBlurManager.getRadius();
    }

    @Nullable
    public final Bitmap getBlurBlurredBitmap() {
        return this.mBlurManager.getLastBlurredBitmap();
    }

    @Nullable
    public final Bitmap getBlurOriginalBitmap() {
        return this.mBlurManager.getOriginalBitmap();
    }

    public final void setProgressValue(float progress) {
        this.getProgressOptions().setValue(progress);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.initialized) {
            return;
        }
        this.mBlurManager.addContext(true);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.initialized) {
            return;
        }
        this.mBlurManager.removeContext(true);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("super_state", super.onSaveInstanceState());
        bundle.putParcelable("progress_drawer_manager", (Parcelable)this.mProgressDrawerManager.saveInstanceState());
        bundle.putParcelable("shape_drawer_manager", (Parcelable)this.mShapeDrawerManager.saveInstanceState());
        bundle.putParcelable("blur_manager", (Parcelable)this.mBlurManager.saveInstanceState());
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable state2 = state;
        if (state2 instanceof Bundle) {
            Bundle bundle = (Bundle)state2;
            Parcelable parcelable = bundle.getParcelable("progress_drawer_manager");
            if (parcelable == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.Bundle");
            }
            this.mProgressDrawerManager.restoreInstanceState((Bundle)parcelable);
            Parcelable parcelable2 = bundle.getParcelable("shape_drawer_manager");
            if (parcelable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.Bundle");
            }
            this.mShapeDrawerManager.restoreInstanceState((Bundle)parcelable2);
            Parcelable parcelable3 = bundle.getParcelable("blur_manager");
            if (parcelable3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.os.Bundle");
            }
            this.mBlurManager.restoreInstanceState((Bundle)parcelable3);
            state2 = bundle.getParcelable("super_state");
        }
        super.onRestoreInstanceState(state2);
        this.blurBitmap(true);
    }

    public PowerfulImageView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public PowerfulImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public PowerfulImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int n;
        int n2;
        int n3;
        int n4;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION = true;
        this.DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
        this.DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION = 600;
        this.DEFAULT_PROGRESS_WIDTH = -1;
        this.DEFAULT_PROGRESS_WIDTH_PERCENT = 10.0f;
        this.DEFAULT_PROGRESS_SIZE = -1;
        this.DEFAULT_PROGRESS_SIZE_PERCENT = 40.0f;
        this.DEFAULT_PROGRESS_PADDING = 2;
        this.DEFAULT_PROGRESS_GRAVITY = PivProgressGravity.CENTER.getValue();
        this.DEFAULT_PROGRESS_INDETERMINATE = true;
        this.DEFAULT_PROGRESS_SHADOW_ENABLED = true;
        this.DEFAULT_PROGRESS_REMOVED_ON_CHANGE = true;
        this.DEFAULT_PROGRESS_MODE = PivProgressMode.NONE.getValue();
        this.DEFAULT_PROGRESS_SHADOW_PADDING = -1;
        this.DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH = 1;
        this.DEFAULT_SHAPE_MODE = PivShapeMode.NORMAL.getValue$powerfulimageview_release();
        this.DEFAULT_SHAPE_INNER_PADDING = -1;
        this.DEFAULT_SHAPE_RADIUS_X = 1.0f;
        this.DEFAULT_SHAPE_RADIUS_Y = 1.0f;
        this.DEFAULT_BLUR_DOWNSAMPLING_RATE = 4.0f;
        this.DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK = true;
        this.DEFAULT_BLUR_MODE = PivBlurMode.DISABLED.getValue();
        this.mShouldCheckRemoveProgress = true;
        this.initialized = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PowerfulImageView, defStyleAttr, 0);
        TypedValue tvSize = new TypedValue();
        TypedValue tvBorderWidth = new TypedValue();
        TypedValue tvShadowPadding = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_piv_progress_size, tvSize);
        a.getValue(R.styleable.PowerfulImageView_piv_progress_border_width, tvBorderWidth);
        a.getValue(R.styleable.PowerfulImageView_piv_progress_shadow_padding, tvShadowPadding);
        PivProgressMode progressMode = PivProgressMode.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_progress_mode, this.DEFAULT_PROGRESS_MODE));
        boolean useDeterminateAnimation = a.getBoolean(R.styleable.PowerfulImageView_piv_progress_determinate_animation_enabled, this.DEFAULT_PROGRESS_USE_DETERMINATE_ANIMATION);
        boolean bl = this.isInEditMode() ? false : useDeterminateAnimation;
        int n5 = a.getInt(R.styleable.PowerfulImageView_piv_progress_animation_duration, useDeterminateAnimation ? this.DEFAULT_PROGRESS_INDETEMINATE_ANIMATION_DURATION : this.DEFAULT_PROGRESS_ANIMATION_DURATION);
        if (tvBorderWidth.type == 5) {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            n4 = (int)tvBorderWidth.getDimension(resources.getDisplayMetrics());
        } else {
            n4 = this.DEFAULT_PROGRESS_WIDTH;
        }
        float f = tvBorderWidth.type == 6 ? tvBorderWidth.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_WIDTH_PERCENT;
        if (tvSize.type == 5) {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            n3 = (int)tvSize.getDimension(resources.getDisplayMetrics());
        } else {
            n3 = this.DEFAULT_PROGRESS_SIZE;
        }
        float f2 = tvSize.type == 6 ? tvSize.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_SIZE_PERCENT;
        float f3 = this.DEFAULT_PROGRESS_PADDING;
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        int n6 = a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_progress_padding, (int)TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)resources.getDisplayMetrics()));
        float f4 = a.getFloat(R.styleable.PowerfulImageView_piv_progress_value, (float)this.DEFAULT_PROGRESS_VALUE);
        TypedArray typedArray = a;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
        int n7 = this.getColor(typedArray, R.styleable.PowerfulImageView_piv_progress_front_color, R.color.piv_default_progress_front_color);
        int n8 = this.getColor(a, R.styleable.PowerfulImageView_piv_progress_back_color, R.color.piv_default_progress_back_color);
        int n9 = this.getColor(a, R.styleable.PowerfulImageView_piv_progress_indeterminate_color, R.color.piv_default_progress_indeterminate_color);
        int n10 = a.getInteger(R.styleable.PowerfulImageView_piv_progress_gravity, this.DEFAULT_PROGRESS_GRAVITY);
        boolean bl2 = Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1;
        boolean bl3 = a.getBoolean(R.styleable.PowerfulImageView_piv_progress_rtl_disabled, this.DEFAULT_PROGRESS_DISABLE_RTL_SUPPORT);
        boolean bl4 = a.getBoolean(R.styleable.PowerfulImageView_piv_progress_indeterminate, this.DEFAULT_PROGRESS_INDETERMINATE);
        boolean bl5 = a.getBoolean(R.styleable.PowerfulImageView_piv_progress_draw_wedge, this.DEFAULT_PROGRESS_DETERMINATE_DRAW_WEDGE);
        boolean bl6 = a.getBoolean(R.styleable.PowerfulImageView_piv_progress_shadow_enabled, this.DEFAULT_PROGRESS_SHADOW_ENABLED);
        int n11 = this.getColor(a, R.styleable.PowerfulImageView_piv_progress_shadow_color, R.color.piv_default_progress_shadow_color);
        if (tvShadowPadding.type == 5) {
            Resources resources2 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
            n2 = (int)tvShadowPadding.getDimension(resources2.getDisplayMetrics());
        } else {
            n2 = this.DEFAULT_PROGRESS_SHADOW_PADDING;
        }
        float f5 = tvShadowPadding.type == 6 ? tvShadowPadding.getFraction(100.0f, 100.0f) : this.DEFAULT_PROGRESS_SHADOW_PADDING_PERCENT;
        float f6 = this.DEFAULT_PROGRESS_SHADOW_BORDER_WIDTH;
        Resources resources3 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources3, (String)"resources");
        ProgressOptions progressOptions = new ProgressOptions(bl, n5, n4, f, n3, f2, n6, f4, n7, n8, n9, n10, bl2, bl3, bl4, bl5, bl6, n11, n2, f5, a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_progress_shadow_border_width, (int)TypedValue.applyDimension((int)1, (float)f6, (DisplayMetrics)resources3.getDisplayMetrics())), this.getColor(a, R.styleable.PowerfulImageView_piv_progress_shadow_border_color, R.color.piv_default_progress_shadow_border_color), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_reversed, this.DEFAULT_PROGRESS_REVERSED), a.getBoolean(R.styleable.PowerfulImageView_piv_progress_removed_on_change, this.DEFAULT_PROGRESS_REMOVED_ON_CHANGE));
        TypedValue tvShapeInnerPadding = new TypedValue();
        a.getValue(R.styleable.PowerfulImageView_piv_shape_inner_padding, tvShapeInnerPadding);
        int n12 = this.getColor(a, R.styleable.PowerfulImageView_piv_shape_background_color, 17170445);
        int n13 = this.getColor(a, R.styleable.PowerfulImageView_piv_shape_foreground_color, 17170445);
        if (tvShapeInnerPadding.type == 5) {
            Resources resources4 = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources4, (String)"resources");
            n = (int)tvShapeInnerPadding.getDimension(resources4.getDisplayMetrics());
        } else {
            n = this.DEFAULT_SHAPE_INNER_PADDING;
        }
        float f7 = tvShapeInnerPadding.type == 6 ? tvShapeInnerPadding.getFraction(100.0f, 100.0f) : this.DEFAULT_SHAPE_INNER_PADDING_PERCENT;
        boolean bl7 = a.getBoolean(R.styleable.PowerfulImageView_piv_shape_border_overlay, this.DEFAULT_SHAPE_BORDER_OVERLAY);
        int n14 = this.getColor(a, R.styleable.PowerfulImageView_piv_shape_border_color, 17170445);
        float f8 = this.DEFAULT_SHAPE_BORDER_WIDTH;
        Resources resources5 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources5, (String)"resources");
        ShapeOptions shapeOptions = new ShapeOptions(n12, n13, n, f7, bl7, n14, a.getDimensionPixelSize(R.styleable.PowerfulImageView_piv_shape_border_width, (int)TypedValue.applyDimension((int)1, (float)f8, (DisplayMetrics)resources5.getDisplayMetrics())), a.getFloat(R.styleable.PowerfulImageView_piv_shape_ratio, this.DEFAULT_SHAPE_RATIO), a.getFloat(R.styleable.PowerfulImageView_piv_shape_radius_x, this.DEFAULT_SHAPE_RADIUS_X), a.getFloat(R.styleable.PowerfulImageView_piv_shape_radius_y, this.DEFAULT_SHAPE_RADIUS_Y), this.getColor(a, R.styleable.PowerfulImageView_piv_shape_solid_color, R.color.piv_default_shape_solid_color), a.getDrawable(R.styleable.PowerfulImageView_piv_shape_background), a.getDrawable(R.styleable.PowerfulImageView_piv_shape_foreground));
        PivShapeMode shapeMode = PivShapeMode.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_shape_mode, this.DEFAULT_SHAPE_MODE));
        PivShapeScaleType scaleType = PivShapeScaleType.Companion.fromValue(a.getInteger(R.styleable.PowerfulImageView_piv_shape_scaleType, PivShapeScaleType.Companion.getFromScaleType(this.getScaleType()).getValue$powerfulimageview_release()));
        BlurOptions blurOptions = new BlurOptions(a.getFloat(R.styleable.PowerfulImageView_piv_blur_down_sampling_rate, this.DEFAULT_BLUR_DOWNSAMPLING_RATE), a.getBoolean(R.styleable.PowerfulImageView_piv_blur_static, this.DEFAULT_BLUR_STATIC), a.getBoolean(R.styleable.PowerfulImageView_piv_blur_use_rs_fallback, this.DEFAULT_BLUR_USE_RENDERSCRIPT_FALLBACK), a.getInteger(R.styleable.PowerfulImageView_piv_blur_num_threads, this.DEFAULT_BLUR_NUM_THREADS));
        int blurRadius = a.getInteger(R.styleable.PowerfulImageView_piv_blur_radius, this.DEFAULT_BLUR_RADIUS);
        int blurModeValue = a.getInteger(R.styleable.PowerfulImageView_piv_blur_mode, this.DEFAULT_BLUR_MODE);
        PivBlurMode blurMode = PivBlurMode.Companion.fromValue(blurModeValue);
        a.recycle();
        this.mProgressDrawerManager = new ProgressDrawerManager((View)this, progressOptions);
        this.mShapeDrawerManager = new ShapeDrawerManager((View)this, shapeOptions);
        this.mBlurManager = new BlurManager((ImageView)this, blurOptions);
        this.mShapeDrawerManager.setScaleType(scaleType);
        this.mShouldCheckRemoveProgress = false;
        this.onDrawableChanged$powerfulimageview_release();
        this.setProgressMode(progressMode);
        this.setShapeMode(shapeMode);
        this.setBlurMode(blurMode, blurRadius);
        this.mShouldCheckRemoveProgress = true;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

