/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.imageview.shape.drawers;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerfullibraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerfullibraries.imageview.shape.drawers.BaseNormalShapeDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000bH\u0014J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/SolidCircleShapeDrawer;", "Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/BaseNormalShapeDrawer;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "mBorderRadius", "", "mCx", "mCy", "mRadius", "mSolidPaint", "Landroid/graphics/Paint;", "mSolidRadius", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "Landroid/graphics/RectF;", "shapeBounds", "imageBounds", "borderPaint", "drawPaint", "paint", "drawSolid", "setup", "shapeOptions", "Lcom/stefanosiano/powerfullibraries/imageview/shape/ShapeOptions;", "powerfulimageview_release"})
public final class SolidCircleShapeDrawer
extends BaseNormalShapeDrawer {
    private final Paint mSolidPaint = new Paint();
    private float mCx;
    private float mCy;
    private float mRadius;
    private float mSolidRadius;
    private float mBorderRadius;

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        super.setup(shapeOptions);
        this.getMBackPaint().setAntiAlias(true);
        this.getMBackPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        this.getMFrontPaint().setAntiAlias(true);
        this.getMFrontPaint().setStyle(Paint.Style.FILL_AND_STROKE);
        this.mSolidPaint.setColor(shapeOptions.getSolidColor());
        this.mSolidPaint.setAntiAlias(true);
        this.mSolidPaint.setStyle(Paint.Style.STROKE);
        this.mCx = shapeOptions.getBorderBounds().centerX();
        this.mCy = shapeOptions.getBorderBounds().centerY();
        float width = (shapeOptions.getViewBounds().width() + shapeOptions.getViewBounds().height() - shapeOptions.getBorderBounds().width()) / (float)2;
        this.mRadius = shapeOptions.getShapeBounds().width() < shapeOptions.getShapeBounds().height() ? shapeOptions.getShapeBounds().width() / (float)2 : shapeOptions.getShapeBounds().height() / (float)2;
        this.mSolidRadius = (shapeOptions.getBorderBounds().width() + width + (float)shapeOptions.getBorderWidth()) / (float)2;
        this.mBorderRadius = shapeOptions.getBorderBounds().width() < shapeOptions.getBorderBounds().height() ? shapeOptions.getBorderBounds().width() / (float)2 : shapeOptions.getBorderBounds().height() / (float)2;
        this.mSolidPaint.setStrokeWidth(width);
    }

    @Override
    protected void drawPaint(@NotNull Canvas canvas, @NotNull RectF shapeBounds, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.drawCircle(this.mCx, this.mCy, this.mRadius, this.getMBackPaint());
    }

    @Override
    protected void drawBorder(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds, @NotNull Paint borderPaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        Intrinsics.checkParameterIsNotNull((Object)borderPaint, (String)"borderPaint");
        canvas.drawCircle(this.mCx, this.mCy, this.mBorderRadius, this.getMBorderPaint());
    }

    @Override
    protected void drawSolid(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        canvas.drawCircle(this.mCx, this.mCy, this.mSolidRadius, this.mSolidPaint);
    }

    public SolidCircleShapeDrawer(@Nullable Drawable drawable) {
        super(drawable);
    }
}

