/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.imageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.stefanosiano.powerfullibraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerfullibraries.imageview.shape.drawers.BaseRoundedDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/CircleShapeDrawer;", "Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/BaseRoundedDrawer;", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "mBorderRadius", "", "mCx", "mCy", "mRadius", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "Landroid/graphics/RectF;", "shapeBounds", "imageBounds", "borderPaint", "Landroid/graphics/Paint;", "drawPaint", "bounds", "paint", "setup", "shapeOptions", "Lcom/stefanosiano/powerfullibraries/imageview/shape/ShapeOptions;", "powerfulimageview_release"})
public final class CircleShapeDrawer
extends BaseRoundedDrawer {
    private float mCx;
    private float mCy;
    private float mRadius;
    private float mBorderRadius;

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        super.setup(shapeOptions);
        this.mCx = shapeOptions.getShapeBounds().centerX();
        this.mCy = shapeOptions.getShapeBounds().centerY();
        this.mRadius = shapeOptions.getShapeBounds().width() < shapeOptions.getShapeBounds().height() ? shapeOptions.getShapeBounds().width() / (float)2 : shapeOptions.getShapeBounds().height() / (float)2;
        this.mBorderRadius = shapeOptions.getBorderBounds().width() < shapeOptions.getBorderBounds().height() ? shapeOptions.getBorderBounds().width() / (float)2 : shapeOptions.getBorderBounds().height() / (float)2;
    }

    @Override
    protected void drawPaint(@NotNull Canvas canvas, @NotNull RectF bounds, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.drawCircle(this.mCx, this.mCy, this.mRadius, paint);
    }

    @Override
    protected void drawBorder(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds, @NotNull Paint borderPaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        Intrinsics.checkParameterIsNotNull((Object)borderPaint, (String)"borderPaint");
        canvas.drawCircle(this.mCx, this.mCy, this.mBorderRadius, borderPaint);
    }

    public CircleShapeDrawer(@Nullable Bitmap bitmap) {
        super(bitmap);
    }
}

