/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.imageview.shape.drawers;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.stefanosiano.powerfullibraries.imageview.shape.PivShapeScaleType;
import com.stefanosiano.powerfullibraries.imageview.shape.ShapeOptions;
import com.stefanosiano.powerfullibraries.imageview.shape.drawers.ShapeDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J(\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J0\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0006H$J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0006H$J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/BaseRoundedDrawer;", "Lcom/stefanosiano/powerfullibraries/imageview/shape/drawers/ShapeDrawer;", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "mBackPaint", "Landroid/graphics/Paint;", "mBackgroundDrawable", "Landroid/graphics/drawable/Drawable;", "mBitmapPaint", "mBitmapShader", "Landroid/graphics/BitmapShader;", "mBorderPaint", "mForegroundDrawable", "mFrontPaint", "mMatrix", "Landroid/graphics/Matrix;", "changeBitmap", "", "changeDrawable", "drawable", "draw", "canvas", "Landroid/graphics/Canvas;", "borderBounds", "Landroid/graphics/RectF;", "shapeBounds", "imageBounds", "drawBorder", "borderPaint", "drawPaint", "bounds", "paint", "requireBitmap", "", "setMatrix", "scaleType", "Lcom/stefanosiano/powerfullibraries/imageview/shape/PivShapeScaleType;", "matrix", "setup", "shapeOptions", "Lcom/stefanosiano/powerfullibraries/imageview/shape/ShapeOptions;", "powerfulimageview_release"})
public abstract class BaseRoundedDrawer
implements ShapeDrawer {
    private BitmapShader mBitmapShader;
    private Paint mBitmapPaint;
    private Paint mBackPaint;
    private Paint mBorderPaint;
    private Paint mFrontPaint;
    private Drawable mBackgroundDrawable;
    private Drawable mForegroundDrawable;
    private Matrix mMatrix;

    @Override
    public void changeDrawable(@Nullable Drawable drawable) {
    }

    @Override
    public boolean requireBitmap() {
        return true;
    }

    @Override
    public void changeBitmap(@Nullable Bitmap bitmap) {
        this.mBitmapShader = null;
        if (bitmap != null) {
            BitmapShader bitmapShader = this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            if (bitmapShader != null) {
                bitmapShader.setLocalMatrix(this.mMatrix);
            }
        }
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void setMatrix(@NotNull PivShapeScaleType scaleType, @NotNull Matrix matrix) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)scaleType), (String)"scaleType");
            Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
            this.mMatrix = matrix;
            BitmapShader bitmapShader = this.mBitmapShader;
            if (bitmapShader == null) break block0;
            bitmapShader.setLocalMatrix(matrix);
        }
    }

    @Override
    public void setup(@NotNull ShapeOptions shapeOptions) {
        Intrinsics.checkParameterIsNotNull((Object)shapeOptions, (String)"shapeOptions");
        this.mForegroundDrawable = shapeOptions.getForegroundDrawable();
        this.mBackgroundDrawable = shapeOptions.getBackgroundDrawable();
        this.mBackPaint.setColor(shapeOptions.getBackgroundColor());
        this.mBackPaint.setAntiAlias(true);
        this.mBackPaint.setStyle(Paint.Style.FILL);
        this.mBorderPaint.setColor(shapeOptions.getBorderColor());
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)shapeOptions.getBorderWidth());
        this.mFrontPaint.setColor(shapeOptions.getForegroundColor());
        this.mFrontPaint.setAntiAlias(true);
        this.mFrontPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF borderBounds, @NotNull RectF shapeBounds, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)borderBounds, (String)"borderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shapeBounds, (String)"shapeBounds");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        if (this.mBackPaint.getColor() != 0) {
            this.drawPaint(canvas, shapeBounds, this.mBackPaint);
        }
        Drawable drawable = this.mBackgroundDrawable;
        if (drawable != null) {
            drawable.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
        }
        Drawable drawable2 = this.mBackgroundDrawable;
        if (drawable2 != null) {
            drawable2.draw(canvas);
        }
        this.drawPaint(canvas, imageBounds, this.mBitmapPaint);
        Drawable drawable3 = this.mForegroundDrawable;
        if (drawable3 != null) {
            drawable3.setBounds((int)imageBounds.left, (int)imageBounds.top, (int)imageBounds.right, (int)imageBounds.bottom);
        }
        Drawable drawable4 = this.mForegroundDrawable;
        if (drawable4 != null) {
            drawable4.draw(canvas);
        }
        if (this.mFrontPaint.getColor() != 0) {
            this.drawPaint(canvas, shapeBounds, this.mFrontPaint);
        }
        if (this.mBorderPaint.getStrokeWidth() > 0.0f && this.mBorderPaint.getColor() != 0) {
            this.drawBorder(canvas, borderBounds, shapeBounds, imageBounds, this.mBorderPaint);
        }
    }

    protected abstract void drawPaint(@NotNull Canvas var1, @NotNull RectF var2, @NotNull Paint var3);

    protected abstract void drawBorder(@NotNull Canvas var1, @NotNull RectF var2, @NotNull RectF var3, @NotNull RectF var4, @NotNull Paint var5);

    public BaseRoundedDrawer(@Nullable Bitmap bitmap) {
        block1: {
            this.mBitmapPaint = new Paint();
            this.mBackPaint = new Paint();
            this.mBorderPaint = new Paint();
            this.mFrontPaint = new Paint();
            if (bitmap == null) break block1;
            BitmapShader bitmapShader = this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            if (bitmapShader != null) {
                bitmapShader.setLocalMatrix(this.mMatrix);
            }
        }
    }
}

