/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.imageview.progress.drawers;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.stefanosiano.powerfullibraries.imageview.progress.ProgressOptions;
import com.stefanosiano.powerfullibraries.imageview.progress.drawers.ShadowDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stefanosiano/powerfullibraries/imageview/progress/drawers/RectangularShadowDrawer;", "Lcom/stefanosiano/powerfullibraries/imageview/progress/drawers/ShadowDrawer;", "()V", "mShadowBorderPaint", "Landroid/graphics/Paint;", "mShadowPaint", "draw", "", "canvas", "Landroid/graphics/Canvas;", "shadowBorderBounds", "Landroid/graphics/RectF;", "shadowBounds", "setup", "progressOptions", "Lcom/stefanosiano/powerfullibraries/imageview/progress/ProgressOptions;", "powerfulimageview_release"})
public final class RectangularShadowDrawer
implements ShadowDrawer {
    private Paint mShadowPaint = new Paint();
    private Paint mShadowBorderPaint = new Paint();

    @Override
    public void setup(@NotNull ProgressOptions progressOptions) {
        Intrinsics.checkParameterIsNotNull((Object)progressOptions, (String)"progressOptions");
        this.mShadowPaint.setColor(progressOptions.getShadowColor());
        this.mShadowPaint.setStrokeWidth(0.0f);
        this.mShadowPaint.setAntiAlias(true);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
        this.mShadowBorderPaint.setColor(progressOptions.getShadowBorderColor());
        this.mShadowBorderPaint.setStrokeWidth(progressOptions.getShadowBorderWidth());
        this.mShadowBorderPaint.setAntiAlias(true);
        this.mShadowBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull RectF shadowBorderBounds, @NotNull RectF shadowBounds) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)shadowBorderBounds, (String)"shadowBorderBounds");
        Intrinsics.checkParameterIsNotNull((Object)shadowBounds, (String)"shadowBounds");
        canvas.drawRect(shadowBounds.left, shadowBounds.top, shadowBounds.right, shadowBounds.bottom, this.mShadowPaint);
        canvas.drawRect(shadowBorderBounds.left, shadowBorderBounds.top, shadowBorderBounds.right, shadowBorderBounds.bottom, this.mShadowBorderPaint);
    }
}

