/*
 * Decompiled with CFR 0.152.
 */
package com.stefanosiano.powerfullibraries.imageview.blur.algorithms;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import com.stefanosiano.powerfullibraries.imageview.ScriptC_stackblur;
import com.stefanosiano.powerfullibraries.imageview.blur.BlurOptions;
import com.stefanosiano.powerfullibraries.imageview.blur.algorithms.BlurAlgorithm;
import com.stefanosiano.powerfullibraries.imageview.blur.algorithms.RenderscriptException;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0005H\u0016R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stefanosiano/powerfullibraries/imageview/blur/algorithms/StackRenderscriptBlurAlgorithm;", "Lcom/stefanosiano/powerfullibraries/imageview/blur/algorithms/BlurAlgorithm;", "()V", "renderscript", "Ljava/lang/ref/WeakReference;", "Landroidx/renderscript/RenderScript;", "blur", "Landroid/graphics/Bitmap;", "original", "radius", "", "options", "Lcom/stefanosiano/powerfullibraries/imageview/blur/BlurOptions;", "setRenderscript", "", "powerfulimageview_release"})
public final class StackRenderscriptBlurAlgorithm
implements BlurAlgorithm {
    private WeakReference<RenderScript> renderscript;

    @Override
    public void setRenderscript(@Nullable RenderScript renderscript) {
        this.renderscript = new WeakReference<RenderScript>(renderscript);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Bitmap blur(@NotNull Bitmap original, int radius, @NotNull BlurOptions options) throws RenderscriptException {
        Bitmap bitmap;
        void var19_18;
        int[] nArray;
        void var18_17;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        RenderScript renderScript = this.renderscript;
        if (renderScript == null || (renderScript = (RenderScript)renderScript.get()) == null) {
            throw (Throwable)new RenderscriptException("Renderscript is null!");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)renderScript, (String)"renderscript?.get() ?: t\u2026(\"Renderscript is null!\")");
        RenderScript rs = renderScript;
        int width = original.getWidth();
        int height = original.getHeight();
        ScriptC_stackblur blurScript = new ScriptC_stackblur(rs);
        Allocation inAllocation = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)original);
        blurScript.set_gIn(inAllocation);
        blurScript.set_width(width);
        blurScript.set_height(height);
        blurScript.set_radius(radius);
        int[] result$iv = new int[height];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            void i;
            void i$iv;
            n = i$iv;
            var18_17 = i$iv++;
            nArray = result$iv;
            var19_18 = i;
            nArray[var18_17] = var19_18;
        }
        int[] row_indices = result$iv;
        Allocation rows = Allocation.createSized((RenderScript)rs, (Element)Element.U32((RenderScript)rs), (int)height, (int)1);
        rows.copyFrom(row_indices);
        int[] result$iv2 = new int[width];
        n3 = 0;
        n = result$iv2.length;
        while (n3 < n) {
            void i;
            void i$iv;
            void $i$a$1$<init> = i$iv;
            var18_17 = i$iv++;
            nArray = result$iv2;
            var19_18 = i;
            nArray[var18_17] = var19_18;
        }
        row_indices = result$iv2;
        Allocation columns = Allocation.createSized((RenderScript)rs, (Element)Element.U32((RenderScript)rs), (int)width, (int)1);
        columns.copyFrom(row_indices);
        blurScript.forEach_blur_h(rows);
        blurScript.forEach_blur_v(columns);
        if (!options.isStaticBlur()) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            inAllocation.copyTo(bitmap2);
            inAllocation.destroy();
            rows.destroy();
            columns.destroy();
            Bitmap bitmap3 = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
            return bitmap3;
        }
        if (original.isMutable()) {
            inAllocation.copyTo(original);
            inAllocation.destroy();
            rows.destroy();
            columns.destroy();
            bitmap = original;
        } else {
            Bitmap bitmap4 = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            original.recycle();
            inAllocation.copyTo(bitmap4);
            inAllocation.destroy();
            rows.destroy();
            columns.destroy();
            Bitmap bitmap5 = bitmap4;
            bitmap = bitmap5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"bitmap");
        }
        return bitmap;
    }
}

