/*
 * Decompiled with CFR 0.152.
 */
package com.steelkiwi.library.view;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import com.steelkiwi.library.view.GradientDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J0\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0014J&\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/steelkiwi/library/view/SquareView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "drawable", "Lcom/steelkiwi/library/view/GradientDrawable;", "viewSize", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "prepareGradientDrawable", "startGradientColor", "endGradientColor", "cornerRadius", "updateGradientPosition", "position", "library_release"})
public final class SquareView
extends View {
    private GradientDrawable drawable;
    private int viewSize;

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        GradientDrawable gradientDrawable = this.drawable;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawable");
        }
        gradientDrawable.setBounds(0, 0, right - left, bottom - top);
    }

    public final void prepareGradientDrawable(int startGradientColor, int endGradientColor, int cornerRadius, int viewSize) {
        this.viewSize = viewSize;
        GradientDrawable gradientDrawable = this.drawable = new GradientDrawable(startGradientColor, endGradientColor, cornerRadius);
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawable");
        }
        gradientDrawable.prepareGradientSize(viewSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.viewSize, this.viewSize);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        GradientDrawable gradientDrawable = this.drawable;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawable");
        }
        gradientDrawable.draw(canvas);
    }

    public final void updateGradientPosition(int position) {
        GradientDrawable gradientDrawable = this.drawable;
        if (gradientDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawable");
        }
        gradientDrawable.setPositionOffset(position);
        this.invalidate();
    }

    public SquareView(@Nullable Context context) {
        super(context);
    }

    public SquareView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SquareView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }
}

