/*
 * Decompiled with CFR 0.152.
 */
package com.steelkiwi.library;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.steelkiwi.library.R;
import com.steelkiwi.library.StateController;
import com.steelkiwi.library.extensions.ExtensionsKt;
import com.steelkiwi.library.util.Constant;
import com.steelkiwi.library.util.way.WayCreator;
import com.steelkiwi.library.util.way.WayHolder;
import com.steelkiwi.library.util.way.WayType;
import com.steelkiwi.library.view.SquareView;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0019\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J \u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020&H\u0002J\b\u00101\u001a\u00020&H\u0016J\b\u00102\u001a\u00020&H\u0002J\b\u00103\u001a\u00020&H\u0002J\b\u00104\u001a\u00020&H\u0002J\u0012\u00105\u001a\u00020&2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u00106\u001a\u00020&H\u0002J\b\u00107\u001a\u00020&H\u0014J\u0012\u00108\u001a\u00020&2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u00109\u001a\u00020&H\u0002J\b\u0010:\u001a\u00020&H\u0002J\b\u0010;\u001a\u00020\u0017H\u0002J \u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010?\u001a\u00020&H\u0002J(\u0010@\u001a\u00020&2\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010A\u001a\u00020\nH\u0002J\b\u0010B\u001a\u00020&H\u0002J\b\u0010C\u001a\u00020&H\u0002J\b\u0010D\u001a\u00020&H\u0002J\b\u0010E\u001a\u00020&H\u0016J\b\u0010F\u001a\u00020&H\u0002R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/steelkiwi/library/SlidingSquareLoaderView;", "Landroid/widget/RelativeLayout;", "Lcom/steelkiwi/library/StateController;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "currentViewPosition", "currentWayPosition", "gradientPosition", "gradientsPosition", "", "parentBackground", "repeatHandler", "Landroid/os/Handler;", "squareViewSize", "squares", "Ljava/util/ArrayList;", "Lcom/steelkiwi/library/view/SquareView;", "stopAnimation", "", "viewCornerRadius", "viewEndGradientColor", "viewMargin", "viewStartGradientColor", "viewsPosition", "waitToFinish", "wayCreator", "Lcom/steelkiwi/library/util/way/WayCreator;", "ways", "Lcom/steelkiwi/library/util/way/WayHolder;", "waysPosition", "animateCurrentView", "", "animatePreviousView", "animateView", "view", "Landroid/view/View;", "way", "Landroid/graphics/Path;", "duration", "", "animateViewByLastWay", "animateViews", "hide", "increaseCurrentGradientPosition", "incrementCurrentViewPosition", "incrementCurrentWayPosition", "init", "initializeSquaresCollection", "onFinishInflate", "prepareAttributesSet", "prepareDefaultPositions", "prepareParentSettings", "prepareSquareViews", "prepareViews", "startX", "startY", "prepareViewsParameters", "prepareWayCreator", "viewWidth", "prepareWays", "repeatAnimations", "reset", "show", "updateViews", "library_release"})
public final class SlidingSquareLoaderView
extends RelativeLayout
implements StateController {
    private final Handler repeatHandler = new Handler();
    private WayCreator wayCreator;
    private final ArrayList<SquareView> squares = new ArrayList();
    private final ArrayList<WayHolder> ways = new ArrayList();
    private int[] viewsPosition;
    private int[] waysPosition;
    private int[] gradientsPosition;
    private int viewMargin;
    private int viewCornerRadius;
    private int viewStartGradientColor;
    private int viewEndGradientColor;
    private int parentBackground;
    private int currentWayPosition;
    private int currentViewPosition;
    private int gradientPosition;
    private int squareViewSize;
    private boolean stopAnimation = true;
    private boolean waitToFinish;

    private final void init(AttributeSet attrs) {
        this.prepareDefaultPositions();
        this.prepareAttributesSet(attrs);
        this.prepareParentSettings();
        this.prepareViewsParameters();
    }

    private final void prepareDefaultPositions() {
        int[] nArray = this.getResources().getIntArray(R.array.views_positions);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"resources.getIntArray(R.array.views_positions)");
        this.viewsPosition = nArray;
        int[] nArray2 = this.getResources().getIntArray(R.array.ways_position);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"resources.getIntArray(R.array.ways_position)");
        this.waysPosition = nArray2;
        int[] nArray3 = this.getResources().getIntArray(R.array.gradients_position);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray3, (String)"resources.getIntArray(R.array.gradients_position)");
        this.gradientsPosition = nArray3;
    }

    private final void prepareAttributesSet(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SlidingSquareLoaderView);
        this.viewMargin = typedArray.getDimensionPixelSize(R.styleable.SlidingSquareLoaderView_sslv_margin, this.getResources().getDimensionPixelSize(R.dimen.view_margin));
        this.viewCornerRadius = typedArray.getDimensionPixelSize(R.styleable.SlidingSquareLoaderView_sslv_margin, this.getResources().getDimensionPixelSize(R.dimen.view_margin));
        this.viewStartGradientColor = typedArray.getColor(R.styleable.SlidingSquareLoaderView_sslv_start_gradient_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.start_gradient_color));
        this.viewEndGradientColor = typedArray.getColor(R.styleable.SlidingSquareLoaderView_sslv_end_gradient_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.end_gradient_color));
        this.parentBackground = typedArray.getColor(R.styleable.SlidingSquareLoaderView_sslv_background_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.background));
        this.squareViewSize = typedArray.getDimensionPixelSize(R.styleable.SlidingSquareLoaderView_sslv_square_size, this.getResources().getDimensionPixelSize(R.dimen.square_size));
        typedArray.recycle();
    }

    private final void prepareWayCreator(int startX, int startY, int viewMargin, int viewWidth) {
        this.wayCreator = new WayCreator(startX, startY, viewMargin, viewWidth);
    }

    private final void prepareParentSettings() {
        this.setBackgroundColor(this.parentBackground);
    }

    private final void prepareViewsParameters() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ SlidingSquareLoaderView this$0;

            public void onGlobalLayout() {
                this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                SquareView view = (SquareView)((Object)SlidingSquareLoaderView.access$getSquares$p(this.this$0).get(0));
                int viewWidth = view.getWidth();
                int viewMargin = ExtensionsKt.getLeftMargin(view);
                int startX = this.this$0.getWidth() / 2 - (viewWidth + viewMargin) * Constant.INSTANCE.getVIEW_COUNT() / 2;
                int startY = this.this$0.getHeight() / 2 - viewWidth / 2;
                SlidingSquareLoaderView.access$prepareViews(this.this$0, startX, startY, viewMargin);
                SlidingSquareLoaderView.access$prepareWayCreator(this.this$0, startX, startY, viewMargin, viewWidth);
                SlidingSquareLoaderView.access$prepareWays(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareViews(int startX, int startY, int viewMargin) {
        Iterable $receiver$iv = this.squares;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void view;
            int n = index$iv++;
            SquareView squareView = (SquareView)((Object)item$iv);
            int index = n;
            view.setX((float)startX + (float)viewMargin + (float)(index * (view.getWidth() + viewMargin)));
            view.setY((float)startY);
            if (CollectionsKt.getLastIndex((List)this.squares) != index) continue;
            view.setX((float)startX + (float)viewMargin);
            view.setY((float)startY);
        }
    }

    private final void prepareWays() {
        WayCreator wayCreator = this.wayCreator;
        if (wayCreator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator.createWay(WayType.WAY_1));
        WayCreator wayCreator2 = this.wayCreator;
        if (wayCreator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator2.createWay(WayType.WAY_2));
        WayCreator wayCreator3 = this.wayCreator;
        if (wayCreator3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator3.createWay(WayType.WAY_3));
        WayCreator wayCreator4 = this.wayCreator;
        if (wayCreator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator4.createWay(WayType.WAY_4));
        WayCreator wayCreator5 = this.wayCreator;
        if (wayCreator5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator5.createWay(WayType.WAY_5));
        WayCreator wayCreator6 = this.wayCreator;
        if (wayCreator6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wayCreator");
        }
        this.ways.add(wayCreator6.createWay(WayType.WAY_6));
    }

    @Override
    public void show() {
        if (this.stopAnimation) {
            this.setVisibility(0);
            this.stopAnimation = false;
            this.animateViews();
        }
    }

    @Override
    public void hide() {
        this.waitToFinish = true;
        this.setVisibility(8);
    }

    private final void animateViews() {
        if (this.viewsPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
        }
        SquareView squareView = this.squares.get(this.viewsPosition[this.currentViewPosition]);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)squareView), (String)"squares[viewsPosition[currentViewPosition]]");
        View currentView = squareView;
        if (this.waysPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
        }
        Path currentWay = this.ways.get(this.waysPosition[this.currentWayPosition]).getCurrentWay();
        this.animateView(currentView, currentWay, Constant.INSTANCE.getCURRENT_DURATION());
    }

    private final void incrementCurrentViewPosition() {
        if (this.viewsPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
        }
        if (this.currentViewPosition < this.viewsPosition.length - 1) {
            int n = this.currentViewPosition;
            this.currentViewPosition = n + 1;
        } else {
            this.currentViewPosition = 0;
        }
    }

    private final void increaseCurrentGradientPosition() {
        if (this.gradientsPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gradientsPosition");
        }
        if (this.gradientPosition < this.gradientsPosition.length - 1) {
            int n = this.gradientPosition;
            this.gradientPosition = n + 1;
        } else {
            this.gradientPosition = 0;
        }
    }

    private final void incrementCurrentWayPosition() {
        if (this.waysPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
        }
        if (this.currentWayPosition < this.waysPosition.length - 1) {
            int n = this.currentWayPosition;
            this.currentWayPosition = n + 1;
        } else {
            this.currentWayPosition = 0;
        }
    }

    private final void repeatAnimations() {
        if (!this.stopAnimation) {
            this.repeatHandler.post(new Runnable(this){
                final /* synthetic */ SlidingSquareLoaderView this$0;

                public final void run() {
                    SlidingSquareLoaderView.access$incrementCurrentViewPosition(this.this$0);
                    SlidingSquareLoaderView.access$incrementCurrentWayPosition(this.this$0);
                    SlidingSquareLoaderView.access$increaseCurrentGradientPosition(this.this$0);
                    SlidingSquareLoaderView.access$animatePreviousView(this.this$0);
                    SlidingSquareLoaderView.access$animateCurrentView(this.this$0);
                }
                {
                    this.this$0 = slidingSquareLoaderView;
                }
            });
        }
    }

    private final void animateView(View view, Path way, long duration) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"x", (String)"y", (Path)way);
        objectAnimator.setDuration(duration);
        ObjectAnimator $receiver$iv = objectAnimator;
        $receiver$iv.addListener(new Animator.AnimatorListener(this){
            final /* synthetic */ SlidingSquareLoaderView this$0;
            {
                this.this$0 = slidingSquareLoaderView;
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (SlidingSquareLoaderView.access$getCurrentViewPosition$p(this.this$0) == 0 && SlidingSquareLoaderView.access$getWaitToFinish$p(this.this$0)) {
                    SlidingSquareLoaderView.access$setStopAnimation$p(this.this$0, true);
                    SlidingSquareLoaderView.access$setWaitToFinish$p(this.this$0, false);
                    SlidingSquareLoaderView.access$reset(this.this$0);
                }
                SlidingSquareLoaderView.access$repeatAnimations(this.this$0);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationStart(Animator animation) {
            }
        });
        objectAnimator.start();
    }

    private final void animateCurrentView() {
        if (this.viewsPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
        }
        SquareView currentView = this.squares.get(this.viewsPosition[this.currentViewPosition]);
        if (this.waysPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
        }
        Path currentWay = this.ways.get(this.waysPosition[this.currentWayPosition]).getCurrentWay();
        SquareView squareView = currentView;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)squareView), (String)"currentView");
        this.animateView(squareView, currentWay, Constant.INSTANCE.getCURRENT_DURATION());
    }

    private final void animatePreviousView() {
        if (this.currentViewPosition > 0 && this.currentWayPosition > 0) {
            if (this.viewsPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
            }
            SquareView previousView = this.squares.get(this.viewsPosition[this.currentViewPosition - 1]);
            if (this.gradientsPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gradientsPosition");
            }
            previousView.updateGradientPosition(-this.gradientsPosition[this.gradientPosition]);
            if (this.waysPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
            }
            Path lastWay = this.ways.get(this.waysPosition[this.currentWayPosition - 1]).getLastWay();
            SquareView squareView = previousView;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)squareView), (String)"previousView");
            this.animateViewByLastWay(squareView, lastWay, Constant.INSTANCE.getPREVIOUS_DURATION());
        } else {
            if (this.viewsPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
            }
            if (this.viewsPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewsPosition");
            }
            SquareView previousView = this.squares.get(this.viewsPosition[this.viewsPosition.length - 1]);
            if (this.gradientsPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gradientsPosition");
            }
            previousView.updateGradientPosition(-this.gradientsPosition[this.gradientPosition]);
            if (this.waysPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
            }
            if (this.waysPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"waysPosition");
            }
            Path lastWay = this.ways.get(this.waysPosition[this.waysPosition.length - 1]).getLastWay();
            SquareView squareView = previousView;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)squareView), (String)"previousView");
            this.animateViewByLastWay(squareView, lastWay, Constant.INSTANCE.getPREVIOUS_DURATION());
        }
    }

    private final void animateViewByLastWay(View view, Path way, long duration) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, (String)"x", (String)"y", (Path)way);
        objectAnimator.setDuration(duration);
        objectAnimator.start();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeSquaresCollection();
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeSquaresCollection() {
        int n = 1;
        int n2 = 5;
        if (n <= n2) {
            while (true) {
                void i;
                SquareView view = this.prepareSquareViews();
                this.squares.add(view);
                this.addView(view);
                if (i == n2) break;
                ++i;
            }
        }
        this.updateViews();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateViews() {
        Iterable $receiver$iv = this.squares;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void view;
            int n = index$iv++;
            SquareView squareView = (SquareView)((Object)item$iv);
            int index = n;
            if (index == this.squares.size() - 1) {
                view.updateGradientPosition(0);
                return;
            }
            view.updateGradientPosition(-index);
        }
    }

    private final SquareView prepareSquareViews() {
        SquareView view = new SquareView(this.getContext());
        view.prepareGradientDrawable(this.viewStartGradientColor, this.viewEndGradientColor, this.viewCornerRadius, this.squareViewSize);
        ExtensionsKt.setLeftMargin(view, this.viewMargin);
        return view;
    }

    private final void reset() {
        this.currentViewPosition = 0;
        this.currentWayPosition = 0;
        this.gradientPosition = 0;
    }

    public SlidingSquareLoaderView(@Nullable Context context) {
        super(context);
        this.init(null);
    }

    public SlidingSquareLoaderView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public SlidingSquareLoaderView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getSquares$p(SlidingSquareLoaderView $this) {
        return $this.squares;
    }

    public static final /* synthetic */ void access$prepareViews(SlidingSquareLoaderView $this, int startX, int startY, int viewMargin) {
        $this.prepareViews(startX, startY, viewMargin);
    }

    public static final /* synthetic */ void access$prepareWayCreator(SlidingSquareLoaderView $this, int startX, int startY, int viewMargin, int viewWidth) {
        $this.prepareWayCreator(startX, startY, viewMargin, viewWidth);
    }

    public static final /* synthetic */ void access$prepareWays(SlidingSquareLoaderView $this) {
        $this.prepareWays();
    }

    public static final /* synthetic */ void access$incrementCurrentViewPosition(SlidingSquareLoaderView $this) {
        $this.incrementCurrentViewPosition();
    }

    public static final /* synthetic */ void access$incrementCurrentWayPosition(SlidingSquareLoaderView $this) {
        $this.incrementCurrentWayPosition();
    }

    public static final /* synthetic */ void access$increaseCurrentGradientPosition(SlidingSquareLoaderView $this) {
        $this.increaseCurrentGradientPosition();
    }

    public static final /* synthetic */ void access$animatePreviousView(SlidingSquareLoaderView $this) {
        $this.animatePreviousView();
    }

    public static final /* synthetic */ void access$animateCurrentView(SlidingSquareLoaderView $this) {
        $this.animateCurrentView();
    }

    public static final /* synthetic */ int access$getCurrentViewPosition$p(SlidingSquareLoaderView $this) {
        return $this.currentViewPosition;
    }

    public static final /* synthetic */ void access$setCurrentViewPosition$p(SlidingSquareLoaderView $this, int n) {
        $this.currentViewPosition = n;
    }

    public static final /* synthetic */ boolean access$getWaitToFinish$p(SlidingSquareLoaderView $this) {
        return $this.waitToFinish;
    }

    public static final /* synthetic */ void access$setWaitToFinish$p(SlidingSquareLoaderView $this, boolean bl) {
        $this.waitToFinish = bl;
    }

    public static final /* synthetic */ boolean access$getStopAnimation$p(SlidingSquareLoaderView $this) {
        return $this.stopAnimation;
    }

    public static final /* synthetic */ void access$setStopAnimation$p(SlidingSquareLoaderView $this, boolean bl) {
        $this.stopAnimation = bl;
    }

    public static final /* synthetic */ void access$reset(SlidingSquareLoaderView $this) {
        $this.reset();
    }

    public static final /* synthetic */ void access$repeatAnimations(SlidingSquareLoaderView $this) {
        $this.repeatAnimations();
    }
}

