/*
 * Decompiled with CFR 0.152.
 */
package soulyaroslav.com.library.view.progress;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import soulyaroslav.com.library.R;
import soulyaroslav.com.library.view.progress.ProgressBarDrawable;

public class ProgressBarView
extends FrameLayout {
    private static final int DELAY = 90;
    private ProgressBarDrawable progressBarDrawable;
    private int alpha;
    private int alphaStep;

    public ProgressBarView(Context context) {
        super(context);
        this.init();
    }

    public ProgressBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ProgressBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.progressBarDrawable = new ProgressBarDrawable(this.getContext());
        this.prepareParentParams();
        this.setItemAlpha(255);
        this.setAlphaStep(14);
        this.setAlpha(0.0f);
    }

    private void prepareParentParams() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, (int)this.getResources().getDimension(R.dimen.progress_bar_height));
        params.addRule(12);
        this.setBackgroundResource(17170445);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        float angle = 0.0f;
        while ((double)angle < Math.PI * 2) {
            this.decreaseAlpha(this.getAlphaStep());
            this.progressBarDrawable.draw(canvas);
            this.progressBarDrawable.setAlpha(this.alpha);
            this.postInvalidateDelayed(90L);
            angle = (float)((double)angle + 0.17453292519943295);
        }
        canvas.restore();
    }

    public void setItemAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void decreaseAlpha(int step) {
        this.alpha -= step;
    }

    public int getAlphaStep() {
        return this.alphaStep;
    }

    public void setAlphaStep(int alphaStep) {
        this.alphaStep = alphaStep;
    }
}

