/*
 * Decompiled with CFR 0.152.
 */
package soulyaroslav.com.library.view.progress;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import soulyaroslav.com.library.R;

public class ProgressBarDrawable
extends Drawable {
    private Paint paint = new Paint();
    private RectF rectF = new RectF();
    private float height;
    private float width;
    private float offset;
    private float cornerRadius;

    public ProgressBarDrawable(Context context) {
        this.offset = context.getResources().getDimension(R.dimen.offset_top);
        this.height = context.getResources().getDimension(R.dimen.progress_item_height);
        this.width = context.getResources().getDimension(R.dimen.progress_item_width);
        this.cornerRadius = context.getResources().getDimension(R.dimen.rectangle_corner_radius);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(Color.argb((int)255, (int)0, (int)0, (int)0));
        this.paint.setAntiAlias(true);
    }

    public void draw(@NonNull Canvas canvas) {
        this.rectF.set((float)(canvas.getWidth() / 2) - this.width / 2.0f, this.offset, (float)(canvas.getWidth() / 2) + this.width / 2.0f, this.height);
        canvas.drawRoundRect(this.rectF, this.cornerRadius, this.cornerRadius, this.paint);
        canvas.rotate(20.0f, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

