/*
 * Decompiled with CFR 0.152.
 */
package soulyaroslav.com.library.view;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import soulyaroslav.com.library.CustomTouchListener;
import soulyaroslav.com.library.R;
import soulyaroslav.com.library.utils.AnimationUtils;
import soulyaroslav.com.library.view.progress.ProgressBarView;

public class RefreshContainer
extends FrameLayout {
    private RecyclerView recyclerView;
    private ProgressBarView progressBar;
    private OnRefreshListener listener;
    private boolean isRefreshOpen;
    private CustomTouchListener touchListener = new CustomTouchListener(this.getContext()){

        @Override
        public boolean onSwipeDown() {
            if (!RefreshContainer.this.isRefreshOpen() && RefreshContainer.this.isFirstItemVisible()) {
                RefreshContainer.this.setRefreshOpen(true);
                RefreshContainer.this.animateProgressStart();
                if (RefreshContainer.this.listener != null) {
                    RefreshContainer.this.listener.onRefresh();
                }
            }
            return false;
        }
    };

    public RefreshContainer(Context context) {
        super(context);
        this.init();
    }

    public RefreshContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RefreshContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setRefreshOpen(false);
        this.prepareRefreshLayout();
    }

    private void prepareRefreshLayout() {
        this.progressBar = new ProgressBarView(this.getContext());
        this.addView((View)this.progressBar);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View view = this.getChildAt(1);
        if (view instanceof RecyclerView) {
            this.recyclerView = (RecyclerView)this.getChildAt(1);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.touchListener.onTouch(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        this.touchListener.onTouch(event);
        return false;
    }

    private void animateProgressStart() {
        AnimationUtils.translateByY((View)this.recyclerView, this.getResources().getDimension(R.dimen.refresh_layout_bottom_margin), 900, (Interpolator)new OvershootInterpolator());
        AnimationUtils.alpha((View)this.progressBar, 1.0f, 700, (Interpolator)new AccelerateDecelerateInterpolator());
    }

    public void finishRefreshing() {
        AnimationUtils.translateByY((View)this.recyclerView, 0.0f, 900, (Interpolator)new OvershootInterpolator());
        AnimationUtils.translateByY((View)this.progressBar, 0.0f, 900, (Interpolator)new OvershootInterpolator());
        this.progressBar.setAlpha(0.0f);
        this.setRefreshOpen(false);
    }

    private boolean isFirstItemVisible() {
        return ((LinearLayoutManager)this.recyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition() == 0;
    }

    public boolean isRefreshOpen() {
        return this.isRefreshOpen;
    }

    public void setRefreshOpen(boolean refreshOpen) {
        this.isRefreshOpen = refreshOpen;
    }

    public void setListener(OnRefreshListener listener) {
        this.listener = listener;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

