/*
 * Decompiled with CFR 0.152.
 */
package soulyaroslav.com.library.utils;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;

public class AnimationUtils {
    public static ObjectAnimator translateByY(View view, float positionY, int duration, Interpolator interpolator) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{positionY});
        animator.setDuration((long)duration);
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.start();
        return animator;
    }

    public static ObjectAnimator translateByY(Drawable drawable, float positionY, int duration, Interpolator interpolator) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)drawable, (String)"translationY", (float[])new float[]{positionY});
        animator.setDuration((long)duration);
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.start();
        return animator;
    }

    public static ObjectAnimator translateByX(View view, float positionX, int duration) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{positionX});
        animator.setDuration((long)duration);
        animator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        animator.start();
        return animator;
    }

    public static ObjectAnimator rotate(View view, float startDegree, float endDegree, int duration) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{startDegree, endDegree});
        animator.setDuration((long)duration);
        animator.setRepeatCount(-1);
        animator.start();
        return animator;
    }

    public static ObjectAnimator rotateByY(View view, float startDegree, float endDegree, int duration) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"rotationY", (float[])new float[]{startDegree, endDegree});
        animator.setDuration((long)duration);
        animator.setRepeatCount(-1);
        animator.start();
        return animator;
    }

    public static ObjectAnimator alpha(View view, float alpha, int duration, Interpolator interpolator) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alpha});
        animator.setDuration((long)duration);
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.start();
        return animator;
    }

    public static ObjectAnimator alpha(Drawable drawable, float alpha, int duration, Interpolator interpolator) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)drawable, (String)"alpha", (float[])new float[]{alpha});
        animator.setDuration((long)duration);
        animator.setInterpolator((TimeInterpolator)interpolator);
        animator.start();
        return animator;
    }
}

