/*
 * Decompiled with CFR 0.152.
 */
package soulyaroslav.com.library;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;

public abstract class CustomTouchListener {
    private final GestureDetector gestureDetector;

    public CustomTouchListener(Context context) {
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public boolean onTouch(MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event);
    }

    public abstract boolean onSwipeDown();

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_THRESHOLD = 100;
        private static final int SWIPE_VELOCITY_THRESHOLD = 100;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            boolean result = false;
            try {
                float diffX = e2.getX() - e1.getX();
                float diffY = e2.getY() - e1.getY();
                if (Math.abs(diffY) > 100.0f && Math.abs(velocityY) > 100.0f && diffY > 0.0f) {
                    result = CustomTouchListener.this.onSwipeDown();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return result;
        }
    }
}

