/*
 * Decompiled with CFR 0.152.
 */
package steelkiwi.com.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import steelkiwi.com.library.R;

public class DotsLoaderView
extends RelativeLayout {
    private static final int START_DELAY = 120;
    private static final int REPEAT_ANIMATION_DELAY = 1800;
    private static final int TRANSLATION_DELAY = 1200;
    private static final int SCALE_DELAY = 500;
    private static final int ITEM_SIZE = 3;
    private Paint backgroundPaint;
    private Path fullPath;
    private List<View> points = new ArrayList<View>();
    private Handler handler;
    private int startDelay = 0;
    private boolean isLastView = false;
    private int viewWidth;
    private int viewHeight;
    private int arcWidth;
    private int arcHeight;
    private int bottomLineMargin;
    private int lineWidth;
    private boolean isStop;
    private int lineColor;
    private Drawable drawable;
    private boolean isAnimationFinish;
    private Runnable repeatRunnable = new Runnable(){

        @Override
        public void run() {
            DotsLoaderView.this.animateViews();
        }
    };

    public DotsLoaderView(Context context) {
        super(context);
        this.init(null);
    }

    public DotsLoaderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DotsLoaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.handler = new Handler();
        this.prepareParameters(attrs);
        this.prepareSize();
        this.initializePaints();
        this.initializePath();
        this.preparePath();
        this.setAnimationFinish(true);
        this.setStop(false);
    }

    private void prepareParameters(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.DotsLoaderView);
        this.setLineColor(typedArray.getInt(R.styleable.DotsLoaderView_dlv_line_color, 0));
        this.setDrawable(typedArray.getDrawable(R.styleable.DotsLoaderView_dlv_item_drawable));
        typedArray.recycle();
    }

    private void prepareSize() {
        this.setViewWidth(this.getResources().getDisplayMetrics().widthPixels);
        this.setViewHeight(this.getResources().getDisplayMetrics().heightPixels);
        this.setArcWidth(this.getResources().getDimensionPixelSize(R.dimen.arc_width));
        this.setArcHeight(this.getResources().getDimensionPixelSize(R.dimen.arc_height));
        this.setBottomLineMargin(this.getResources().getDimensionPixelSize(R.dimen.bottom_line_margin));
        this.setLineWidth(this.getResources().getDimensionPixelSize(R.dimen.line_width));
    }

    private void initializePaints() {
        this.setBackgroundResource(17170445);
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(this.getLineColor());
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
    }

    private void initializePath() {
        this.fullPath = new Path();
    }

    private void preparePath() {
        int centerX = this.getViewWidth() / 2;
        int centerY = this.getViewHeight() / 2;
        int startX = centerX - this.getArcWidth();
        int startY = centerY - this.getArcHeight();
        this.fullPath.moveTo((float)startX, (float)startY);
        this.fullPath.quadTo((float)(centerX - this.getArcHeight()), (float)startY, (float)centerX, (float)centerY);
        this.fullPath.moveTo((float)centerX, (float)centerY);
        this.fullPath.quadTo((float)(centerX + this.getArcHeight()), (float)startY, (float)(centerX + this.getArcWidth()), (float)startY);
    }

    private void preparePointViews() {
        for (int i = 0; i < 3; ++i) {
            View view = this.inflateView();
            this.prepareViewScale(view, 0.0f);
            this.points.add(view);
            this.addView(view);
        }
    }

    private View inflateView() {
        return LayoutInflater.from((Context)this.getContext()).inflate(R.layout.circle_layout, (ViewGroup)this, false);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.preparePointViews();
    }

    public void show() {
        if (this.isAnimationFinish()) {
            this.setVisibility(0);
            this.setStop(false);
            this.animateViews();
            this.setAnimationFinish(false);
        }
    }

    public void hide() {
        this.setStop(true);
        this.setAnimationFinish(true);
        this.handler.removeCallbacks(this.repeatRunnable);
    }

    public void animateViews() {
        if (!this.isStop()) {
            this.setStartDelay(0);
            for (int i = 0; i < this.points.size(); ++i) {
                View view = this.getView(i);
                this.prepareViewScale(view, 0.0f);
                this.translateView(view, this.getStartDelay());
                this.scaleViewX(view, this.getStartDelay());
                this.scaleViewY(view, this.getStartDelay());
                this.startDelay += 120;
                this.manageLastView(i);
            }
            this.repeatAnimation();
        }
    }

    private void repeatAnimation() {
        this.handler.postDelayed(this.repeatRunnable, 1800L);
    }

    private void prepareViewScale(View view, float scale) {
        view.setBackground(this.getDrawable());
        view.setScaleX(scale);
        view.setScaleY(scale);
    }

    private void translateView(View view, int startDelay) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"x", (String)"y", (Path)this.fullPath).setDuration(1200L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.setStartDelay((long)startDelay);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (DotsLoaderView.this.isLastView() && DotsLoaderView.this.isStop()) {
                    DotsLoaderView.this.setVisibility(8);
                }
            }
        });
        animator.start();
    }

    private void scaleViewX(final View view, final int startDelay) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.setStartDelay((long)startDelay);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.0f});
                animator.setDuration(500L);
                animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                animator.setStartDelay((long)startDelay);
                animator.start();
            }
        });
        animator.start();
    }

    private void scaleViewY(final View view, final int startDelay) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.setStartDelay((long)startDelay);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.0f});
                animator.setDuration(500L);
                animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                animator.setStartDelay((long)startDelay);
                animator.start();
            }
        });
        animator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBottomLine(canvas);
    }

    private void drawBottomLine(Canvas canvas) {
        for (int i = 0; i < this.points.size(); ++i) {
            View view = this.getView(i);
            float width = (float)this.getLineWidth() * view.getScaleX();
            float centerX = view.getX() + (float)(view.getWidth() / 2);
            float startX = centerX - width / 2.0f;
            float startY = this.getViewHeight() / 2 + this.getBottomLineMargin();
            float endX = centerX + width / 2.0f;
            float endY = this.getViewHeight() / 2 + this.getBottomLineMargin();
            canvas.drawLine(startX, startY, endX, endY, this.backgroundPaint);
        }
        this.postInvalidateDelayed(10L);
    }

    private void manageLastView(int position) {
        if (position == this.points.size() - 1) {
            this.setLastView(true);
        }
    }

    private View getView(int position) {
        return this.points.get(position);
    }

    private void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    private int getStartDelay() {
        return this.startDelay;
    }

    private boolean isLastView() {
        return this.isLastView;
    }

    private void setLastView(boolean lastView) {
        this.isLastView = lastView;
    }

    private int getViewWidth() {
        return this.viewWidth;
    }

    private void setViewWidth(int viewWidth) {
        this.viewWidth = viewWidth;
    }

    private int getViewHeight() {
        return this.viewHeight;
    }

    private void setViewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
    }

    private int getArcWidth() {
        return this.arcWidth;
    }

    private void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    private int getArcHeight() {
        return this.arcHeight;
    }

    private void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    private int getBottomLineMargin() {
        return this.bottomLineMargin;
    }

    private void setBottomLineMargin(int bottomLineMargin) {
        this.bottomLineMargin = bottomLineMargin;
    }

    private int getLineWidth() {
        return this.lineWidth;
    }

    private void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    private boolean isStop() {
        return this.isStop;
    }

    private void setStop(boolean stop) {
        this.isStop = stop;
    }

    private int getLineColor() {
        return this.lineColor;
    }

    private void setLineColor(int lineColor) {
        this.lineColor = lineColor;
    }

    private Drawable getDrawable() {
        return this.drawable;
    }

    private void setDrawable(Drawable drawable) {
        this.drawable = drawable;
    }

    private boolean isAnimationFinish() {
        return this.isAnimationFinish;
    }

    private void setAnimationFinish(boolean animationFinish) {
        this.isAnimationFinish = animationFinish;
    }
}

