/*
 * Decompiled with CFR 0.152.
 */
package com.starcut.starflight_client_android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.starcut.starflight_client_android.MessageOpenedResponse;
import com.starcut.starflight_client_android.RegistrationResponse;
import com.starcut.starflight_client_android.StarFlightCallback;
import com.starcut.starflight_client_android.StarFlightResponse;
import com.starcut.starflight_client_android.UnregistrationResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class StarFlightClient {
    public static final String TEXT_KEY = "text";
    public static final String URL_KEY = "url";
    public static final String SUBJECT_KEY = "subject";
    private static final String PUSH_SERVER_URL = "https://starflight.starcloud.us/push";
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;
    private static final long REGISTRATION_REFRESH_INTERVAL = 864000000L;
    private static final String LOG_TAG = "StarFlight Push Client";
    private static final int KEY_VERSION = 1;
    private static final String PROPERTY_REGISTRATION_ID = "registration_id_1";
    private static final String PROPERTY_CLIENT_UUID = "client_uuid_1";
    private static final String PROPERTY_LAST_SENT_REG_ID = "last_sent_registration_id_1";
    private static final String PROPERTY_LAST_REGISTRATION_TIME = "last_registration_time_1";
    private static final String PROPERTY_REGISTERED_TAGS = "registered_tags_1";
    private static final String PROPERTY_OPENED_MESSAGES = "opened_messages_1";
    private static final Handler CALLBACK_HANDLER = new Handler(Looper.getMainLooper());
    private final String senderId;
    private final String appId;
    private final String clientSecret;

    public StarFlightClient(String senderId, String appId, String clientSecret) {
        this.senderId = senderId;
        this.appId = appId;
        this.clientSecret = clientSecret;
    }

    public void register(Activity activity, StarFlightCallback<RegistrationResponse> callback) {
        this.register(activity, null, callback);
    }

    public void refreshRegistration(Activity activity) {
        if (!this.isRegistered((Context)activity)) {
            throw new IllegalStateException("Not registered");
        }
        SharedPreferences preferences = this.getStarFlightPreferences((Context)activity);
        String registeredTags = preferences.getString(PROPERTY_REGISTERED_TAGS, null);
        List<String> tags = registeredTags == null ? Collections.emptyList() : Arrays.asList(registeredTags.split(","));
        Log.d((String)"NOTIF", (String)("Registered flags to refresh " + tags));
        this.register(activity, tags, null);
    }

    public void register(Activity activity, List<String> tags, StarFlightCallback<RegistrationResponse> callback) {
        if (StarFlightClient.checkPlayServices(activity)) {
            Context context = activity.getApplicationContext();
            String registrationId = this.getRegistrationId(context);
            if (registrationId == null) {
                this.getRegistrationIdInBackground(context, tags, callback);
            } else {
                this.sendRegistrationIdIfNeeded(context, tags, callback);
            }
        }
    }

    public void unregister(Activity activity, StarFlightCallback<UnregistrationResponse> callback) {
        this.unregister(activity, null, callback);
    }

    public void unregister(Activity activity, List<String> tags, StarFlightCallback<UnregistrationResponse> callback) {
        if (StarFlightClient.checkPlayServices(activity)) {
            Context context = activity.getApplicationContext();
            String registrationId = this.getRegistrationId(context);
            if (registrationId == null) {
                UnregistrationResponse response = new UnregistrationResponse(UnregistrationResponse.Result.NOT_REGISTERED);
                StarFlightClient.callOnSuccess(callback, response);
                return;
            }
            this.sendUnregistrationInBackground(context, tags, callback);
        }
    }

    private void sendUnregistrationInBackground(final Context context, List<String> tags, final StarFlightCallback<UnregistrationResponse> callback) {
        final String registrationId = this.getRegistrationId(context);
        new AsyncTask<List<String>, Void, Void>(){

            protected Void doInBackground(List<String> ... params) {
                List<String> tags = params[0];
                UnregistrationResponse response = null;
                if (tags != null && tags.size() > 0) {
                    try {
                        response = StarFlightClient.this.sendUnregistrationToBackend(registrationId, tags);
                        StarFlightClient.this.removeTagsFromStorage(context, tags);
                    }
                    catch (IOException e) {
                        StarFlightClient.callOnFailure(callback, "Unregistration failed: " + e.getMessage(), e);
                    }
                } else {
                    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)context);
                    try {
                        response = StarFlightClient.this.sendUnregistrationToBackend(registrationId, null);
                        StarFlightClient.this.removeRegistrationFromStorage(context);
                        gcm.unregister();
                    }
                    catch (IOException ex) {
                        StarFlightClient.callOnFailure(callback, "Unregistration failed: " + ex.getMessage(), ex);
                    }
                }
                if (response != null) {
                    StarFlightClient.callOnSuccess(callback, response);
                }
                return null;
            }
        }.execute((Object[])new List[]{tags});
    }

    private void sendRegistrationIdIfNeeded(final Context context, List<String> tags, final StarFlightCallback<RegistrationResponse> callback) {
        if (tags == null) {
            tags = Collections.emptyList();
        }
        Collections.sort(tags);
        SharedPreferences preferences = this.getStarFlightPreferences(context);
        String lastSentId = preferences.getString(PROPERTY_LAST_SENT_REG_ID, "");
        long lastRegistrationTime = preferences.getLong(PROPERTY_LAST_REGISTRATION_TIME, -1L);
        String registeredTags = preferences.getString(PROPERTY_REGISTERED_TAGS, "");
        final String registrationId = this.getRegistrationId(context);
        boolean shouldSend = lastRegistrationTime == -1L || System.currentTimeMillis() - lastRegistrationTime > 864000000L ? true : (!lastSentId.equals(registrationId) ? true : !registeredTags.equals(StarFlightClient.join(tags, ",")));
        if (shouldSend) {
            new AsyncTask<List<String>, Void, Void>(){

                protected Void doInBackground(List<String> ... params) {
                    List<String> tags = null;
                    if (params.length > 0) {
                        tags = params[0];
                    }
                    RegistrationResponse response = null;
                    try {
                        response = StarFlightClient.this.sendRegistrationIdToBackend(registrationId, tags);
                        StarFlightClient.this.storeRegistration(context, registrationId, tags, response.getClientUuid());
                    }
                    catch (IOException e) {
                        StarFlightClient.callOnFailure(callback, "Failed to send registration id to StarFlight: " + e.getMessage(), e);
                    }
                    catch (JSONException e) {
                        StarFlightClient.callOnFailure(callback, "Failed to parse server response: " + e.getMessage(), e);
                    }
                    if (response != null) {
                        StarFlightClient.callOnSuccess(callback, response);
                    }
                    return null;
                }
            }.execute((Object[])new List[]{tags, null, null});
        } else {
            RegistrationResponse response = new RegistrationResponse(this.getClientUuid(context), RegistrationResponse.Result.ALREADY_REGISTERED);
            StarFlightClient.callOnSuccess(callback, response);
            Log.i((String)LOG_TAG, (String)"already registered and refreshing was not necessary");
        }
    }

    private static boolean checkPlayServices(Activity activity) {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
        if (resultCode != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode)) {
                GooglePlayServicesUtil.getErrorDialog((int)resultCode, (Activity)activity, (int)9000).show();
            } else {
                Log.e((String)LOG_TAG, (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private String getRegistrationId(Context context) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        return prefs.getString(PROPERTY_REGISTRATION_ID, null);
    }

    public UUID getClientUuid(Context context) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        String uuid = prefs.getString(PROPERTY_CLIENT_UUID, null);
        return uuid == null ? null : UUID.fromString(uuid);
    }

    private SharedPreferences getStarFlightPreferences(Context context) {
        return context.getSharedPreferences(StarFlightClient.class.getSimpleName(), 0);
    }

    private void getRegistrationIdInBackground(final Context context, List<String> tags, final StarFlightCallback<RegistrationResponse> callback) {
        new AsyncTask<List<String>, Void, Void>(){

            protected Void doInBackground(List<String> ... params) {
                try {
                    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)context);
                    String registrationId = gcm.register(new String[]{StarFlightClient.this.senderId});
                    List<String> tags = null;
                    if (params.length > 0) {
                        tags = params[0];
                    }
                    RegistrationResponse response = StarFlightClient.this.sendRegistrationIdToBackend(registrationId, tags);
                    StarFlightClient.this.storeRegistration(context, registrationId, tags, response.getClientUuid());
                    StarFlightClient.callOnSuccess(callback, response);
                }
                catch (IOException ex) {
                    StarFlightClient.callOnFailure(callback, "Registration failed: " + ex.getMessage(), ex);
                }
                catch (JSONException ex) {
                    StarFlightClient.callOnFailure(callback, "Failed to parse registration response: " + ex.getMessage(), ex);
                }
                return null;
            }
        }.execute((Object[])new List[]{tags, null, null});
    }

    private UnregistrationResponse sendUnregistrationToBackend(String registrationId, List<String> tags) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(PUSH_SERVER_URL);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("action", "unregister"));
        nameValuePairs.add(new BasicNameValuePair("appId", this.appId));
        nameValuePairs.add(new BasicNameValuePair("clientSecret", this.clientSecret));
        nameValuePairs.add(new BasicNameValuePair("type", "android"));
        nameValuePairs.add(new BasicNameValuePair("token", registrationId));
        if (tags != null && tags.size() > 0) {
            nameValuePairs.add(new BasicNameValuePair("tags", StarFlightClient.join(tags, ",")));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
        HttpResponse response = client.execute((HttpUriRequest)post);
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IOException("Unexpected HTTP response code: " + code);
        }
        Log.i((String)LOG_TAG, (String)"Unregistration successful");
        return new UnregistrationResponse(UnregistrationResponse.Result.OK);
    }

    private RegistrationResponse sendRegistrationIdToBackend(String registrationId, List<String> tags) throws IOException, JSONException {
        RegistrationResponse.Result result;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(PUSH_SERVER_URL);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("action", "register"));
        nameValuePairs.add(new BasicNameValuePair("appId", this.appId));
        nameValuePairs.add(new BasicNameValuePair("clientSecret", this.clientSecret));
        nameValuePairs.add(new BasicNameValuePair("type", "android"));
        nameValuePairs.add(new BasicNameValuePair("token", registrationId));
        if (tags != null && tags.size() > 0) {
            nameValuePairs.add(new BasicNameValuePair("tags", StarFlightClient.join(tags, ",")));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
        HttpResponse response = client.execute((HttpUriRequest)post);
        int code = response.getStatusLine().getStatusCode();
        String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
        if (code == 201) {
            result = RegistrationResponse.Result.REGISTERED;
            Log.i((String)LOG_TAG, (String)"Registered push client");
        } else if (code == 200) {
            result = RegistrationResponse.Result.REFRESHED;
            Log.i((String)LOG_TAG, (String)"Push client registration refreshed");
        } else {
            throw new IOException("Unexpected HTTP response code: " + code + ", response text: " + responseText);
        }
        JSONObject json = new JSONObject(responseText);
        UUID clientUuid = UUID.fromString(json.getString("clientUuid"));
        return new RegistrationResponse(clientUuid, result);
    }

    private void storeRegistration(Context context, String registrationId, List<String> tags, UUID clientUuid) {
        if (tags == null) {
            tags = Collections.emptyList();
        }
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        Log.i((String)LOG_TAG, (String)("Saving GCM registration id " + registrationId));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REGISTRATION_ID, registrationId);
        editor.putString(PROPERTY_LAST_SENT_REG_ID, registrationId);
        editor.putLong(PROPERTY_LAST_REGISTRATION_TIME, System.currentTimeMillis());
        editor.putString(PROPERTY_REGISTERED_TAGS, StarFlightClient.join(tags, ","));
        editor.putString(PROPERTY_CLIENT_UUID, clientUuid.toString());
        editor.apply();
    }

    private void removeRegistrationFromStorage(Context context) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.apply();
    }

    private void removeTagsFromStorage(Context context, List<String> tags) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        if (tags != null && tags.size() > 0) {
            ArrayList<String> previousTags = new ArrayList<String>(Arrays.asList(prefs.getString(PROPERTY_REGISTERED_TAGS, "").split(",")));
            for (String tag : tags) {
                previousTags.remove(tag);
            }
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(PROPERTY_REGISTERED_TAGS, StarFlightClient.join(previousTags, ","));
            editor.apply();
        } else {
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove(PROPERTY_REGISTERED_TAGS);
            editor.apply();
        }
    }

    private static String join(List<String> list, String separator) {
        if (list != null && list.size() > 0) {
            StringBuilder joined = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                joined.append(list.get(i));
                if (i >= list.size() - 1) continue;
                joined.append(separator);
            }
            return joined.toString();
        }
        return null;
    }

    public boolean isRegistered(Context context) {
        return this.getRegistrationId(context) != null;
    }

    public void messageOpened(final Context context, final UUID messageUuid, final StarFlightCallback<MessageOpenedResponse> callback) {
        if (this.isMessageOpened(context, messageUuid)) {
            StarFlightClient.callOnSuccess(callback, new MessageOpenedResponse(MessageOpenedResponse.Result.ALREADY_OPENED));
            return;
        }
        final String registrationId = this.getRegistrationId(context);
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    DefaultHttpClient client = new DefaultHttpClient();
                    HttpPost post = new HttpPost(StarFlightClient.PUSH_SERVER_URL);
                    ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                    nameValuePairs.add(new BasicNameValuePair("action", "message_opened"));
                    nameValuePairs.add(new BasicNameValuePair("appId", StarFlightClient.this.appId));
                    nameValuePairs.add(new BasicNameValuePair("clientSecret", StarFlightClient.this.clientSecret));
                    nameValuePairs.add(new BasicNameValuePair("type", "android"));
                    nameValuePairs.add(new BasicNameValuePair("token", registrationId));
                    nameValuePairs.add(new BasicNameValuePair("uuid", messageUuid.toString()));
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                    HttpResponse response = client.execute((HttpUriRequest)post);
                    int code = response.getStatusLine().getStatusCode();
                    if (code != 200) {
                        throw new IOException("Unexpected HTTP response code: " + code + ", response text: " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    }
                    StarFlightClient.this.storeMessageOpened(context, messageUuid);
                    StarFlightClient.callOnSuccess(callback, new MessageOpenedResponse(MessageOpenedResponse.Result.OK));
                }
                catch (IOException ex) {
                    StarFlightClient.callOnFailure(callback, "Recording message open failed: " + ex.getMessage(), ex);
                }
                return null;
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    private boolean isMessageOpened(Context context, UUID messageUuid) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        return Arrays.asList(prefs.getString(PROPERTY_OPENED_MESSAGES, "").split(",")).contains(messageUuid.toString());
    }

    private void storeMessageOpened(Context context, UUID messageUuid) {
        SharedPreferences prefs = this.getStarFlightPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        List<String> openedMessageUuids = Arrays.asList(prefs.getString(PROPERTY_OPENED_MESSAGES, "").split(","));
        if (!openedMessageUuids.contains(messageUuid.toString())) {
            String newValue = StarFlightClient.join(openedMessageUuids, ",") + (openedMessageUuids.size() == 0 ? "" : ",") + messageUuid;
            editor.putString(PROPERTY_OPENED_MESSAGES, newValue);
        }
        editor.apply();
    }

    private static <T extends StarFlightResponse> void callOnSuccess(final StarFlightCallback<T> callback, final T response) {
        if (callback == null) {
            return;
        }
        CALLBACK_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(response);
            }
        });
    }

    private static void callOnFailure(final StarFlightCallback<? extends StarFlightResponse> callback, final String message, final Throwable t) {
        if (callback == null) {
            return;
        }
        CALLBACK_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(message, t);
            }
        });
    }
}

