/*
 * Decompiled with CFR 0.152.
 */
package com.stanfy.gsonxml;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Primitives;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.stanfy.gsonxml.XmlParserCreator;
import com.stanfy.gsonxml.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;

public final class GsonXml {
    private final Gson core;
    private final XmlParserCreator xmlParserCreator;
    private final XmlReader.Options options;

    GsonXml(Gson gson, XmlParserCreator xmlParserCreator, XmlReader.Options options) {
        if (xmlParserCreator == null) {
            throw new NullPointerException("XmlParserCreator is null");
        }
        this.core = gson;
        this.xmlParserCreator = xmlParserCreator;
        this.options = options;
    }

    public Gson getGson() {
        return this.core;
    }

    public <T> T fromXml(String json, Class<T> classOfT) throws JsonSyntaxException {
        T object = this.fromXml(json, (Type)classOfT);
        return Primitives.wrap(classOfT).cast(object);
    }

    public <T> T fromXml(String json, Type typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        StringReader reader = new StringReader(json);
        T target = this.fromXml((Reader)reader, typeOfT);
        return target;
    }

    public <T> T fromXml(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        XmlReader jsonReader = new XmlReader(json, this.xmlParserCreator, this.options);
        T object = this.fromXml(jsonReader, classOfT);
        GsonXml.assertFullConsumption(object, jsonReader);
        return Primitives.wrap(classOfT).cast(object);
    }

    public <T> T fromXml(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        XmlReader jsonReader = new XmlReader(json, this.xmlParserCreator, this.options);
        T object = this.fromXml(jsonReader, typeOfT);
        GsonXml.assertFullConsumption(object, jsonReader);
        return object;
    }

    private static void assertFullConsumption(Object obj, JsonReader reader) {
        try {
            if (obj != null && reader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public <T> T fromXml(XmlReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)this.core.fromJson((JsonReader)reader, typeOfT);
    }

    public String toString() {
        return this.core.toString();
    }
}

