/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class XAuthorityFile {
    private static final String COOKIE_TYPE_NAME = "MIT-MAGIC-COOKIE-1";
    private byte[] data;
    private final int screen;
    private final String hostname;
    private final File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAuthorityFile(File file, String hostname, int screen) throws IOException {
        this.hostname = hostname;
        this.file = file;
        this.screen = screen;
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            DataInputStream din = new DataInputStream(in);
            try {
                while (din.available() > 0) {
                    short family = din.readShort();
                    short len = din.readShort();
                    byte[] address = new byte[len];
                    din.readFully(address);
                    len = din.readShort();
                    byte[] number = new byte[len];
                    din.readFully(number);
                    len = din.readShort();
                    byte[] name = new byte[len];
                    din.readFully(name);
                    len = din.readShort();
                    byte[] data = new byte[len];
                    din.readFully(data);
                    String n = new String(number);
                    int d = Integer.parseInt(n);
                    String protocol = new String(name);
                    if (!protocol.equals(COOKIE_TYPE_NAME)) continue;
                    if (family == 0) {
                        String ip = (address[0] & 0xFF) + "." + (address[1] & 0xFF) + "." + (address[2] & 0xFF) + "." + (address[3] & 0xFF);
                        InetAddress addr = InetAddress.getByName(ip);
                        if (!addr.getHostAddress().equals(hostname) && !addr.getHostName().equals(hostname) || screen != d) continue;
                        this.data = data;
                    } else {
                        String h;
                        if (family != 256 || !(h = new String(address)).equals(hostname) || screen != d) continue;
                        this.data = data;
                    }
                    break;
                }
            }
            finally {
                din.close();
            }
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(boolean append) throws IOException {
        FileOutputStream fout = new FileOutputStream(this.file, append);
        try {
            DataOutputStream dout = new DataOutputStream(fout);
            dout.writeShort(256);
            dout.writeShort(this.hostname.length());
            dout.writeBytes(this.hostname);
            String screenNo = String.valueOf(this.screen);
            dout.writeShort(screenNo.length());
            dout.writeBytes(screenNo);
            dout.writeShort(COOKIE_TYPE_NAME.length());
            dout.writeBytes(COOKIE_TYPE_NAME);
            dout.writeShort(this.data.length);
            dout.write(this.data);
        }
        finally {
            fout.close();
        }
    }
}

