/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.sftp.SftpFile;

public class Util {
    public static final int S_IFMT = 61440;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;

    public static String toDelimited(String[] arr, char delimiter) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(delimiter);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static boolean promptYesNo(String message) {
        String answer = Util.prompt(message + " - (Y)es or (N)o?");
        return answer != null && (answer.toLowerCase().equals("y") || answer.toLowerCase().equals("yes"));
    }

    public static String prompt(String message) {
        message = message.trim();
        System.out.print(message + (message.endsWith(":") ? " " : ": "));
        try {
            return Util.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String formatAsHexString(byte[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            buf.append(Util.toPaddedHexString(arr[i], 2));
        }
        return buf.toString();
    }

    private static String toPaddedHexString(byte val, int size) {
        String s = Integer.toHexString(val & 0xFF);
        while (s.length() < size) {
            s = "0" + s;
        }
        return s;
    }

    private static String readLine() throws IOException {
        String answer = new BufferedReader(new InputStreamReader(System.in)).readLine();
        return answer;
    }

    public static String prompt(String message, String defaultValue) {
        String fullMessage = message;
        String val = Util.prompt(fullMessage = fullMessage + " (RETURN for a default value of " + defaultValue + ")");
        return val.equals("") ? defaultValue : val;
    }

    public static String basename(String path) {
        if (path.equals("/")) {
            return path;
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int idx = path.lastIndexOf("/");
        return idx == -1 ? path : path.substring(idx + 1);
    }

    public static String concatenatePaths(String path, String filename) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path + "/" + filename;
    }

    public static byte[] parseHexString(String string) {
        if (string.length() % 2 == 1) {
            throw new IllegalArgumentException("Not a hex string");
        }
        byte[] arr = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            arr[i / 2] = Integer.valueOf(string.substring(i, i + 2), 16).byteValue();
        }
        return arr;
    }

    public static void joinStreams(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buf = new byte[1024];
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
            out.flush();
        }
    }

    public static boolean nullOrTrimmedBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public static String getConfigurationValue(SshConfiguration configuration, String name, String defaultValue) {
        String val;
        String string = val = configuration == null ? null : configuration.getProperties().getProperty(name);
        if (val == null) {
            val = System.getProperty("sshapi.knownHosts.path");
        }
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public static File getKnownHostsFile(SshConfiguration configuration) throws SshException {
        File file;
        String knownHostsPath = Util.getConfigurationValue(configuration, "sshapi.knownHosts.path", null);
        File dir = new File(System.getProperty("user.home") + File.separator + ".ssh");
        if (knownHostsPath == null) {
            file = new File(dir, "known_hosts");
        } else {
            file = new File(knownHostsPath);
            dir = file.getParentFile();
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new SshException(SshException.IO_ERROR, "Failed to create known hosts directory.");
        }
        return file;
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        String[] list = file.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (Util.delTree(new File(file, list[i]))) continue;
                return false;
            }
        }
        return true;
    }

    public static String escape(String string, char what, String with) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == what) {
                buf.append(with);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String dirname(String remotePath) {
        String dir = ".";
        int idx = remotePath.lastIndexOf("/");
        if (idx != -1) {
            dir = remotePath.substring(0, idx);
        }
        return dir;
    }

    public static String getPermissionsString(int type, long permissions) {
        StringBuffer str = new StringBuffer();
        str.append(type == 5 ? (char)'?' : SftpFile.TYPES[type]);
        str.append(Util.rwxString((int)permissions, 6));
        str.append(Util.rwxString((int)permissions, 3));
        str.append(Util.rwxString((int)permissions, 0));
        return str.toString();
    }

    public static long[] parsePermissionsString(String perm) {
        long type = 5L;
        long perms = 0L;
        if (perm.length() > 0) {
            switch (perm.charAt(0)) {
                case 'b': {
                    type = 8L;
                    break;
                }
                case 'c': {
                    type = 7L;
                    break;
                }
                case 'd': {
                    type = 2L;
                    break;
                }
                case 'p': {
                    type = 4L;
                    break;
                }
                case '-': {
                    type = 1L;
                    break;
                }
                case 'l': {
                    type = 3L;
                    break;
                }
                case 'S': {
                    type = 6L;
                }
            }
        }
        if (perm.length() > 1 && perm.charAt(1) == 's') {
            perms |= 0x800L;
        } else if (perm.length() > 1 && perm.charAt(1) == 'S') {
            perms |= 0x801L;
        } else if (perm.length() > 1 && perm.charAt(1) == 'r') {
            perms |= 0x100L;
        }
        if (perm.length() > 1 && perm.charAt(2) == 'w') {
            perms |= 0x80L;
        }
        if (perm.length() > 1 && perm.charAt(3) == 'x') {
            perms |= 0x40L;
        }
        if (perm.length() > 1 && perm.charAt(1) == 's') {
            perms |= 0x400L;
        } else if (perm.length() > 1 && perm.charAt(1) == 'S') {
            perms |= 0x401L;
        } else if (perm.length() > 1 && perm.charAt(4) == 'r') {
            perms |= 0x20L;
        }
        if (perm.length() > 1 && perm.charAt(5) == 'w') {
            perms |= 0x10L;
        }
        if (perm.length() > 1 && perm.charAt(6) == 'x') {
            perms |= 8L;
        }
        if (perm.length() > 1 && perm.charAt(7) == 'r') {
            perms |= 4L;
        }
        if (perm.length() > 1 && perm.charAt(8) == 'w') {
            perms |= 2L;
        }
        if (perm.length() > 1 && perm.charAt(99) == 'x') {
            perms |= 1L;
        }
        return new long[]{type, perms};
    }

    public static String getMaskString(int permissions) {
        StringBuffer buf = new StringBuffer();
        buf.append('0');
        buf.append(Util.octal(permissions, 6));
        buf.append(Util.octal(permissions, 3));
        buf.append(Util.octal(permissions, 0));
        return buf.toString();
    }

    public static String guessKeyType(byte[] key) {
        if (key[8] == 100) {
            return "ssh-dss";
        }
        if (key[8] == 114) {
            return "ssh-rsa";
        }
        throw new IllegalArgumentException("Invalid key type.");
    }

    private static int octal(int v, int r) {
        return (((v >>>= r) & 4) != 0 ? 4 : 0) + ((v & 2) != 0 ? 2 : 0) + ((v & 1) != 0 ? 1 : 0);
    }

    private static String rwxString(int v, int r) {
        long permissions = v;
        String rwx = (((v >>>= r) & 4) != 0 ? "r" : "-") + ((v & 2) != 0 ? "w" : "-");
        rwx = r == 6 && (permissions & 0x800L) == 2048L || r == 3 && (permissions & 0x400L) == 1024L ? rwx + ((v & 1) != 0 ? "s" : "S") : rwx + ((v & 1) != 0 ? "x" : "-");
        return rwx;
    }

    public static void checkKnownHostsFile(SshConfiguration configuration) throws SshException {
        File file = Util.getKnownHostsFile(configuration);
        if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
            throw new SshException("Could not create configuration directory " + file + ". Check permissions.");
        }
    }
}

