/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshPasswordPrompt;
import net.sf.sshapi.auth.SshPublicKeyAuthenticator;

public class PEMFilePublicKeyAuthenticator
implements SshPublicKeyAuthenticator {
    private SshPasswordPrompt passphrasePrompt;
    private byte[] privateKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEMFilePublicKeyAuthenticator(SshPasswordPrompt passphrasePrompt, File pemFile) throws IOException {
        this.passphrasePrompt = passphrasePrompt;
        byte[] buff = new byte[256];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fin = new FileInputStream(pemFile);
        try {
            int len;
            while ((len = fin.read(buff)) >= 0) {
                baos.write(buff, 0, len);
            }
            this.privateKey = baos.toByteArray();
        }
        finally {
            fin.close();
        }
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public char[] promptForPassphrase(SshClient session, String message) {
        return this.passphrasePrompt.promptForPassword(session, message);
    }

    public String getTypeName() {
        return "publickey";
    }
}

